/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.patterns.NullPatternRecognizer;
import com.tssap.selena.cmf.patterns.IPatternCategory;
import com.tssap.selena.cmf.patterns.IPatternExtension;
import com.tssap.selena.cmf.patterns.IPatternRecognizer;
import com.tssap.selena.cmf.patterns.IPatternRegistry;
import java.util.ArrayList;
import java.util.HashMap;

public class PatternRegistry
implements IPatternRegistry {
    private HashMap categoryMap = new HashMap();
    private ArrayList categoryList = new ArrayList();
    private IPatternCategory[] categories;
    private HashMap extensionMap = new HashMap();
    private ArrayList extensionList = new ArrayList();
    private IPatternExtension[] extensions;
    private HashMap recognizerMap = new HashMap();
    private ArrayList recognizerList = new ArrayList();
    private IPatternRecognizer[] recognizers;

    public PatternRegistry() {
        this.addRecognizer(NullPatternRecognizer.getInstance());
    }

    public void addCategory(IPatternCategory entry) {
        this.categoryMap.put(entry.getId(), entry);
        this.categoryList.add(entry);
        this.categories = null;
    }

    public void setDefaultCategory(IPatternCategory entry) {
        this.categoryMap.put(null, entry);
        this.addCategory(entry);
    }

    public IPatternCategory[] getCategories() {
        if (this.categories == null) {
            this.categories = this.categoryList.toArray(new IPatternCategory[this.categoryList.size()]);
        }
        return this.categories;
    }

    public IPatternCategory getCategory(Object id) {
        return (IPatternCategory)this.categoryMap.get(id);
    }

    public void addExtension(IPatternExtension entry) {
        this.extensionMap.put(entry.getId(), entry);
        this.extensionList.add(entry);
        this.extensions = null;
    }

    public IPatternExtension[] getExtensions() {
        if (this.extensions == null) {
            this.extensions = this.extensionList.toArray(new IPatternExtension[this.extensionList.size()]);
        }
        return this.extensions;
    }

    public IPatternExtension getExtension(Object id) {
        return (IPatternExtension)this.extensionMap.get(id);
    }

    public void addRecognizer(IPatternRecognizer entry) {
        CodePlugin.debug("addRecognizer: " + entry);
        this.recognizerMap.put(entry.getId(), entry);
        this.recognizerList.add(entry);
        this.recognizers = null;
    }

    public IPatternRecognizer[] getRecognizers() {
        if (this.recognizers == null) {
            this.recognizers = this.recognizerList.toArray(new IPatternRecognizer[this.recognizerList.size()]);
        }
        return this.recognizers;
    }

    public IPatternRecognizer getRecognizer(Object id) {
        return (IPatternRecognizer)this.recognizerMap.get(id);
    }
}

