/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.patterns.PatternPreference;
import com.tssap.selena.cmf.patterns.IPatternExtension;
import com.tssap.selena.cmf.patterns.IPatternPreference;
import com.tssap.selena.cmf.patterns.IPatternProjectPreferences;
import com.tssap.selena.cmf.patterns.IPatternRecognizer;
import com.tssap.selena.cmf.patterns.IPatternRegion;
import com.tssap.selena.cmf.patterns.IPatternRegistry;
import com.tssap.selena.cmf.patterns.Patterns;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ui.IMemento;

public class PatternProjectPreferences
extends PlatformObject
implements IPatternProjectPreferences {
    protected int mode = 1;
    protected IPatternRegion region;
    protected IPatternPreference[] preferences;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
    }

    public IPatternRegion getRegion() {
        return this.region;
    }

    public void setRegion(IPatternRegion region) {
        this.region = region;
    }

    public IPatternPreference[] getPreferences() {
        return this.preferences;
    }

    public void setPreferences(IPatternPreference[] preferences) {
        this.preferences = preferences;
    }

    public void saveState(IMemento memento) {
        memento.putInteger("mode", this.mode);
        if (this.region != null) {
            this.savePreferences(memento.createChild("region"), this.region);
        }
        if (this.preferences != null) {
            int i = 0;
            while (i < this.preferences.length) {
                this.savePreferences(memento.createChild("pattern"), this.preferences[i]);
                ++i;
            }
        }
    }

    private void savePreferences(IMemento memento, IPatternPreference pref) {
        memento.putString("id", pref.getExtension().getId());
        memento.putString("enable", pref.getEnable() ? "true" : "false");
        memento.putString("recognizer", pref.getRecognizer().getId());
    }

    private void savePreferences(IMemento memento, IPatternRegion region) {
        memento.putString("include", region.getInclude());
        memento.putString("exclude", region.getExclude());
    }

    public void restoreState(IMemento memento) {
        IMemento[] children;
        Integer value = memento.getInteger("mode");
        this.mode = value == null ? 1 : value;
        IMemento child = memento.getChild("region");
        if (child != null) {
            this.restorePreferences(child, this.getRegion());
        }
        if ((children = memento.getChildren("pattern")) != null) {
            this.preferences = this.getDefaultPreferences();
            int i = 0;
            while (i < children.length) {
                PatternPreference entry = this.createPatternPreference(children[i]);
                if (entry != null) {
                    this.updatePatternPreference(entry);
                }
                ++i;
            }
        }
    }

    private IPatternPreference[] getDefaultPreferences() {
        IPatternPreference[] defaults = Patterns.getDefaultProjectPreferences().getPreferences();
        IPatternPreference[] preferences = new IPatternPreference[defaults.length];
        int i = 0;
        while (i < preferences.length) {
            preferences[i] = new PatternPreference(defaults[i]);
            ++i;
        }
        return preferences;
    }

    private void updatePatternPreference(IPatternPreference pref) {
        IPatternExtension extension = pref.getExtension();
        int i = 0;
        while (i < this.preferences.length) {
            if (extension == this.preferences[i].getExtension()) {
                this.preferences[i] = pref;
                break;
            }
            ++i;
        }
    }

    private void restorePreferences(IMemento memento, IPatternRegion region) {
        String include = memento.getString("include");
        region.setInclude(include);
        String exclude = memento.getString("exclude");
        region.setExclude(exclude);
    }

    private PatternPreference createPatternPreference(IMemento memento) {
        String id;
        IPatternRegistry registry = Patterns.getRegistry();
        IPatternExtension extension = registry.getExtension(id = memento.getString("id"));
        if (extension == null) {
            return null;
        }
        id = memento.getString("recognizer");
        IPatternRecognizer recognizer = registry.getRecognizer(id);
        if (recognizer == null) {
            return null;
        }
        boolean enable = "true".equals(memento.getString("enable"));
        return new PatternPreference(extension, recognizer, enable);
    }
}

