/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.patterns.IConstants;
import com.tssap.selena.cmf.internal.patterns.PatternManager;
import com.tssap.selena.cmf.internal.patterns.PatternModel;
import com.tssap.selena.cmf.internal.patterns.PatternProjectPreferences;
import com.tssap.selena.cmf.patterns.IPatternBuilder;
import com.tssap.selena.cmf.patterns.IPatternCategory;
import com.tssap.selena.cmf.patterns.IPatternExtension;
import com.tssap.selena.cmf.patterns.IPatternManager;
import com.tssap.selena.cmf.patterns.IPatternPreference;
import com.tssap.selena.cmf.patterns.IPatternProject;
import com.tssap.selena.cmf.patterns.IPatternRecognizer;
import com.tssap.selena.cmf.patterns.IPatternRegion;
import com.tssap.selena.cmf.patterns.Patterns;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IMemento;

public final class PatternProject
extends PatternProjectPreferences
implements IPatternProject {
    private IProject project;
    private PatternManager[] managers;
    private IPatternBuilder[] builders;
    private boolean open;

    public PatternProject(IProject project) {
        this.mode = -1;
        this.project = project;
        IPatternExtension[] exts = Patterns.getExtensions();
        this.managers = new PatternManager[exts.length];
        int i = 0;
        while (i < exts.length) {
            this.managers[i] = new PatternManager(this, exts[i]);
            ++i;
        }
    }

    public String toString() {
        return "<PatternProject id=" + Integer.toHexString(this.hashCode()) + " name=" + this.getName() + " />";
    }

    public String getName() {
        return this.project.getName();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public IProject getProject() {
        return this.project;
    }

    public IPatternManager[] getManagers() {
        return this.managers;
    }

    public IPatternBuilder[] getBuilders() {
        if (this.builders == null) {
            IPatternRecognizer[] recognizers = this.getActiveRecognizers();
            this.builders = new IPatternBuilder[recognizers.length];
            int i = 0;
            while (i < recognizers.length) {
                IPatternRecognizer recognizer = recognizers[i];
                this.builders[i] = recognizer.createBuilder();
                this.builders[i].setProject(this);
                this.builders[i].setActivePatterns(this.getActivePatterns(recognizer));
                ++i;
            }
        }
        return this.builders;
    }

    private IPatternRecognizer[] getActiveRecognizers() {
        HashSet<IPatternRecognizer> bag = new HashSet<IPatternRecognizer>();
        IPatternPreference[] preferences = this.getPreferences();
        int i = 0;
        while (i < preferences.length) {
            IPatternPreference preference = preferences[i];
            if (preference.getEnable() && preference.getRecognizer() != null) {
                bag.add(preference.getRecognizer());
            }
            ++i;
        }
        return ((AbstractCollection)bag).toArray(new IPatternRecognizer[bag.size()]);
    }

    private IPatternExtension[] getActivePatterns(IPatternRecognizer recognizer) {
        ArrayList<IPatternExtension> bag = new ArrayList<IPatternExtension>();
        IPatternPreference[] preferences = this.getPreferences();
        int i = 0;
        while (i < preferences.length) {
            IPatternPreference preference = preferences[i];
            if (preference.getEnable() && recognizer == preference.getRecognizer()) {
                bag.add(preference.getExtension());
            }
            ++i;
        }
        return bag.toArray(new IPatternExtension[bag.size()]);
    }

    public int getMode() {
        if (this.mode < 0) {
            this.mode = Patterns.getDefaultProjectPreferences().getMode();
        }
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException();
        }
        int oldMode = this.mode;
        this.mode = mode;
        if (oldMode != mode && mode == 0) {
            int i = 0;
            while (i < this.managers.length) {
                this.managers[i].setPatterns(IConstants.EMPTY_PATTERNS);
                ++i;
            }
            PatternModel.projectChanged(this, this.getManagers());
        }
    }

    public IPatternRegion getRegion() {
        if (this.region == null) {
            this.region = Patterns.newPatternRegion(this, Patterns.getDefaultProjectPreferences().getRegion());
        }
        return this.region;
    }

    public void setRegion(IPatternRegion region) {
        this.region = region;
        if (this.builders != null) {
            int i = 0;
            while (i < this.builders.length) {
                this.builders[i].setProject(this);
                ++i;
            }
        }
    }

    public IPatternPreference[] getPreferences() {
        if (this.preferences == null) {
            this.preferences = Patterns.getDefaultProjectPreferences().getPreferences();
        }
        return this.preferences;
    }

    public IPatternPreference[] getPreferences(IPatternCategory category) {
        ArrayList<IPatternPreference> children = new ArrayList<IPatternPreference>();
        IPatternPreference[] prefs = this.getPreferences();
        int i = 0;
        while (i < prefs.length) {
            if (category == prefs[i].getExtension().getCategory()) {
                children.add(prefs[i]);
            }
            ++i;
        }
        return children.toArray(new IPatternPreference[children.size()]);
    }

    public void setPreferences(IPatternPreference[] preferences) {
        this.preferences = preferences;
        this.builders = null;
        IPatternManager[] managers = this.getManagers();
        ArrayList<IPatternManager> changedManagers = new ArrayList<IPatternManager>(managers.length);
        int i = 0;
        while (i < preferences.length) {
            IPatternPreference preference = preferences[i];
            if (!preference.getEnable()) {
                IPatternExtension extension = preference.getExtension();
                int j = 0;
                while (j < managers.length) {
                    IPatternManager manager = managers[j];
                    if (extension == manager.getExtension() && !manager.isEmpty()) {
                        manager.setPatterns(IConstants.EMPTY_PATTERNS);
                        changedManagers.add(manager);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!changedManagers.isEmpty()) {
            PatternModel.projectChanged(this, changedManagers.toArray(new IPatternManager[changedManagers.size()]));
        }
    }

    public void saveState(IMemento memento) {
        int i = 0;
        while (i < this.managers.length) {
            PatternManager manager = this.managers[i];
            if (!manager.isEmpty()) {
                String id = manager.getExtension().getId();
                manager.saveState(memento.createChild(id));
            }
            ++i;
        }
        super.saveState(memento.createChild("_preferences"));
    }

    public void restoreState(IMemento memento) {
        int i = 0;
        while (i < this.managers.length) {
            PatternManager manager = this.managers[i];
            String id = manager.getExtension().getId();
            IMemento child = memento.getChild(id);
            if (child != null) {
                manager.restoreState(child);
            }
            ++i;
        }
        IMemento child = memento.getChild("_preferences");
        if (child != null) {
            super.restoreState(child);
        }
    }
}

