/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.PluginConstants;
import com.tssap.selena.cmf.internal.patterns.PatternModel;
import com.tssap.selena.cmf.patterns.IPatternProject;
import com.tssap.selena.cmf.patterns.Patterns;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.swt.widgets.Display;

public final class PatternNature
extends PlatformObject
implements IProjectNature,
PluginConstants {
    protected IProject project;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void configure() throws CoreException {
        CodePlugin.debug("configure: project={0}", this.project);
        this.addBuilder("com.tssap.selena.cmf.PatternBuilder");
        this.getPatternModel().addProject(this.project);
        IPatternProject pp = this.getPatternModel().getProject(this.project);
        if (pp.getMode() != 2) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    PatternNature.this.project.build(6, "com.tssap.selena.cmf.PatternBuilder", null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void deconfigure() throws CoreException {
        CodePlugin.debug("deconfigure: project={0}", this.project);
        this.removeBuilder("com.tssap.selena.cmf.PatternBuilder");
        this.getPatternModel().removeProject(this.project);
    }

    private PatternModel getPatternModel() {
        return (PatternModel)Patterns.getModel();
    }

    protected void addBuilder(String id) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(id)) {
                return;
            }
            ++i;
        }
        ICommand command = description.newCommand();
        command.setBuilderName(id);
        ICommand[] spec = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, spec, 0, commands.length);
        spec[commands.length] = command;
        description.setBuildSpec(spec);
        this.getProject().setDescription(description, null);
    }

    protected void removeBuilder(String id) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(id)) {
                ICommand[] spec = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, spec, 0, i);
                System.arraycopy(commands, i + 1, spec, i, commands.length - i - 1);
                description.setBuildSpec(spec);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }
}

