/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.PluginConstants;
import com.tssap.selena.cmf.internal.patterns.PatternProject;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternManager;
import com.tssap.selena.cmf.patterns.IPatternModel;
import com.tssap.selena.cmf.patterns.IPatternModelListener;
import com.tssap.selena.cmf.patterns.IPatternProject;
import com.tssap.selena.cmf.patterns.IPatternVisitor;
import com.tssap.selena.cmf.patterns.Patterns;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMemento;

public class PatternModel
implements IPatternModel,
PluginConstants,
IResourceChangeListener,
IResourceDeltaVisitor {
    private boolean sync;
    private IPatternProject[] projects;
    private final HashMap projectMap = new HashMap();
    private final ArrayList listeners = new ArrayList(5);

    public PatternModel() {
        CodePlugin.getInstance();
        IWorkspace workspace = CodePlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this, 22);
    }

    public String toString() {
        return "<PatternModel id=" + Integer.toHexString(this.hashCode()) + " />";
    }

    private void ensureSync() {
        if (!this.sync) {
            this.sync = true;
            this.sync();
        }
    }

    private void sync() {
        CodePlugin.getInstance();
        IWorkspace workspace = CodePlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            try {
                if (project.isOpen()) {
                    if (project.hasNature("com.tssap.selena.cmf.PatternNature")) {
                        this.addProject(project);
                    } else if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        CodeToolkit.addNature(project, "com.tssap.selena.cmf.PatternNature", null);
                    }
                }
            }
            catch (CoreException e) {
                CodePlugin.warn("cannot add pattern project", e);
            }
            ++i;
        }
    }

    public IPatternProject getProject(IProject project) {
        if (project == null || !project.isOpen()) {
            return null;
        }
        String name = project.getName();
        IPatternProject pp = this.getProject(name);
        if (pp == null) {
            this.registerProjectIfIsPattern(project);
            pp = this.getProject(name);
        }
        return pp;
    }

    public IPatternProject createProject(IProject project) {
        IPatternProject pp = this.getProject(project);
        if (pp != null) {
            return pp;
        }
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                CodeToolkit.addNature(project, "com.tssap.selena.cmf.PatternNature", null);
            }
            return this.getProject(project);
        }
        catch (CoreException ex) {
            CodePlugin.warn("IPatternModel.createProject() failed", ex);
            return null;
        }
    }

    private void registerProjectIfIsPattern(IProject candidate) {
        try {
            if (candidate.hasNature("com.tssap.selena.cmf.PatternNature")) {
                this.addProject(candidate);
            }
        }
        catch (CoreException e) {
            CodePlugin.warn("cannot create pattern project", e);
        }
    }

    private IPatternProject getProject(String name) {
        return (IPatternProject)this.projectMap.get(name);
    }

    public IPatternProject[] getProjects() {
        this.ensureSync();
        if (this.projects == null) {
            Collection values = this.projectMap.values();
            this.projects = values.toArray(new IPatternProject[values.size()]);
        }
        return this.projects;
    }

    void addProject(IProject resource) {
        String name;
        if (resource.isOpen() && !this.projectMap.containsKey(name = resource.getName())) {
            CodePlugin.debug("adding pattern project {0}", name);
            PatternProject project = new PatternProject(resource);
            project.setOpen(true);
            this.projectMap.put(name, project);
            this.projects = null;
            this.fireProjectAdded(project);
        }
    }

    void openProject(IProject resource) {
        String name = resource.getName();
        IPatternProject project = (IPatternProject)this.projectMap.get(name);
        if (project != null) {
            CodePlugin.debug("opening pattern project {0}", name);
            ((PatternProject)project).setOpen(true);
            this.fireProjectAdded(project);
        } else {
            this.addProject(resource);
        }
    }

    void removeProject(IProject resource) {
        String name = resource.getName();
        IPatternProject project = (IPatternProject)this.projectMap.remove(name);
        if (project != null) {
            CodePlugin.debug("removing pattern project {0}", name);
            ((PatternProject)project).setOpen(false);
            this.projects = null;
            this.fireProjectRemoved(project);
        }
    }

    void closeProject(IProject resource) {
        String name = resource.getName();
        IPatternProject project = (IPatternProject)this.projectMap.get(name);
        if (project != null) {
            CodePlugin.debug("closing pattern project {0}", name);
            ((PatternProject)project).setOpen(false);
            this.fireProjectRemoved(project);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: {
                this.closeProject((IProject)event.getResource());
                break;
            }
            case 4: {
                this.removeProject((IProject)event.getResource());
                break;
            }
            case 16: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    break;
                }
                catch (CoreException e) {
                    CodePlugin.error(this.getClass().getName(), e);
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                return this.visitProject(delta, (IProject)resource);
            }
        }
        return false;
    }

    private boolean isSynchronized() {
        return this.sync;
    }

    private boolean visitProject(IResourceDelta delta, IProject project) throws CoreException {
        if (delta.getKind() == 1 && this.isSynchronized() && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
            try {
                CodeToolkit.addNature(project, "com.tssap.selena.cmf.PatternNature", null);
            }
            catch (CoreException ex) {
                CodePlugin.warn("cannot add pattern project", ex);
            }
        }
        if ((delta.getFlags() & 0x4000) != 0 && project.isOpen() && project.hasNature("com.tssap.selena.cmf.PatternNature")) {
            this.openProject(project);
        }
        return false;
    }

    public void addListener(IPatternModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IPatternModelListener listener) {
        ((AbstractCollection)this.listeners).remove(listener);
    }

    public static void projectAdded(IPatternProject project) {
        CodePlugin.getInstance().getPatternModel().fireProjectAdded(project);
    }

    public void fireProjectAdded(IPatternProject project) {
        if (this.listeners.size() == 0) {
            return;
        }
        IPatternModelListener[] targets = this.getListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].projectAdded(project);
            ++i;
        }
    }

    public static void projectRemoved(IPatternProject project) {
        CodePlugin.getInstance().getPatternModel().fireProjectRemoved(project);
    }

    public void fireProjectRemoved(IPatternProject project) {
        if (this.listeners.size() == 0) {
            return;
        }
        IPatternModelListener[] targets = this.getListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].projectRemoved(project);
            ++i;
        }
    }

    public static void projectChanged(IPatternProject project, IPatternManager[] managers) {
        CodePlugin.getInstance().getPatternModel().fireProjectChanged(project, managers);
    }

    public void fireProjectChanged(IPatternProject project, IPatternManager[] managers) {
        if (this.listeners.size() == 0) {
            return;
        }
        IPatternModelListener[] targets = this.getListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].projectChanged(project, managers);
            ++i;
        }
    }

    private IPatternModelListener[] getListeners() {
        IPatternModelListener[] empty = new IPatternModelListener[]{};
        int count = this.listeners.size();
        if (count == 0) {
            return empty;
        }
        return this.listeners.toArray(new IPatternModelListener[count]);
    }

    public void saveState(IMemento memento) {
        IPatternProject[] projects = this.getProjects();
        int i = 0;
        while (i < projects.length) {
            PatternProject project = (PatternProject)projects[i];
            String name = project.getProject().getName();
            project.saveState(memento.createChild("project", name));
            ++i;
        }
        Patterns.getDefaultProjectPreferences().saveState(memento.createChild("defaults"));
    }

    public void restoreState(IMemento memento) {
        IMemento[] children = memento.getChildren("project");
        if (children.length > 0) {
            this.ensureSync();
        }
        int i = 0;
        while (i < children.length) {
            IMemento child = children[i];
            IPatternProject project = this.getProject(child.getID());
            if (project instanceof PatternProject) {
                ((PatternProject)project).restoreState(child);
            }
            ++i;
        }
        IMemento defaults = memento.getChild("defaults");
        if (defaults != null) {
            Patterns.getDefaultProjectPreferences().restoreState(defaults);
        }
    }

    public void accept(IPatternVisitor visitor) {
        Iterator it = this.projectMap.values().iterator();
        while (it.hasNext()) {
            IPatternProject next = (IPatternProject)it.next();
            if (!visitor.visit(next)) continue;
            IPatternManager[] pm = next.getManagers();
            int j = 0;
            while (j < pm.length) {
                if (visitor.visit(pm[j])) {
                    IPattern[] patterns = pm[j].getPatterns();
                    int k = 0;
                    while (k < patterns.length && visitor.visit(patterns[k])) {
                        ++k;
                    }
                }
                ++j;
            }
        }
    }

    public static void validate(Collection patterns) {
        HashMap<IPatternManager, HashSet<IPattern>> managers2Patterns = new HashMap<IPatternManager, HashSet<IPattern>>();
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            IPattern next = (IPattern)it.next();
            if (next.exists()) continue;
            HashSet<IPattern> patterns2remove = (HashSet<IPattern>)managers2Patterns.get(next.getPatternManager());
            if (patterns2remove == null) {
                patterns2remove = new HashSet<IPattern>();
                managers2Patterns.put(next.getPatternManager(), patterns2remove);
            }
            patterns2remove.add(next);
        }
        Iterator it2 = managers2Patterns.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry next = it2.next();
            IPatternManager pm = (IPatternManager)next.getKey();
            LinkedList<IPattern> temp = new LinkedList<IPattern>(Arrays.asList(pm.getPatterns()));
            temp.removeAll((Set)next.getValue());
            pm.setPatterns(temp.toArray(new IPattern[temp.size()]));
        }
    }

    public static void fireModelChanges(Collection patterns) {
        HashMap<IPatternProject, HashSet<IPatternManager>> affectedProjects2Managers = new HashMap<IPatternProject, HashSet<IPatternManager>>();
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            IPattern next = (IPattern)it.next();
            HashSet<IPatternManager> managers = (HashSet<IPatternManager>)affectedProjects2Managers.get(next.getPatternManager().getProject());
            if (managers == null) {
                managers = new HashSet<IPatternManager>();
                affectedProjects2Managers.put(next.getPatternManager().getProject(), managers);
            }
            managers.add(next.getPatternManager());
        }
        Iterator it2 = affectedProjects2Managers.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            Set managers = (Set)entry.getValue();
            PatternModel.projectChanged((IPatternProject)entry.getKey(), managers.toArray(new IPatternManager[managers.size()]));
        }
    }
}

