/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.patterns.IConstants;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternExtension;
import com.tssap.selena.cmf.patterns.IPatternManager;
import com.tssap.selena.cmf.patterns.IPatternProject;
import com.tssap.selena.cmf.patterns.IPatternProperty;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.IPropertySupport;
import com.tssap.selena.ui.Properties;
import java.util.ArrayList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ui.IMemento;

public class PatternManager
extends PlatformObject
implements IPatternManager {
    private final IPatternProject myProject;
    private final IPatternExtension myExtension;
    private boolean myIsChanged;
    private IPattern[] myPatterns;

    public PatternManager(IPatternProject project, IPatternExtension extension) {
        this.myProject = project;
        this.myExtension = extension;
        this.myPatterns = IConstants.EMPTY_PATTERNS;
    }

    public String toString() {
        return "<PatternManager id=" + Integer.toHexString(this.hashCode()) + " project=" + this.myProject + " extension=" + this.myExtension.getName() + " patterns=" + this.myPatterns.length + " />";
    }

    public final String getName() {
        return this.myExtension.getName();
    }

    public final IPatternProject getProject() {
        return this.myProject;
    }

    public final IPatternExtension getExtension() {
        return this.myExtension;
    }

    public boolean isEmpty() {
        return this.myPatterns.length == 0;
    }

    public boolean isChanged() {
        return this.myIsChanged;
    }

    public void setChanged(boolean changed) {
        this.myIsChanged = changed;
    }

    public IPattern[] getPatterns() {
        return this.myPatterns;
    }

    public void setPatterns(IPattern[] newPatterns) {
        if (!this.equals(newPatterns)) {
            this.setChanged(true);
            this.myPatterns = newPatterns;
            if (this.myPatterns == null) {
                this.myPatterns = IConstants.EMPTY_PATTERNS;
            }
        }
    }

    private boolean equals(IPattern[] newPatterns) {
        return this.myPatterns.length == 0 && (newPatterns == null || newPatterns.length == 0);
    }

    private static boolean contains(IPattern[] patterns, IPattern pattern) {
        int i = 0;
        while (i < patterns.length) {
            if (pattern == patterns[i] || pattern.equals(patterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void update(IPattern[] newPatterns, boolean keepExistingPatterns) {
        if (newPatterns == null) {
            newPatterns = IConstants.EMPTY_PATTERNS;
        }
        newPatterns = PatternManager.mergePatterns(newPatterns, this.getPatterns(), keepExistingPatterns);
        this.setPatterns(newPatterns);
    }

    private static IPattern[] mergePatterns(IPattern[] newPatterns, IPattern[] oldPatterns, boolean preserveStillExisting) {
        if (oldPatterns.length == 0) {
            int i = 0;
            while (i < newPatterns.length) {
                newPatterns[i].setValid(true);
                ++i;
            }
            return newPatterns;
        }
        ArrayList<IPattern> patterns = new ArrayList<IPattern>();
        int i = 0;
        while (i < newPatterns.length) {
            IPattern pattern = newPatterns[i];
            int j = 0;
            while (j < oldPatterns.length) {
                if (pattern.equals(oldPatterns[j])) {
                    PatternManager.copyPattern(pattern, oldPatterns[j]);
                    pattern = oldPatterns[j];
                    oldPatterns[j] = null;
                    break;
                }
                ++j;
            }
            pattern.setValid(true);
            patterns.add(pattern);
            ++i;
        }
        if (preserveStillExisting) {
            int i2 = 0;
            while (i2 < oldPatterns.length) {
                IPattern pattern = oldPatterns[i2];
                if (pattern != null && pattern.exists()) {
                    patterns.add(pattern);
                }
                ++i2;
            }
        }
        return patterns.toArray(new IPattern[patterns.size()]);
    }

    private static void copyPattern(IPattern src, IPattern dest) {
        IPatternProperty[] properties = src.getProperties();
        int i = 0;
        while (i < properties.length) {
            IPatternProperty property = properties[i];
            Object value = src.getPropertyValue(property);
            dest.setPropertyValue(property, value);
            ++i;
        }
        dest.setName(dest.getName());
    }

    void saveState(IMemento memento) {
        IPattern[] patterns = this.getPatterns();
        int i = 0;
        while (i < patterns.length) {
            try {
                this.savePattern(memento.createChild("pattern"), patterns[i]);
            }
            catch (IllegalArgumentException e) {
                CodePlugin.error("cannot save pattern", e);
            }
            ++i;
        }
    }

    void savePattern(IMemento memento, IPattern pattern) {
        IPatternProperty[] properties = this.myExtension.getProperties();
        int i = 0;
        while (i < properties.length) {
            IPropertyMarshaler marshaler;
            IPatternProperty property = properties[i];
            Object value = pattern.getPropertyValue(property);
            if (value != null && (marshaler = this.getPropertyMarshaler(property.getType())) != null) {
                String sval = marshaler.marshal(value);
                memento.putString(property.getName(), sval);
            }
            ++i;
        }
    }

    void restoreState(IMemento memento) {
        IMemento[] children = memento.getChildren("pattern");
        if (children == null) {
            return;
        }
        ArrayList<IPattern> patterns = new ArrayList<IPattern>(children.length);
        int i = 0;
        while (i < children.length) {
            try {
                IPattern pattern = this.restorePattern(children[i]);
                if (pattern.exists()) {
                    pattern.setValid(true);
                    patterns.add(pattern);
                } else {
                    CodePlugin.error("invalid pattern: " + pattern);
                }
            }
            catch (Exception ex) {
                CodePlugin.warn("PatternManager failed to restore pattern", ex);
            }
            ++i;
        }
        this.myPatterns = patterns.toArray(new IPattern[patterns.size()]);
    }

    IPattern restorePattern(IMemento memento) {
        IPattern pattern = this.myExtension.createPattern(this);
        IPatternProperty[] properties = this.myExtension.getProperties();
        int i = 0;
        while (i < properties.length) {
            IPatternProperty property = properties[i];
            String sval = memento.getString(property.getName());
            if (sval != null) {
                IPropertyMarshaler marshaler = this.getPropertyMarshaler(property.getType());
                Object value = marshaler.unmarshal(sval);
                pattern.setPropertyValue(property, value);
            }
            ++i;
        }
        return pattern;
    }

    private IPropertyMarshaler getPropertyMarshaler(String type) {
        IPropertySupport support = Properties.getPropertySupport((String)type);
        if (support != null) {
            return support.getPropertyMarshaler();
        }
        CodePlugin.error("no property marshaler for " + type);
        return null;
    }
}

