/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternHandler;
import com.tssap.selena.cmf.patterns.IPatternProperty;
import com.tssap.selena.cmf.patterns.PatternException;
import java.lang.reflect.Array;
import org.eclipse.core.runtime.CoreException;

public abstract class PatternHandler
implements IPatternHandler {
    protected IPattern pattern;
    protected IPatternProperty property;

    public void init(IPattern pattern) throws CoreException {
        this.pattern = pattern;
    }

    public void setParticipant(String name, Object value) throws CoreException {
        if (!this.canSetParticipant(value)) {
            throw new PatternException("illegal participant " + value);
        }
        this.setParticipant(value);
        this.pattern.setPropertyValue(this.property, value);
    }

    protected abstract void setParticipant(Object var1) throws CoreException;

    public void addParticipant(String name, Object value) throws CoreException {
        if (!this.canAddParticipant(value)) {
            throw new PatternException("illegal participant " + value);
        }
        this.addParticipant(value);
        Object[] oldValues = (Object[])this.pattern.getPropertyValue(this.property);
        Object[] newValues = (Object[])Array.newInstance(oldValues.getClass().getComponentType(), oldValues.length + 1);
        System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
        newValues[oldValues.length] = value;
        this.pattern.setPropertyValue(this.property, newValues);
    }

    protected abstract void addParticipant(Object var1) throws CoreException;

    public boolean canSetParticipant(String name, Object value) {
        return this.canBecameParticipant(name, value) && this.canSetParticipant(value);
    }

    protected boolean canSetParticipant(Object value) {
        return true;
    }

    public boolean canAddParticipant(String name, Object value) {
        return this.canBecameParticipant(name, value) && this.canAddParticipant(value);
    }

    protected boolean canAddParticipant(Object value) {
        return this.property.isParticipant();
    }

    public boolean canBecameParticipant(String name, Object value) {
        IPatternProperty property = this.pattern.getProperty(name);
        return property == null ? false : property.isParticipant() && this.canBecameParticipant(value);
    }

    protected abstract boolean canBecameParticipant(Object var1);

    public void setParameter(String name, Object value) throws CoreException {
        if (!this.canSetParameter(value)) {
            throw new PatternException("illegal parameter " + value);
        }
        this.setParameter(value);
        this.pattern.setPropertyValue(this.property, value);
    }

    protected abstract void setParameter(Object var1) throws CoreException;

    public boolean canSetParameter(String name, Object value) {
        IPatternProperty property = this.pattern.getProperty(name);
        return property == null ? false : !property.isParticipant() && this.canSetParameter(value);
    }

    protected abstract boolean canSetParameter(Object var1);

    public abstract String[] getRecognizedParameters();

    public abstract String[] getRecognizedParticipants();

    public abstract boolean canAddParameter(String var1, Object var2);

    public abstract void addParameter(String var1, Object var2) throws CoreException;
}

