/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.patterns.BeanPatternProperty;
import com.tssap.selena.cmf.internal.patterns.NullPatternRecognizer;
import com.tssap.selena.cmf.internal.patterns.PatternCategory;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternCategory;
import com.tssap.selena.cmf.patterns.IPatternExtension;
import com.tssap.selena.cmf.patterns.IPatternHandler;
import com.tssap.selena.cmf.patterns.IPatternManager;
import com.tssap.selena.cmf.patterns.IPatternProperty;
import com.tssap.selena.cmf.patterns.IPatternRecognizer;
import com.tssap.selena.cmf.patterns.PatternException;
import com.tssap.selena.cmf.patterns.Patterns;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public abstract class PatternExtension
implements IExecutableExtension,
IPatternExtension {
    private static final String TAG_ROOT = "patterns";
    private static final String DEFAULT_RECOGNIZER = "rete";
    private String id;
    private String name;
    private String info;
    private Class handlerClass;
    private String helpContextId;
    private IConfigurationElement config;
    private PatternCategory category;
    private IPatternRecognizer recognizer;
    static /* synthetic */ Class class$com$tssap$selena$cmf$patterns$IPatternHandler;

    public void setInitializationData(IConfigurationElement config, String p, Object data) throws CoreException {
        if (p.equals("cooker")) {
            return;
        }
        this.config = config;
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.info = config.getAttribute("description");
        this.helpContextId = config.getAttribute("help");
        if (this.id == null) {
            throw new PatternException("invalid pattern extension (missing markup): " + config.getAttribute(p));
        }
        if (this.name == null) {
            this.name = this.id;
        }
        if (this.info == null) {
            this.info = this.name;
        }
        this.category = PatternExtension.getCategory(config.getAttribute("category"));
        if (this.category == null) {
            this.category = PatternExtension.getCategory(null);
        }
        if (this.id.indexOf(46) == -1) {
            this.id = this.category.getId() + "." + this.id;
        }
        this.category.addExtension(this);
        String handler = config.getAttribute("handler");
        if (handler != null) {
            this.handlerClass = CodeToolkit.getExtensionClass(config, handler, class$com$tssap$selena$cmf$patterns$IPatternHandler == null ? (class$com$tssap$selena$cmf$patterns$IPatternHandler = PatternExtension.class$("com.tssap.selena.cmf.patterns.IPatternHandler")) : class$com$tssap$selena$cmf$patterns$IPatternHandler);
        }
    }

    public IPatternRecognizer getRecognizer() {
        if (this.recognizer == null) {
            String id = this.config.getAttribute("recognizer");
            IPatternRecognizer iPatternRecognizer = this.recognizer = id == null ? null : Patterns.getRegistry().getRecognizer(id);
            if (this.recognizer == null) {
                this.recognizer = Patterns.getRegistry().getRecognizer(DEFAULT_RECOGNIZER);
                if (this.recognizer == null || !this.recognizer.canRecognize(this)) {
                    this.recognizer = NullPatternRecognizer.getInstance();
                }
            }
        }
        return this.recognizer;
    }

    public String getHelpContextId() {
        return this.helpContextId;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.config;
    }

    private static PatternCategory getCategory(String id) {
        return (PatternCategory)CodePlugin.getInstance().getPatternRegistry().getCategory(id);
    }

    private IPatternProperty createPatternProperty(Class cls, IConfigurationElement config) throws CoreException {
        String name = config.getAttribute("name");
        String type = config.getAttribute("type");
        if (name == null || type == null) {
            throw new PatternException("invalid pattern property: " + config);
        }
        return new BeanPatternProperty(cls, name, type);
    }

    public String toString() {
        return "<PatternExtension id=" + this.id + " name=" + this.name + " />";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.info;
    }

    public IPatternCategory getCategory() {
        return this.category;
    }

    public IPatternHandler createPatternHandler(IPattern pattern) {
        if (this.handlerClass != null) {
            try {
                IPatternHandler instance = (IPatternHandler)this.handlerClass.newInstance();
                instance.init(pattern);
                return instance;
            }
            catch (Exception e) {
                CodePlugin.error("cannot create pattern handler", e);
            }
        }
        return null;
    }

    public abstract IPattern createPattern(IPatternManager var1);

    public abstract IPatternProperty[] getProperties();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

