/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternAction;
import com.tssap.selena.cmf.patterns.IPatternProperty;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class PatternAction
extends Action
implements IPatternAction,
IExecutableExtension {
    protected IPattern pattern;

    public void init(IPattern pattern) {
        this.pattern = pattern;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String label = config.getAttribute("label");
        String icon = config.getAttribute("icon");
        super.setText(label);
        if (icon != null) {
            IPluginDescriptor descriptor = config.getDeclaringExtension().getDeclaringPluginDescriptor();
            try {
                URL installURL = descriptor.getInstallURL();
                super.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, icon)));
            }
            catch (Exception ex) {
                super.setImageDescriptor(ImageDescriptor.getMissingImageDescriptor());
            }
        }
    }

    protected static IPatternProperty findParticipant(IPatternProperty[] properties, String name) {
        int i = 0;
        while (i < properties.length) {
            if (properties[i].isParticipant() && name.equals(properties[i].getName())) {
                return properties[i];
            }
            ++i;
        }
        return null;
    }

    protected static ITemplate findTemplate(String name) {
        ITemplateExtension templateExt = CodePlugin.getInstance().getTemplateRegistry().getExtension("selena.templates.JavaPattern");
        ITemplate[] templates = templateExt.getTemplates();
        int i = 0;
        while (i < templates.length) {
            if (name.equals(templates[i].getName())) {
                return templates[i];
            }
            ++i;
        }
        return null;
    }

    protected IType findParticipantType(String name) {
        IPatternProperty property = PatternAction.findParticipant(this.pattern.getExtension().getProperties(), name);
        if (property == null) {
            return null;
        }
        Object value = this.pattern.getPropertyValue(property);
        if (value instanceof IType) {
            return (IType)value;
        }
        return null;
    }

    protected IType[] findParticipantTypeArray(String name) {
        IPatternProperty property = PatternAction.findParticipant(this.pattern.getExtension().getProperties(), name);
        if (property == null) {
            return null;
        }
        Object value = this.pattern.getPropertyValue(property);
        if (value instanceof IType[]) {
            return (IType[])value;
        }
        return null;
    }

    static IPackageFragment getConcretePackageFragment(IType[] concreteClasses, IType defaultClass) throws JavaModelException {
        if (concreteClasses != null && concreteClasses.length > 0) {
            return concreteClasses[0].getPackageFragment();
        }
        return defaultClass.getPackageFragment();
    }
}

