/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.patterns.PatternModel;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternExtension;
import com.tssap.selena.cmf.patterns.IPatternHandler;
import com.tssap.selena.cmf.patterns.IPatternListener;
import com.tssap.selena.cmf.patterns.IPatternManager;
import com.tssap.selena.cmf.patterns.IPatternProject;
import com.tssap.selena.cmf.patterns.IPatternProperty;
import com.tssap.selena.cmf.patterns.IPatternVisitor;
import com.tssap.selena.cmf.patterns.Patterns;
import com.tssap.selena.ui.IPropertySupport;
import com.tssap.selena.ui.Properties;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public abstract class Pattern
extends PlatformObject
implements IPattern {
    private String myName;
    private boolean myIsValid;
    private IPatternHandler myPatternHandler;
    private IPatternManager myManager;
    private final IPatternExtension myExtension;
    private long myModificationStamp;
    private ArrayList myListeners;
    private Map myPropertyValues;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public Pattern(IPatternExtension extension, IPatternManager manager) {
        this.myManager = manager;
        this.myExtension = extension;
        this.myPropertyValues = new HashMap();
        this.myModificationStamp = 0L;
    }

    public String toString() {
        String INDENT = " ";
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<").append(this.myExtension.getName());
        IPatternProperty[] properties = this.myExtension.getProperties();
        int i = 0;
        while (i < properties.length) {
            IPatternProperty p = properties[i];
            String name = p.getName();
            sbuf.append(" ").append(name).append("=").append(this.getLabel(p));
            ++i;
        }
        sbuf.append(" ").append("/>");
        return sbuf.toString();
    }

    public final IPatternExtension getExtension() {
        return this.myExtension;
    }

    public final IPatternManager getPatternManager() {
        return this.myManager;
    }

    public final void setPatternManager(IPatternManager manager) {
        if (manager != this.myManager) {
            this.myManager = manager;
            ++this.myModificationStamp;
        }
    }

    public final IPatternHandler getPatternHandler() {
        if (this.myPatternHandler == null) {
            this.myPatternHandler = this.myExtension.createPatternHandler(this);
        }
        return this.myPatternHandler;
    }

    public final String getName() {
        String cn;
        if (!this.myIsValid && (cn = this.getCanonicalName()) != null) {
            return cn;
        }
        return this.myName;
    }

    public final void setName(String name) {
        this.myName = name;
        ++this.myModificationStamp;
    }

    protected String getCanonicalName() {
        IPatternProperty[] properties = this.myExtension.getProperties();
        int i = 0;
        while (i < properties.length) {
            IPatternProperty p = properties[i];
            if (p.isParticipant()) {
                return this.getLabel(p);
            }
            ++i;
        }
        return null;
    }

    private String getLabel(IPatternProperty property) {
        Object value = this.getPropertyValue(property);
        if (value == null) {
            return null;
        }
        IPropertySupport support = Properties.getPropertySupport((String)property.getType());
        return support.getLabelProvider().getText(value);
    }

    public final boolean isValid() {
        return this.myIsValid;
    }

    public final void setValid(boolean valid) {
        this.myIsValid = valid;
        if (valid && this.myName == null) {
            this.setName(this.getCanonicalName());
        }
    }

    public final IPatternProperty[] getProperties() {
        return this.myExtension.getProperties();
    }

    public final IPatternProperty getProperty(String name) {
        IPatternProperty[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            IPatternProperty property = properties[i];
            if (name.equals(property.getName())) {
                return property;
            }
            ++i;
        }
        return null;
    }

    public final Object getPropertyValue(IPatternProperty property) {
        return this.myPropertyValues.get(property);
    }

    public final void setPropertyValue(IPatternProperty property, Object value) {
        this.myPropertyValues.put(property, value);
        ++this.myModificationStamp;
    }

    public final void addListener(IPatternListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList(2);
        }
        this.myListeners.add(listener);
    }

    public final void removeListener(IPatternListener listener) {
        if (this.myListeners != null) {
            ((AbstractCollection)this.myListeners).remove(listener);
            if (this.myListeners.isEmpty()) {
                this.myListeners = null;
            }
        }
    }

    public final long getModificationStamp() {
        return this.myModificationStamp;
    }

    public final void setPropertyValue(String propertyName, Object value) {
        IPatternProperty pp = this.getProperty(propertyName);
        if (pp == null) {
            throw new IllegalArgumentException("Bad pattern property name:" + propertyName + " for pattern " + this.myExtension.getId());
        }
        this.setPropertyValue(pp, value);
    }

    public final Object getPropertyValue(String propertyName) {
        IPatternProperty pp = this.getProperty(propertyName);
        if (pp != null) {
            return this.getPropertyValue(pp);
        }
        throw new IllegalArgumentException("Bad pattern property name:" + propertyName + " for pattern " + this.myExtension.getId());
    }

    protected final void firePropertyChanged() {
        IPatternListener[] targets = this.getPatternListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].propertyChanged(this);
            ++i;
        }
    }

    protected final IPatternListener[] getPatternListeners() {
        if (this.myListeners == null || this.myListeners.size() == 0) {
            return new IPatternListener[0];
        }
        return this.myListeners.toArray(new IPatternListener[this.myListeners.size()]);
    }

    private boolean handleResourceRename(IResource from, IResource to) {
        if (CodePlugin.getInstance().isDebugging()) {
            System.out.println("[handleResourceRename]");
        }
        return this.handlePropertyValueModification(new DefaultPropertyValueModifier(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = Pattern.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource, from, to));
    }

    protected final boolean handlePropertyValueModification(PropertyValueModifier modifier) {
        long startStamp = this.myModificationStamp;
        Iterator it = this.myPropertyValues.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (value == null) continue;
            if (modifier.getValueClass().isInstance(value)) {
                if (!modifier.isValueOfInterest(value)) continue;
                if (CodePlugin.getInstance().isDebugging()) {
                    CodePlugin.info("" + this + ", rename of property: " + entry.getKey());
                }
                entry.setValue(modifier.getModifiedValue(value));
                ++this.myModificationStamp;
                continue;
            }
            if (!value.getClass().isArray() || !value.getClass().getComponentType().isAssignableFrom(modifier.getValueClass())) continue;
            int i = Array.getLength(value) - 1;
            while (i >= 0) {
                Object arrayElement = Array.get(value, i);
                if (modifier.isValueOfInterest(arrayElement)) {
                    if (CodePlugin.getInstance().isDebugging()) {
                        CodePlugin.info("" + this + ", rename of property: " + entry.getKey() + ",index:" + i);
                    }
                    Array.set(value, i, modifier.getModifiedValue(arrayElement));
                    ++this.myModificationStamp;
                }
                --i;
            }
        }
        return this.myModificationStamp != startStamp;
    }

    protected final boolean handlePropertyValueRemove(Object removed) {
        if (removed == null) {
            throw new NullPointerException();
        }
        long startStamp = this.myModificationStamp;
        Iterator it = this.myPropertyValues.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (removed.equals(value)) {
                if (CodePlugin.getInstance().isDebugging()) {
                    System.out.println("" + this + ", removing property: " + entry.getKey());
                }
                it.remove();
                ++this.myModificationStamp;
                continue;
            }
            if (value == null || !value.getClass().isArray() || !value.getClass().getComponentType().isAssignableFrom(removed.getClass())) continue;
            Object array = Pattern.removeElementFromArray(value, removed);
            if (array == null) {
                it.remove();
                ++this.myModificationStamp;
                continue;
            }
            if (array == value) continue;
            entry.setValue(array);
            ++this.myModificationStamp;
        }
        return this.myModificationStamp != startStamp;
    }

    private static Object removeElementFromArray(Object array, Object removed) {
        int arrayLen = Array.getLength(array);
        ArrayList<Object> result = new ArrayList<Object>(arrayLen);
        int i = 0;
        while (i < arrayLen) {
            Object next = Array.get(array, i);
            if (!removed.equals(next)) {
                result.add(next);
            }
            ++i;
        }
        if (result.size() == arrayLen) {
            return array;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), result.size()));
    }

    public abstract boolean exists();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                RenameVisitor renameVisitor = new RenameVisitor(event.getDelta());
                if (renameVisitor.hasRenames()) {
                    Patterns.getModel().accept(renameVisitor);
                    PatternModel.validate(renameVisitor.getAffectedPatterns());
                    PatternModel.fireModelChanges(renameVisitor.getAffectedPatterns());
                }
            }
        }, 8);
    }

    private static class RenameVisitor
    implements IPatternVisitor {
        private final List renamed;
        private final Set projectsAffected;
        private final List myAffectedPatterns;

        private RenameVisitor(IResourceDelta delta) {
            this.renamed = RenameVisitor.findRenames(delta);
            this.projectsAffected = RenameVisitor.findAffectedProjects(this.renamed);
            this.myAffectedPatterns = new ArrayList();
        }

        private boolean hasRenames() {
            return !this.renamed.isEmpty();
        }

        private List getAffectedPatterns() {
            return this.myAffectedPatterns;
        }

        public boolean visit(IPatternProject patternProject) {
            return this.projectsAffected.contains(patternProject.getProject());
        }

        public boolean visit(IPatternManager patternManager) {
            return true;
        }

        public boolean visit(IPattern pattern) {
            if (pattern instanceof Pattern) {
                Iterator it = this.renamed.iterator();
                while (it.hasNext()) {
                    IResource[] next = (IResource[])it.next();
                    if (!((Pattern)pattern).handleResourceRename(next[0], next[1])) continue;
                    this.myAffectedPatterns.add(pattern);
                }
            }
            return true;
        }

        private static List findRenames(IResourceDelta aDelta) {
            ArrayList rv = new ArrayList();
            try {
                aDelta.accept(new IResourceDeltaVisitor(aDelta, rv){
                    private final /* synthetic */ IResourceDelta val$aDelta;
                    private final /* synthetic */ List val$rv;
                    {
                        this.val$aDelta = val$aDelta;
                        this.val$rv = val$rv;
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getKind() == 2 && (delta.getFlags() & 0x2000) != 0) {
                            IResource[] next = new IResource[]{delta.getResource(), this.val$aDelta.findMember(delta.getMovedToPath()).getResource()};
                            this.val$rv.add(next);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException ex) {
                CodePlugin.getInstance().getLog().log(ex.getStatus());
            }
            return rv;
        }

        private static Set findAffectedProjects(List renamedResources) {
            HashSet<IProject> rv = new HashSet<IProject>();
            Iterator it = renamedResources.iterator();
            while (it.hasNext()) {
                IResource[] res = (IResource[])it.next();
                rv.add(res[0].getProject());
            }
            return rv;
        }
    }

    protected static class DefaultPropertyValueModifier
    extends PropertyValueModifier {
        private final Object myOldValue;
        private final Object myNewValue;

        public DefaultPropertyValueModifier(Class clazz, Object oldValue, Object newValue) {
            super(clazz);
            if (oldValue == null || newValue == null) {
                throw new NullPointerException();
            }
            this.myOldValue = oldValue;
            this.myNewValue = newValue;
        }

        public boolean isValueOfInterest(Object oldPropertyValue) {
            return this.myOldValue.equals(oldPropertyValue);
        }

        public Object getModifiedValue(Object oldPropertyValue) {
            return this.myNewValue;
        }
    }

    protected static abstract class PropertyValueModifier {
        private final Class myClassOfInterest;

        protected PropertyValueModifier(Class valueOfInterestClass) {
            if (valueOfInterestClass == null) {
                throw new NullPointerException();
            }
            this.myClassOfInterest = valueOfInterestClass;
        }

        protected final Class getValueClass() {
            return this.myClassOfInterest;
        }

        public abstract boolean isValueOfInterest(Object var1);

        public abstract Object getModifiedValue(Object var1);
    }
}

