/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.patterns.Messages;
import com.tssap.selena.cmf.internal.patterns.PatternBuilder;
import com.tssap.selena.cmf.internal.patterns.PatternRecognizer;
import com.tssap.selena.cmf.patterns.IPatternProject;
import com.tssap.selena.cmf.patterns.IPatternRegion;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public abstract class JavaPatternBuilder
extends PatternBuilder
implements IResourceDeltaVisitor {
    private boolean myIsDirty;
    private IJavaProject myProject;
    private IPatternRegion myPatternRegion;
    private ITypeHierarchy myTypeHierarchy;
    private IRegion myJavaRegion;

    public JavaPatternBuilder(PatternRecognizer recognizer) {
        super(recognizer);
    }

    public IJavaProject getJavaProject() {
        if (this.myProject == null) {
            IPatternProject patternProject = this.getProject();
            IProject workspaceProject = patternProject.getProject();
            this.myProject = JavaCore.create((IProject)workspaceProject);
        }
        return this.myProject;
    }

    public ITypeHierarchy getHierarchy() {
        return this.myTypeHierarchy;
    }

    public void build(IProgressMonitor monitor) throws CoreException {
        this.myPatternRegion = this.getRegion();
        monitor.beginTask(Messages.getString("Patterns_1"), 3);
        try {
            monitor.subTask(Messages.getString("Updating_units_2"));
            if (this.updateUnits((IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.subTask(Messages.getString("Updating_hierarchy_3"));
                this.createHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.subTask(Messages.getString("Recognizing_patterns_4"));
                this.recognizePatterns((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public void build(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        this.myPatternRegion = this.getRegion();
        monitor.beginTask(Messages.getString("Patterns_5"), 3);
        try {
            monitor.subTask(Messages.getString("Updating_units_6"));
            if (this.updateUnits(delta)) {
                monitor.worked(1);
                monitor.subTask(Messages.getString("Updating_hierarchy_7"));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.updateHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.subTask(Messages.getString("Recognizing_patterns_8"));
                this.recognizePatterns((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected abstract void recognizePatterns(IProgressMonitor var1) throws CoreException;

    protected void createHierarchy(IProgressMonitor monitor) throws CoreException {
        this.myJavaRegion = this.createJavaRegion();
        this.updateHierarchy(monitor);
    }

    protected void updateHierarchy(IProgressMonitor monitor) throws CoreException {
        this.myTypeHierarchy = this.getJavaProject().newTypeHierarchy(this.myJavaRegion, monitor);
    }

    protected IRegion createJavaRegion() {
        return new JavaRegion();
    }

    protected boolean updateUnits(IProgressMonitor monitor) throws CoreException {
        this.myIsDirty = false;
        try {
            IContainer[] containers = JavaPatternBuilder.getSourceContainers(this.getJavaProject());
            monitor.beginTask("", containers.length);
            int i = 0;
            while (i < containers.length) {
                this.addContainer(containers[i]);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.worked(1);
                ++i;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return this.myIsDirty;
    }

    private void addContainer(IContainer folder) throws CoreException {
        if (this.myPatternRegion.contains((IResource)folder)) {
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member instanceof IFolder) {
                    this.addContainer((IContainer)member);
                } else if (members[i] instanceof IFile && "java".equals(member.getFileExtension())) {
                    this.addFile((IFile)member);
                }
                ++i;
            }
        }
    }

    private void addFile(IFile file) throws CoreException {
        ICompilationUnit unit;
        if (this.myPatternRegion.contains((IResource)file) && (unit = JavaCore.createCompilationUnitFrom((IFile)file)) != null) {
            this.myIsDirty = true;
            this.addCompilationUnit(unit);
        }
    }

    protected boolean updateUnits(IResourceDelta delta) throws CoreException {
        this.myIsDirty = false;
        delta.accept((IResourceDeltaVisitor)this);
        return this.myIsDirty;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                return JavaCore.create((IResource)resource) != null;
            }
            case 2: {
                return JavaCore.create((IResource)resource) != null && this.myPatternRegion.contains(resource);
            }
            case 1: {
                this.visitFile(resource, delta);
            }
        }
        return false;
    }

    private void visitFile(IResource resource, IResourceDelta delta) throws CoreException {
        if (this.myPatternRegion.contains(resource) && resource.getName().endsWith(".java")) {
            ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
            if (unit == null) {
                return;
            }
            switch (delta.getKind()) {
                case 1: {
                    this.addCompilationUnit(unit);
                    this.myJavaRegion.add((IJavaElement)unit);
                    break;
                }
                case 2: {
                    this.removeCompilationUnit(unit);
                    this.myJavaRegion.remove((IJavaElement)unit);
                    break;
                }
                default: {
                    this.updateCompilationUnit(unit);
                }
            }
            this.myIsDirty = true;
        }
    }

    protected abstract ICompilationUnit[] getCompilationUnits() throws CoreException;

    protected abstract void addCompilationUnit(ICompilationUnit var1) throws CoreException;

    protected abstract void removeCompilationUnit(ICompilationUnit var1) throws CoreException;

    protected void updateCompilationUnit(ICompilationUnit unit) throws CoreException {
        this.removeCompilationUnit(unit);
        this.addCompilationUnit(unit);
    }

    private static IPackageFragment[] getPackageFragments(IJavaProject project) throws CoreException {
        IClasspathEntry[] classpath = project.getRawClasspath();
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 3) {
                IPackageFragmentRoot root = project.findPackageFragmentRoot(entry.getPath());
                return JavaPatternBuilder.getPackageFragments(root);
            }
            ++i;
        }
        return null;
    }

    private static IPackageFragment[] getPackageFragments(IPackageFragmentRoot root) throws CoreException {
        ArrayList<IJavaElement> fragments = new ArrayList<IJavaElement>();
        IJavaElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            fragments.add(children[i]);
            ++i;
        }
        return fragments.toArray(new IPackageFragment[fragments.size()]);
    }

    private static IPackageFragment[] getSourceFragments(IJavaProject project) throws CoreException {
        ArrayList<IJavaElement> fragments = new ArrayList<IJavaElement>();
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            block5: {
                IPackageFragmentRoot root = roots[i];
                if (root.getKind() == 1) {
                    IJavaElement[] children;
                    try {
                        children = root.getChildren();
                    }
                    catch (JavaModelException e) {
                        break block5;
                    }
                    int j = 0;
                    while (j < children.length) {
                        fragments.add(children[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return fragments.toArray(new IPackageFragment[fragments.size()]);
    }

    public static IContainer[] getSourceContainers(IJavaProject project) throws CoreException {
        ArrayList<IResource> containers = new ArrayList<IResource>();
        IClasspathEntry[] classpath = project.getRawClasspath();
        int i = 0;
        while (i < classpath.length) {
            IPackageFragmentRoot root;
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 3 && (root = project.findPackageFragmentRoot(entry.getPath())) != null) {
                containers.add(root.getUnderlyingResource());
            }
            ++i;
        }
        return containers.toArray(new IContainer[containers.size()]);
    }

    private class JavaRegion
    implements IRegion {
        private final IRegion myDeltaRegion = JavaCore.newRegion();

        private JavaRegion() {
        }

        public boolean contains(IJavaElement element) {
            if (element instanceof IType) {
                return this.contains((IType)element);
            }
            return false;
        }

        private boolean contains(IType type) {
            if (type.isBinary()) {
                return false;
            }
            IResource resource = type.getResource();
            if (resource == null) {
                return false;
            }
            return JavaPatternBuilder.this.myPatternRegion.contains(resource);
        }

        public IJavaElement[] getElements() {
            try {
                IJavaElement[] deltaElements = this.myDeltaRegion.getElements();
                IJavaElement[] rootElements = this.getRootElements();
                IJavaElement[] rv = new IJavaElement[rootElements.length + deltaElements.length];
                System.arraycopy(deltaElements, 0, rv, 0, deltaElements.length);
                System.arraycopy(rootElements, 0, rv, deltaElements.length, rootElements.length);
                return rv;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }

        private IJavaElement[] getRootElements() throws CoreException {
            ArrayList<IPackageFragmentRoot> elements = new ArrayList<IPackageFragmentRoot>();
            IClasspathEntry[] classpath = JavaPatternBuilder.this.myProject.getRawClasspath();
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (entry.getEntryKind() == 3) {
                    IPackageFragmentRoot root = JavaPatternBuilder.this.myProject.findPackageFragmentRoot(entry.getPath());
                    elements.add(root);
                }
                ++i;
            }
            IJavaElement[] je = new IJavaElement[elements.size()];
            return elements.toArray(je);
        }

        public void add(IJavaElement element) {
            if (CodePlugin.getInstance().isDebugging()) {
                CodePlugin.debug("JavaRegion.add: " + element);
            }
            this.myDeltaRegion.add(element);
        }

        public boolean remove(IJavaElement element) {
            if (CodePlugin.getInstance().isDebugging()) {
                CodePlugin.debug("JavaRegion.remove: " + element);
            }
            return this.myDeltaRegion.remove(element);
        }
    }
}

