/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.patterns.Messages;
import com.tssap.selena.cmf.internal.patterns.PatternManager;
import com.tssap.selena.cmf.internal.patterns.PatternModel;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternBuilder;
import com.tssap.selena.cmf.patterns.IPatternManager;
import com.tssap.selena.cmf.patterns.IPatternProject;
import com.tssap.selena.cmf.patterns.Patterns;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class IncrementalPatternBuilder
extends IncrementalProjectBuilder {
    public static boolean DEBUG;
    protected IPatternProject patternProject;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (this.getPatternProject() == null) {
            return null;
        }
        switch (this.patternProject.getMode()) {
            case 0: {
                break;
            }
            case 1: {
                if (args == null || args.get("force") == null) break;
                if (kind == 6) {
                    this.build(args, monitor);
                    break;
                }
                this.validate(monitor);
                this.fireProjectChanged();
                break;
            }
            case 2: {
                if (kind == 6) {
                    this.build(args, monitor);
                    break;
                }
                IResourceDelta delta = this.getDelta(project);
                this.build(delta, args, monitor);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return null;
    }

    private IPatternProject getPatternProject() {
        if (this.patternProject == null) {
            this.patternProject = Patterns.getProject(this.getProject());
        }
        return this.patternProject;
    }

    private void build(Map args, IProgressMonitor monitor) throws CoreException {
        IPatternBuilder[] builders = this.patternProject.getBuilders();
        if (builders == null || builders.length == 0) {
            return;
        }
        if (builders.length == 1) {
            CodePlugin.debug("full build: recognizer={0} project={1}", builders[0].getRecognizer().getId(), this.getProject().getName());
            builders[0].setBuildArguments(args);
            builders[0].build(monitor);
            this.fireProjectChanged();
            return;
        }
        monitor.beginTask(Messages.getString("Patterns_3"), builders.length);
        try {
            String projectName = this.getProject().getName();
            int i = 0;
            while (i < builders.length) {
                CodePlugin.debug("full build: recognizer={0} project={1}", builders[i].getRecognizer().getId(), projectName);
                builders[i].setBuildArguments(args);
                builders[i].build((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
            this.fireProjectChanged();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void build(IResourceDelta delta, Map args, IProgressMonitor monitor) throws CoreException {
        IPatternBuilder[] builders = this.patternProject.getBuilders();
        if (builders == null || builders.length == 0) {
            return;
        }
        if (builders.length == 1) {
            builders[0].setBuildArguments(args);
            builders[0].build(delta, monitor);
            this.fireProjectChanged();
            return;
        }
        monitor.beginTask(Messages.getString("Patterns_6"), builders.length);
        try {
            String projectName = this.getProject().getName();
            int i = 0;
            while (i < builders.length) {
                CodePlugin.debug("delta build: recognizer={0} project={1}", builders[i].getRecognizer().getId(), projectName);
                builders[i].setBuildArguments(args);
                builders[i].build(delta, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
            this.fireProjectChanged();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public void validate(IProgressMonitor monitor) throws CoreException {
        IPatternProject project = this.getPatternProject();
        IPatternManager[] managers = project.getManagers();
        ArrayList changedManagers = new ArrayList();
        int i = 0;
        while (i < managers.length) {
            IPatternManager manager = managers[i];
            if (!manager.isEmpty()) {
                int count = 0;
                IPattern[] oldPatterns = manager.getPatterns();
                IPattern[] newPatterns = new IPattern[oldPatterns.length];
                int j = 0;
                while (j < oldPatterns.length) {
                    IPattern pattern = oldPatterns[j];
                    if (pattern.exists()) {
                        newPatterns[count++] = pattern;
                    }
                    ++j;
                }
                if (count < newPatterns.length) {
                    IPattern[] patterns = new IPattern[count];
                    System.arraycopy(newPatterns, 0, patterns, 0, count);
                    manager.setPatterns(patterns);
                }
            }
            ++i;
        }
    }

    private void fireProjectChanged() {
        ArrayList<PatternManager> changed = new ArrayList<PatternManager>();
        IPatternProject project = this.getPatternProject();
        IPatternManager[] managers = project.getManagers();
        int i = 0;
        while (i < managers.length) {
            PatternManager manager = (PatternManager)managers[i];
            if (manager.isChanged()) {
                changed.add(manager);
                manager.setChanged(false);
            }
            ++i;
        }
        if (!changed.isEmpty()) {
            PatternModel.projectChanged(this.getPatternProject(), changed.toArray(new IPatternManager[changed.size()]));
        }
    }
}

