/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.patterns.PatternProperty;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.PatternException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BeanPatternProperty
extends PatternProperty {
    public static final int EXPERT = 1;
    public static final int PARTICIPANT = 2;
    private Method readMethod;
    private Method writeMethod;
    private Method applyMethod;
    static /* synthetic */ Class class$org$eclipse$core$runtime$IProgressMonitor;

    public BeanPatternProperty(Class clazz, String name, String type) {
        this(clazz, name, type, 2);
    }

    public BeanPatternProperty(Class clazz, String name, String type, int flags) {
        super(name, type, flags);
        this.introspect(clazz, name);
    }

    public boolean isMutable() {
        return this.applyMethod != null;
    }

    public Object getValue(IPattern pattern) {
        try {
            return this.readMethod.invoke((Object)pattern, null);
        }
        catch (Exception e) {
            CodePlugin.error("cannot get property value", e);
            return null;
        }
    }

    public void setValue(IPattern pattern, Object value) {
        try {
            this.writeMethod.invoke((Object)pattern, value);
        }
        catch (Exception e) {
            CodePlugin.error("cannot set property value", e);
        }
    }

    public void applyValue(IPattern pattern, Object value, IProgressMonitor monitor) throws CoreException {
        try {
            this.applyMethod.invoke((Object)pattern, value, monitor);
        }
        catch (IllegalAccessException e) {
            throw new PatternException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof CoreException) {
                throw (CoreException)target;
            }
            throw new PatternException(target);
        }
    }

    void introspect(Class clazz, String name) {
        String base = BeanPatternProperty.capitalize(name);
        Method[] methods = clazz.getMethods();
        this.readMethod = BeanPatternProperty.findMethod(methods, "get" + base, 0);
        if (this.readMethod == null) {
            throw new IllegalArgumentException("no read method: " + base);
        }
        this.writeMethod = BeanPatternProperty.findMethod(methods, "set" + base, Void.TYPE, new Class[]{this.readMethod.getReturnType()});
        if (this.writeMethod == null) {
            throw new IllegalArgumentException("no write method: " + base);
        }
        this.applyMethod = BeanPatternProperty.findMethod(methods, "apply" + base, Void.TYPE, new Class[]{this.readMethod.getReturnType(), class$org$eclipse$core$runtime$IProgressMonitor == null ? (class$org$eclipse$core$runtime$IProgressMonitor = BeanPatternProperty.class$("org.eclipse.core.runtime.IProgressMonitor")) : class$org$eclipse$core$runtime$IProgressMonitor});
    }

    private static Method findMethod(Method[] methods, String name, int args) {
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method != null && !Modifier.isStatic(method.getModifiers()) && method.getName().equals(name) && method.getParameterTypes().length == args) {
                return method;
            }
            ++i;
        }
        return null;
    }

    private static Method findMethod(Method[] methods, String name, Class returnType, Class[] paramTypes) {
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method != null && !Modifier.isStatic(method.getModifiers()) && BeanPatternProperty.matchMethod(method, name, returnType, paramTypes)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    private static boolean matchMethod(Method method, String name, Class returnType, Class[] paramTypes) {
        if (!method.getName().equals(name)) {
            return false;
        }
        Class<?>[] params = method.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            if (params[i] != paramTypes[i]) {
                return false;
            }
            ++i;
        }
        return method.getReturnType() == returnType;
    }

    private static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

