/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.patterns.ActionRegistry;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternAction;
import java.util.ArrayList;
import java.util.HashMap;

public class ActionRegistryImpl
extends ActionRegistry {
    private HashMap patternsToActions = new HashMap();
    private ArrayList globalActions = new ArrayList();

    public void addAction(String patternID, IPatternAction patternAction) {
        ArrayList<IPatternAction> actions = (ArrayList<IPatternAction>)this.patternsToActions.get(patternID);
        if (actions == null) {
            actions = new ArrayList<IPatternAction>(3);
            this.patternsToActions.put(patternID, actions);
        }
        actions.add(patternAction);
    }

    public void removeAction(String patternID, String patternActionID) {
        ArrayList actions = (ArrayList)this.patternsToActions.get(patternID);
        if (actions == null) {
            return;
        }
        int idx = this.findAction(actions, patternActionID);
        if (idx != -1) {
            actions.remove(idx);
        }
        if (actions.size() == 0) {
            this.patternsToActions.remove(patternID);
        }
    }

    public IPatternAction[] getActions(IPattern pattern) {
        String patternID = ActionRegistry.getPatternID(pattern);
        ArrayList actions = (ArrayList)this.patternsToActions.get(patternID);
        if (actions == null) {
            return new IPatternAction[0];
        }
        return actions.toArray(new IPatternAction[actions.size()]);
    }

    private int findAction(ArrayList actions, String patternActionID) {
        int i = actions.size() - 1;
        while (i >= 0) {
            if (((IPatternAction)actions.get(i)).equals(patternActionID)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void addGlobalAction(IPatternAction patternAction) {
        this.globalActions.add(patternAction);
    }

    public IPatternAction[] getGlobalActions() {
        return this.globalActions.toArray(new IPatternAction[this.globalActions.size()]);
    }
}

