/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.patterns.ActionRegistryImpl;
import com.tssap.selena.cmf.patterns.ActionRegistry;
import com.tssap.selena.cmf.patterns.IPatternAction;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ActionRegistryExtPointFactory {
    public static final String PT_PATTERN_ACTIONS = "patterns_actions";

    public static ActionRegistry createActionRegistry() {
        ActionRegistryImpl actionRegistry = new ActionRegistryImpl();
        IExtensionPoint extPoint = CodePlugin.getInstance().getDescriptor().getExtensionPoint(PT_PATTERN_ACTIONS);
        IConfigurationElement[] config = extPoint.getConfigurationElements();
        int i = 0;
        while (i < config.length) {
            try {
                String patternID = config[i].getAttribute("patternID");
                Object patternAction = config[i].createExecutableExtension("class");
                if (patternAction instanceof IPatternAction) {
                    if (patternID == null || patternID.length() == 0) {
                        ((ActionRegistry)actionRegistry).addGlobalAction((IPatternAction)patternAction);
                    } else {
                        ((ActionRegistry)actionRegistry).addAction(patternID, (IPatternAction)patternAction);
                    }
                }
            }
            catch (Exception ex) {
                CodePlugin.log((IStatus)new Status(4, "com.tssap.selena.cmf", 0, ex.toString(), (Throwable)ex));
            }
            ++i;
        }
        return actionRegistry;
    }
}

