/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal;

import com.tssap.selena.cmf.internal.CodeException;
import com.tssap.selena.cmf.internal.CodePlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CodeToolkit {
    private static String[] workspaceNatures;
    private static final String[] EMPTY_PARAMS;

    public static ICodeFormatter createCodeFormatter(Map options) {
        return ToolFactory.createDefaultCodeFormatter((Map)options);
    }

    public static String format(String source, int indent) {
        String delim = System.getProperty("line.separator", "\n");
        return CodeToolkit.format(source, indent, delim + delim);
    }

    public static String format(String source, int indent, String append) {
        ICodeFormatter formatter = CodeToolkit.createCodeFormatter(null);
        source = formatter.format(source, indent, null, null);
        if (append != null) {
            source = source + append;
        }
        return source;
    }

    public static IField findField(String name, IType type) throws JavaModelException {
        return CodeToolkit.findField(name, type.getFields());
    }

    private static IField findField(String name, IField[] fields) throws JavaModelException {
        int i = fields.length - 1;
        while (i >= 0) {
            IField field = fields[i];
            if (name.equals(field.getElementName())) {
                return field;
            }
            --i;
        }
        return null;
    }

    public static boolean compareParamTypes(String[] paramTypes1, String[] paramTypes2) {
        if (paramTypes1.length == paramTypes2.length) {
            int i = 0;
            while (i < paramTypes1.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes1[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)paramTypes2[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IMethod[] methods) throws JavaModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            IMethod curr = methods[i];
            if (name.equals(curr.getElementName()) && isConstructor == curr.isConstructor() && CodeToolkit.compareParamTypes(paramTypes, curr.getParameterTypes())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static IMethod findMethod(String name, String[] params, IType type) throws JavaModelException {
        if (params == null) {
            params = EMPTY_PARAMS;
        }
        return CodeToolkit.findMethod(name, params, false, type.getMethods());
    }

    public static IMethod findConstructor(String name, String[] params, IType type) throws JavaModelException {
        if (params == null) {
            params = EMPTY_PARAMS;
        }
        return CodeToolkit.findMethod(name, params, true, type.getMethods());
    }

    public static IMethod findMethod(IMethod method, List allMethods) throws JavaModelException {
        String name = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        int i = allMethods.size() - 1;
        while (i >= 0) {
            IMethod curr = (IMethod)allMethods.get(i);
            if (name.equals(curr.getElementName()) && method.isConstructor() == curr.isConstructor() && CodeToolkit.compareParamTypes(paramTypes, curr.getParameterTypes())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static IMethod findMethod(IMethod method, IMethod[] methods) throws JavaModelException {
        return CodeToolkit.findMethod(method.getElementName(), method.getParameterTypes(), method.isConstructor(), methods);
    }

    public static IMethod findMethod(IMethod method, IType type) throws JavaModelException {
        return CodeToolkit.findMethod(method.getElementName(), method.getParameterTypes(), method.isConstructor(), type.getMethods());
    }

    public static String getLineDelimiter(IJavaElement elem) throws JavaModelException {
        return System.getProperty("line.separator", "\n");
    }

    public static void rename(IField field, String name, IProgressMonitor monitor) throws JavaModelException {
        field.rename(name, false, monitor);
    }

    public static void rename(IMethod method, String name, IProgressMonitor monitor) throws JavaModelException {
        method.rename(name, false, monitor);
    }

    public static String[] getWorkspaceNatureIds() {
        if (workspaceNatures == null) {
            IProjectNatureDescriptor[] natures = ResourcesPlugin.getWorkspace().getNatureDescriptors();
            workspaceNatures = new String[natures.length];
            int i = 0;
            while (i < natures.length) {
                CodeToolkit.workspaceNatures[i] = natures[i].getNatureId();
                ++i;
            }
        }
        return workspaceNatures;
    }

    public static void addNatures(IProject project, String[] natures, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] oldNatures = description.getNatureIds();
        int count = 0;
        int i = 0;
        while (i < natures.length) {
            String id = natures[i];
            if (!CodeToolkit.hasNature(oldNatures, id)) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        String[] newNatures = new String[oldNatures.length + count];
        System.arraycopy(oldNatures, 0, newNatures, 0, oldNatures.length);
        count = oldNatures.length;
        int i2 = 0;
        while (i2 < natures.length) {
            String id = natures[i2];
            if (!CodeToolkit.hasNature(oldNatures, id)) {
                newNatures[count++] = id;
            }
            ++i2;
        }
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void addNature(IProject project, String id, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (!CodeToolkit.hasNature(natures, id)) {
            IFile dotProject = project.getFile(".project");
            if (dotProject.isReadOnly() && 0 != project.getWorkspace().validateEdit(new IFile[]{dotProject}, (Object)CodeToolkit.getShellIfCorrectThread()).getSeverity()) {
                return;
            }
            natures = CodeToolkit.addNature(natures, id);
            description.setNatureIds(natures);
            project.setDescription(description, monitor);
        }
    }

    private static Shell getShellIfCorrectThread() {
        if (Display.getCurrent() != null) {
            IWorkbenchWindow wnd = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            return wnd != null ? wnd.getShell() : null;
        }
        return null;
    }

    public static void toggleNature(IProject project, String id, IProgressMonitor monitor) throws CoreException {
        CodePlugin.debug("toggleNature: id=" + id);
        IProjectDescription description = project.getDescription();
        String[] natures = CodeToolkit.toggleNature(description.getNatureIds(), id);
        description.setNatureIds(natures);
        project.setDescription(description, monitor);
    }

    private static boolean hasNature(String[] natures, String id) {
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String[] toggleNature(String[] natures, String id) {
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals(id)) {
                return CodeToolkit.removeNature(natures, i);
            }
            ++i;
        }
        return CodeToolkit.addNature(natures, id);
    }

    private static String[] addNature(String[] natures, String id) {
        String[] result = new String[natures.length + 1];
        System.arraycopy(natures, 0, result, 0, natures.length);
        result[natures.length] = id;
        return result;
    }

    private static String[] removeNature(String[] natures, int i) {
        String[] result = new String[natures.length - 1];
        System.arraycopy(natures, 0, result, 0, i);
        if (i + 1 < natures.length) {
            System.arraycopy(natures, i + 1, result, i, natures.length - (i + 1));
        }
        return result;
    }

    public static String resolveType(String signature, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)signature);
        if (signature.charAt(arrayCount) == 'Q') {
            int semi = signature.length() - 1;
            if (signature.charAt(semi) != ';') {
                throw new IllegalArgumentException();
            }
            String name = signature.substring(arrayCount + 1, semi);
            String[][] resolved = declaringType.resolveType(name);
            signature = resolved != null && resolved.length > 0 ? CodeToolkit.createSignature(resolved[0][0], resolved[0][1], arrayCount) : CodeToolkit.createSignature(declaringType.getPackageFragment().getElementName(), name, arrayCount);
        }
        return Signature.toString((String)signature);
    }

    public static String resolveType(String signature, ITypeHierarchy hierarchy, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)signature);
        if (signature.charAt(arrayCount) == 'Q') {
            String[][] resolved;
            int semi = signature.length() - 1;
            if (signature.charAt(semi) != ';') {
                throw new IllegalArgumentException();
            }
            String name = signature.substring(arrayCount + 1, semi);
            IType resolvedType = CodeToolkit.findTypeWithRespect(name, hierarchy, declaringType.getPackageFragment());
            signature = resolvedType != null ? CodeToolkit.createSignature(resolvedType.getPackageFragment().getElementName(), resolvedType.getElementName(), arrayCount) : ((resolved = declaringType.resolveType(name)) != null && resolved.length > 0 ? CodeToolkit.createSignature(resolved[0][0], resolved[0][1], arrayCount) : CodeToolkit.createSignature(declaringType.getPackageFragment().getElementName(), name, arrayCount));
        }
        return Signature.toString((String)signature);
    }

    private static IType findTypeWithRespect(String name, ITypeHierarchy th, IPackageFragment pf) {
        IType[] allNamedTypes = CodeToolkit.getAllTypesWithName(Signature.getSimpleName((String)name), th);
        String qualifier = Signature.getQualifier((String)name);
        return CodeToolkit.findFirstTypeWithPackage(allNamedTypes, qualifier.length() != 0 ? qualifier : pf.getElementName());
    }

    private static IType findFirstTypeWithPackage(IType[] types, String packageName) {
        int i = 0;
        while (i < types.length) {
            if (packageName.equals(types[i].getPackageFragment().getElementName())) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    private static IType[] getAllTypesWithName(String name, ITypeHierarchy th) {
        IType[] allTypes = th.getAllTypes();
        ArrayList<IType> list = new ArrayList<IType>();
        int i = 0;
        while (i < allTypes.length) {
            if (name.equals(allTypes[i].getElementName())) {
                list.add(allTypes[i]);
            }
            ++i;
        }
        return list.toArray(new IType[list.size()]);
    }

    private static String createSignature(String packageName, String simpleName, int arrayCount) {
        StringBuffer sbuf = new StringBuffer("L");
        if (packageName.length() > 0) {
            sbuf.append(packageName).append('.');
        }
        sbuf.append(simpleName).append(';');
        return Signature.createArraySignature((String)sbuf.toString(), (int)arrayCount);
    }

    public static boolean hasCompileErrors(ICompilationUnit unit) throws CoreException {
        IResource resource = unit.getCorrespondingResource();
        IMarker[] markers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        int i = 0;
        while (i < markers.length) {
            if (markers[i].getAttribute("severity", -1) == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Class getExtensionClass(IConfigurationElement config, String className, Class iface) throws CoreException {
        try {
            IPluginDescriptor plugin = config.getDeclaringExtension().getDeclaringPluginDescriptor();
            Class<?> cls = plugin.getPluginClassLoader().loadClass(className);
            if (!iface.isAssignableFrom(cls)) {
                throw new CodeException("extension class does not implement " + iface.getName());
            }
            return cls;
        }
        catch (ClassNotFoundException e) {
            throw new CodeException(e);
        }
        catch (Exception e) {
            throw new CodeException(e);
        }
    }

    public static void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    public static String getFileStem(String name) {
        int from = name.lastIndexOf(47) + 1;
        int sep = name.lastIndexOf(46);
        if (sep != -1) {
            return name.substring(from, sep);
        }
        if (from > 0) {
            return name.substring(from);
        }
        return name;
    }

    public static String getFileExtension(String name) {
        int sep = name.lastIndexOf(46);
        if (sep != -1) {
            return name.substring(sep + 1);
        }
        return "";
    }

    public static Class getCommonClass(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        Class commonClass = objects[0].getClass();
        if (objects.length == 1) {
            return commonClass;
        }
        int i = 1;
        while (i < objects.length) {
            Object object = objects[i];
            Class<?> newClass = object.getClass();
            if (!newClass.equals(commonClass) && (commonClass = CodeToolkit.getCommonClass(commonClass, newClass)) == null) {
                return null;
            }
            ++i;
        }
        return commonClass;
    }

    private static Class getCommonClass(Class class1, Class class2) {
        List list1 = CodeToolkit.computeCombinedOrder(class1);
        List list2 = CodeToolkit.computeCombinedOrder(class2);
        int i = 0;
        while (i < list1.size()) {
            int j = 0;
            while (j < list2.size()) {
                Class candidate2;
                Class candidate1 = (Class)list1.get(i);
                if (candidate1.equals(candidate2 = (Class)list2.get(j))) {
                    return candidate1;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static List computeCombinedOrder(Class inputClass) {
        ArrayList result = new ArrayList(4);
        Class clazz = inputClass;
        while (clazz != null) {
            result.add(clazz);
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                result.add(interfaces[i]);
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    static {
        EMPTY_PARAMS = new String[0];
    }
}

