/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal;

import com.tssap.selena.cmf.internal.JavaProjectAdapterFactory;
import com.tssap.selena.cmf.internal.PluginConstants;
import com.tssap.selena.cmf.internal.patterns.ActionRegistryExtPointFactory;
import com.tssap.selena.cmf.internal.patterns.IncrementalPatternBuilder;
import com.tssap.selena.cmf.internal.patterns.PatternCategory;
import com.tssap.selena.cmf.internal.patterns.PatternModel;
import com.tssap.selena.cmf.internal.patterns.PatternRegistry;
import com.tssap.selena.cmf.internal.templates.TemplateEngine;
import com.tssap.selena.cmf.internal.templates.TemplateModel;
import com.tssap.selena.cmf.internal.templates.TemplateRegistry;
import com.tssap.selena.cmf.patterns.ActionRegistry;
import com.tssap.selena.cmf.patterns.IPatternCategory;
import com.tssap.selena.cmf.patterns.IPatternExtension;
import com.tssap.selena.cmf.patterns.IPatternRecognizer;
import com.tssap.selena.cmf.patterns.IPatternRegistry;
import com.tssap.selena.cmf.templates.ITemplateEngine;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public final class CodePlugin
extends Plugin
implements PluginConstants {
    private static final String MEMENTO_FILE = "memento.xml";
    private static final String MEMENTO_ROOT = "memento";
    private static CodePlugin plugin;
    private static boolean debugging;
    private static boolean velocityMessages;
    private static final String VELOCITY_MESSAGES = "/debug/velocityMessages";
    private static ActionRegistry actionRegistry;
    private PatternModel patternModel;
    private PatternRegistry patternRegistry;
    private TemplateModel templateModel;
    private TemplateEngine templateEngine;
    private TemplateRegistry templateRegistry;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaProject;

    public static CodePlugin getInstance() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static ActionRegistry getActionRegistry() {
        if (actionRegistry == null) {
            actionRegistry = ActionRegistryExtPointFactory.createActionRegistry();
        }
        return actionRegistry;
    }

    public static IStatus log(IStatus status) {
        plugin.getLog().log(status);
        return status;
    }

    public static IStatus info(String message) {
        return CodePlugin.info(message, null);
    }

    public static IStatus info(String message, Throwable exception) {
        CodePlugin.debug(message);
        return CodePlugin.log((IStatus)new Status(1, "com.tssap.selena.cmf", 1, message, exception));
    }

    public static void warn(String message, Throwable ex) {
        CodePlugin.debug(message + ", ex:" + ex);
        CodePlugin.log((IStatus)new Status(2, plugin.getDescriptor().getUniqueIdentifier(), 0, message, ex));
    }

    public static IStatus error(String message) {
        return CodePlugin.error(message, null);
    }

    public static IStatus error(String message, Throwable exception) {
        if (debugging) {
            if (exception != null) {
                message = message + ": " + exception.toString();
            }
            CodePlugin.debug(message);
        }
        return CodePlugin.log((IStatus)new Status(4, "com.tssap.selena.cmf", 4, message, exception));
    }

    public static void debug(String message) {
        if (debugging) {
            CodePlugin.debug(message, null);
        }
    }

    public static void debug(String pattern, Object arg0) {
        if (debugging) {
            CodePlugin.debug(pattern, new Object[]{arg0});
        }
    }

    public static void debug(String pattern, Object arg0, Object arg1) {
        if (debugging) {
            CodePlugin.debug(pattern, new Object[]{arg0, arg1});
        }
    }

    private static void debug(String message, Object[] args) {
        if (args != null) {
            message = MessageFormat.format(message, args);
        }
        System.out.print("[cmf] ");
        System.out.println(message);
    }

    private static boolean isDebugging(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public CodePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        debugging = this.isDebugging();
        velocityMessages = this.getDebugOption(VELOCITY_MESSAGES);
        this.templateEngine = new TemplateEngine();
    }

    public boolean isLoggingVelocityMessages() {
        return velocityMessages;
    }

    private boolean getDebugOption(String name) {
        String key = this.getDescriptor().getUniqueIdentifier() + name;
        String value = Platform.getDebugOption((String)key);
        return Boolean.valueOf(value);
    }

    public void startup() throws CoreException {
        if (debugging) {
            IncrementalPatternBuilder.DEBUG = CodePlugin.isDebugging("com.tssap.selena.cmf/debug/recognizer");
        }
        CodePlugin.debug("STARTUP");
        this.restoreState();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)new JavaProjectAdapterFactory(), class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = CodePlugin.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject);
    }

    public void shutdown() throws CoreException {
        CodePlugin.debug("SHUTDOWN");
        this.saveState();
    }

    public PatternModel getPatternModel() {
        if (this.patternModel == null) {
            this.patternModel = new PatternModel();
        }
        return this.patternModel;
    }

    public IPatternRegistry getPatternRegistry() {
        if (this.patternRegistry == null) {
            this.patternRegistry = new PatternRegistry();
            try {
                this.hookPatternRegistry(this.getDescriptor().getExtensionPoint("patterns"));
            }
            catch (CoreException ex) {
                this.getLog().log(ex.getStatus());
            }
        }
        return this.patternRegistry;
    }

    public TemplateModel getTemplateModel() {
        if (this.templateModel == null) {
            this.templateModel = new TemplateModel();
        }
        return this.templateModel;
    }

    public ITemplateEngine getTemplateEngine() {
        this.getTemplateModel().getProjects();
        return this.templateEngine;
    }

    public ITemplateRegistry getTemplateRegistry() {
        if (this.templateRegistry == null) {
            this.templateRegistry = new TemplateRegistry();
            try {
                this.hookTemplateRegistry(this.getDescriptor().getExtensionPoint("templates"));
            }
            catch (CoreException ex) {
                this.getLog().log(ex.getStatus());
            }
        }
        return this.templateRegistry;
    }

    public InputStream openStream(String path) throws IOException {
        return this.openStream((IPath)new Path(path));
    }

    public String loadStream(String path) throws IOException {
        String string;
        URL url = new URL(this.getDescriptor().getInstallURL(), path);
        InputStream in = url.openStream();
        try {
            int length = in.available();
            char[] buffer = new char[length];
            InputStreamReader reader = new InputStreamReader(in);
            reader.read(buffer, 0, length);
            reader.close();
            string = new String(buffer);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return string;
    }

    private void hookPatternRegistry(IExtensionPoint pt) throws CoreException {
        IConfigurationElement[] exts = pt.getConfigurationElements();
        int i = 0;
        while (i < exts.length) {
            IPatternCategory entry;
            IConfigurationElement ext = exts[i];
            String name = ext.getName();
            if (name.equals("category") && (entry = this.createPatternCategory(ext)) != null) {
                this.patternRegistry.addCategory(entry);
            }
            ++i;
        }
        this.patternRegistry.setDefaultCategory(new PatternCategory("misc", "Miscellaneous"));
        int i2 = 0;
        while (i2 < exts.length) {
            IPatternExtension entry;
            IConfigurationElement ext = exts[i2];
            String name = ext.getName();
            if (name.equals("pattern") && (entry = this.createPatternExtension(ext)) != null) {
                this.patternRegistry.addExtension(entry);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < exts.length) {
            IPatternRecognizer entry;
            IConfigurationElement ext = exts[i3];
            String name = ext.getName();
            if (name.equals("recognizer") && (entry = this.createPatternRecognizer(ext)) != null) {
                this.patternRegistry.addRecognizer(entry);
            }
            ++i3;
        }
    }

    private IPatternCategory createPatternCategory(IConfigurationElement el) throws CoreException {
        String id = el.getAttribute("id");
        String name = el.getAttribute("name");
        if (id == null || name == null) {
            CodePlugin.error("cannot create a pattern category: " + el);
            return null;
        }
        return new PatternCategory(id, name);
    }

    private IPatternExtension createPatternExtension(IConfigurationElement el) {
        try {
            return (IPatternExtension)el.createExecutableExtension("class");
        }
        catch (CoreException e) {
            CodePlugin.error("cannot create a pattern extension", e);
            return null;
        }
    }

    private IPatternRecognizer createPatternRecognizer(IConfigurationElement el) {
        try {
            return (IPatternRecognizer)el.createExecutableExtension("class");
        }
        catch (CoreException e) {
            CodePlugin.error("cannot create a pattern recognizer", e);
            return null;
        }
    }

    private void hookTemplateRegistry(IExtensionPoint pt) throws CoreException {
        IConfigurationElement[] exts = pt.getConfigurationElements();
        int i = 0;
        while (i < exts.length) {
            ITemplateExtension entry;
            IConfigurationElement ext = exts[i];
            String name = ext.getName();
            if (name.equals("template") && (entry = this.createTemplateExtension(ext)) != null) {
                this.templateRegistry.addExtension(entry);
            }
            ++i;
        }
    }

    private ITemplateExtension createTemplateExtension(IConfigurationElement el) {
        try {
            return (ITemplateExtension)el.createExecutableExtension("class");
        }
        catch (CoreException e) {
            CodePlugin.error("cannot create a template extension", e);
            return null;
        }
    }

    public void saveState() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)MEMENTO_ROOT);
        this.saveState((IMemento)memento);
        File file = this.getMementoFile();
        try {
            FileOutputStream out = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "utf-8");
            memento.save((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            CodePlugin.error("cannot save state", e);
            file.delete();
        }
    }

    private void saveState(IMemento memento) {
        this.templateEngine.saveState(memento.createChild("TemplateEngine"));
        this.getPatternModel().saveState(memento.createChild("PatternModel"));
    }

    public void restoreState() {
        try {
            File file = this.getMementoFile();
            if (file.exists()) {
                FileInputStream in = new FileInputStream(file);
                InputStreamReader reader = new InputStreamReader((InputStream)in, "utf-8");
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                this.restoreState((IMemento)memento);
                reader.close();
            }
        }
        catch (Exception e) {
            CodePlugin.error("cannot restore state", e);
        }
    }

    private void restoreState(IMemento memento) {
        IMemento node = memento.getChild("TemplateEngine");
        if (node != null) {
            this.templateEngine.restoreState(node);
        }
        if ((node = memento.getChild("PatternModel")) != null) {
            this.getPatternModel().restoreState(node);
        }
    }

    private File getMementoFile() {
        IPath path = this.getStateLocation();
        path = path.append(MEMENTO_FILE);
        return path.toFile();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

