/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.umldoclet.uml;

import com.togethersoft.umldoclet.uml.UMLClass;
import com.togethersoft.umldoclet.uml.UMLElement;
import com.togethersoft.umldoclet.uml.UMLLink;
import com.togethersoft.umldoclet.uml.UMLMember;
import com.togethersoft.umldoclet.uml.UMLModel;
import com.togethersoft.umldoclet.uml.UMLProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Parser {
    private UMLModel myModel = null;

    public boolean parse(String string) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(string));
        }
        catch (IOException iOException) {
            System.err.println("Can't find file: " + string);
            return false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Parsing failed: " + string);
            return false;
        }
        catch (SAXException sAXException) {
            System.err.println("Parsing failed. " + sAXException);
            return false;
        }
        this.myModel = new UMLModel();
        NodeList nodeList = document.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if ("uml".equals(node.getNodeName())) {
                this.parseRootNode(node);
                break;
            }
            ++n;
        }
        return true;
    }

    public UMLModel getModel() {
        return this.myModel;
    }

    private void parseRootNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if ("classifier".equals(node2.getNodeName())) {
                Object object;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                String string = null;
                int n2 = 0;
                while (n2 < namedNodeMap.getLength()) {
                    object = namedNodeMap.item(n2);
                    if ("qualifiedName".equals(object.getNodeName())) {
                        string = object.getNodeValue();
                        break;
                    }
                    ++n2;
                }
                if (string != null) {
                    object = new UMLClass();
                    this.parseClassifierNode(node2, (UMLClass)object);
                    this.myModel.addClass(string, (UMLClass)object);
                }
            }
            ++n;
        }
    }

    private void parseClassifierNode(Node node, UMLClass uMLClass) {
        ArrayList arrayList = new ArrayList();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                Element element = (Element)nodeList.item(n);
                String string = element.getNodeName();
                if ("properties".equals(string)) {
                    this.parseProperties(element, uMLClass);
                } else if ("links".equals(string)) {
                    this.parseLinks(element, uMLClass);
                } else if ("members".equals(string)) {
                    this.parseMembers(element, uMLClass);
                }
            }
            ++n;
        }
    }

    private void parseProperties(Element element, UMLElement uMLElement) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            UMLProperty uMLProperty;
            Node node = nodeList.item(n);
            if (node instanceof Element && "property".equals(node.getNodeName()) && (uMLProperty = this.parseUMLProperty((Element)node)) != null) {
                uMLElement.getPropertyMap().addProperty(uMLProperty);
            }
            ++n;
        }
    }

    private UMLProperty parseUMLProperty(Element element) {
        String string = element.getAttribute("name");
        if (string.length() == 0) {
            System.err.println("Element " + element.getNodeName() + " doesn't have name attribute");
            return null;
        }
        String string2 = element.getAttribute("value");
        String string3 = null;
        if (string2.length() == 0) {
            string2 = null;
        } else {
            string3 = element.getAttribute("reference");
            if (string3.length() == 0) {
                string3 = null;
            }
        }
        return new UMLProperty(string, string2, string3);
    }

    private void parseLinks(Element element, UMLClass uMLClass) {
        String string = element.getAttribute("metaclass");
        if (string.length() == 0) {
            return;
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            UMLLink uMLLink;
            Node node = nodeList.item(n);
            if (node instanceof Element && "link".equals(node.getNodeName()) && (uMLLink = this.parseUMLLink((Element)node)) != null) {
                uMLClass.addLink(string, uMLLink);
            }
            ++n;
        }
    }

    private UMLLink parseUMLLink(Element element) {
        String string = element.getAttribute("supplierMetaclass");
        String string2 = element.getAttribute("toObject");
        if (string.length() == 0 || string2.length() == 0) {
            System.err.println("Link is not complete");
            return null;
        }
        String string3 = element.getAttribute("reference");
        if (string3.length() == 0) {
            string3 = null;
        }
        UMLLink uMLLink = new UMLLink(string, string2, string3);
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element && "properties".equals(node.getNodeName())) {
                this.parseProperties((Element)node, uMLLink);
            }
            ++n;
        }
        return uMLLink;
    }

    private void parseMembers(Element element, UMLClass uMLClass) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            UMLMember uMLMember;
            Node node = nodeList.item(n);
            if (node instanceof Element && "member".equals(node.getNodeName()) && (uMLMember = this.parseUMLMember((Element)node)) != null) {
                uMLClass.addMember(uMLMember);
            }
            ++n;
        }
    }

    private UMLMember parseUMLMember(Element element) {
        String string = element.getAttribute("name");
        if (string.length() == 0) {
            System.err.println("Element " + element.getNodeName() + " doesn't have name attribute");
            return null;
        }
        String string2 = element.getAttribute("parameters");
        UMLMember uMLMember = new UMLMember(string, string2);
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element && "properties".equals(node.getNodeName())) {
                this.parseProperties((Element)node, uMLMember);
            }
            ++n;
        }
        return uMLMember;
    }

    static interface IAttributes {
        public static final String QUALIFIED_NAME = "qualifiedName";
        public static final String PROP_VALUE = "value";
        public static final String LNK_METACLASS = "metaclass";
        public static final String LNK_SUPPLIER_METACLASS = "supplierMetaclass";
        public static final String LNK_TO_OBJECT = "toObject";
        public static final String PARAMETERS = "parameters";
        public static final String NAME = "name";
        public static final String REFERENCE = "reference";
    }

    static interface IElements {
        public static final String UML = "uml";
        public static final String CLASSIFIER = "classifier";
        public static final String PROPERTIES = "properties";
        public static final String LINKS = "links";
        public static final String MEMBERS = "members";
        public static final String PROPERTY = "property";
        public static final String LINK = "link";
        public static final String MEMBER = "member";
    }
}

