/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.umldoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.togethersoft.umldoclet.AllClassesFrameWriter;
import com.togethersoft.umldoclet.ClassTree;
import com.togethersoft.umldoclet.ClassUseMapper;
import com.togethersoft.umldoclet.ConfigurationStandard;
import com.togethersoft.umldoclet.DeprecatedListWriter;
import com.togethersoft.umldoclet.DocletAbortException;
import com.togethersoft.umldoclet.FrameOutputWriter;
import com.togethersoft.umldoclet.HelpWriter;
import com.togethersoft.umldoclet.HtmlDocWriter;
import com.togethersoft.umldoclet.IndexBuilder;
import com.togethersoft.umldoclet.PackageFrameWriter;
import com.togethersoft.umldoclet.PackageIndexFrameWriter;
import com.togethersoft.umldoclet.PackageIndexWriter;
import com.togethersoft.umldoclet.PackageListWriter;
import com.togethersoft.umldoclet.PackageTreeWriter;
import com.togethersoft.umldoclet.PackageWriter;
import com.togethersoft.umldoclet.PackagesFileWriter;
import com.togethersoft.umldoclet.SerializedFormWriter;
import com.togethersoft.umldoclet.SingleIndexWriter;
import com.togethersoft.umldoclet.SplitIndexWriter;
import com.togethersoft.umldoclet.StylesheetWriter;
import com.togethersoft.umldoclet.TreeWriter;
import com.togethersoft.umldoclet.UMLClassWriter;
import com.togethersoft.umldoclet.uml.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class UMLDoclet {
    private static final String UML_PROPS_FILE_NAME = "uml_properties.xml";

    public static boolean start(RootDoc rootDoc) throws IOException {
        try {
            UMLDoclet.configuration().setOptions(rootDoc);
            new UMLDoclet().startGeneration(rootDoc);
        }
        catch (DocletAbortException docletAbortException) {
            return false;
        }
        return true;
    }

    public static ConfigurationStandard configuration() {
        if (HtmlDocWriter.configuration == null) {
            HtmlDocWriter.configuration = new ConfigurationStandard("UTF-8");
        }
        return (ConfigurationStandard)HtmlDocWriter.configuration;
    }

    protected void startGeneration(RootDoc rootDoc) throws DocletAbortException {
        Parser parser = new Parser();
        String string = System.getProperty("user.dir") + "/" + UML_PROPS_FILE_NAME;
        boolean bl = parser.parse(string);
        if (bl) {
            UMLDoclet.configuration().setUMLModel(parser.getModel());
        }
        if (rootDoc.classes().length == 0) {
            UMLDoclet.configuration();
            ConfigurationStandard.standardmessage.error("doclet.No_Public_Classes_To_Document");
            return;
        }
        if (UMLDoclet.configuration().topFile.length() == 0) {
            UMLDoclet.configuration();
            ConfigurationStandard.standardmessage.error("doclet.No_Non_Deprecated_Classes_To_Document");
            return;
        }
        boolean bl2 = UMLDoclet.configuration().nodeprecated;
        String string2 = UMLDoclet.configuration().destdirname;
        String string3 = UMLDoclet.configuration().helpfile;
        String string4 = UMLDoclet.configuration().stylesheetfile;
        this.performCopy(string2, string3);
        this.performCopy(string2, string4);
        ClassTree classTree = new ClassTree(rootDoc, bl2);
        if (UMLDoclet.configuration().classuse) {
            ClassUseMapper.generate(rootDoc, classTree);
        }
        IndexBuilder indexBuilder = new IndexBuilder(rootDoc, bl2);
        PackageDoc[] packageDocArray = UMLDoclet.configuration().packages;
        if (UMLDoclet.configuration().createtree) {
            TreeWriter.generate(classTree);
        }
        if (UMLDoclet.configuration().createindex) {
            if (UMLDoclet.configuration().splitindex) {
                SplitIndexWriter.generate(indexBuilder);
            } else {
                SingleIndexWriter.generate(indexBuilder);
            }
        }
        if (!UMLDoclet.configuration().nodeprecatedlist && !bl2) {
            DeprecatedListWriter.generate(rootDoc);
        }
        AllClassesFrameWriter.generate(new IndexBuilder(rootDoc, bl2, true));
        FrameOutputWriter.generate();
        PackagesFileWriter.generate();
        if (UMLDoclet.configuration().createoverview) {
            PackageIndexWriter.generate(rootDoc);
        }
        if (packageDocArray.length > 1) {
            PackageIndexFrameWriter.generate();
        }
        int n = 0;
        while (n < packageDocArray.length) {
            PackageDoc packageDoc = n == 0 ? null : packageDocArray[n - 1];
            PackageDoc packageDoc2 = packageDocArray[n];
            PackageDoc packageDoc3 = n + 1 == packageDocArray.length ? null : packageDocArray[n + 1];
            PackageWriter.generate(packageDocArray[n], packageDoc, packageDoc3);
            if (UMLDoclet.configuration().createtree) {
                PackageTreeWriter.generate(packageDocArray[n], packageDoc, packageDoc3, bl2);
            }
            PackageFrameWriter.generate(packageDocArray[n]);
            ++n;
        }
        this.generateClassFiles(rootDoc, classTree);
        SerializedFormWriter.generate(rootDoc);
        PackageListWriter.generate(rootDoc);
        if (UMLDoclet.configuration().helpfile.length() == 0 && !UMLDoclet.configuration().nohelp) {
            HelpWriter.generate();
        }
        if (UMLDoclet.configuration().stylesheetfile.length() == 0) {
            StylesheetWriter.generate();
        }
    }

    protected void generateClassFiles(RootDoc rootDoc, ClassTree classTree) throws DocletAbortException {
        ClassDoc classDoc;
        ClassDoc[] classDocArray = rootDoc.specifiedClasses();
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
        int n = 0;
        while (n < classDocArray.length) {
            classDoc = classDocArray[n];
            if (classDoc.isIncluded() && UMLDoclet.isGeneratedDoc((Doc)classDoc)) {
                arrayList.add(classDoc);
            }
            ++n;
        }
        classDoc = new ClassDoc[arrayList.size()];
        int n2 = 0;
        while (n2 < ((ClassDoc)classDoc).length) {
            classDoc[n2] = (ClassDoc)arrayList.get(n2);
            ++n2;
        }
        this.generateClassCycle((ClassDoc[])classDoc, classTree, true);
        PackageDoc[] packageDocArray = UMLDoclet.configuration().packages;
        int n3 = 0;
        while (n3 < packageDocArray.length) {
            PackageDoc packageDoc = packageDocArray[n3];
            this.generateClassCycle(packageDoc.interfaces(), classTree, false);
            this.generateClassCycle(packageDoc.ordinaryClasses(), classTree, false);
            this.generateClassCycle(packageDoc.exceptions(), classTree, false);
            this.generateClassCycle(packageDoc.errors(), classTree, false);
            ++n3;
        }
    }

    protected String classFileName(ClassDoc classDoc) {
        return classDoc.qualifiedName() + ".html";
    }

    protected void generateClassCycle(ClassDoc[] classDocArray, ClassTree classTree, boolean bl) throws DocletAbortException {
        Arrays.sort(classDocArray);
        int n = 0;
        while (n < classDocArray.length) {
            if (!UMLDoclet.configuration().nodeprecated || classDocArray[n].tags("deprecated").length <= 0) {
                ClassDoc classDoc = n == 0 ? null : classDocArray[n - 1];
                ClassDoc classDoc2 = classDocArray[n];
                ClassDoc classDoc3 = n + 1 == classDocArray.length ? null : classDocArray[n + 1];
                UMLClassWriter.generate(classDoc2, classDoc, classDoc3, classTree, bl);
            }
            ++n;
        }
    }

    public static int optionLength(String string) {
        return UMLDoclet.configuration().optionLength(string);
    }

    public static boolean validOptions(String[][] stringArray, DocErrorReporter docErrorReporter) throws IOException {
        return UMLDoclet.configuration().validOptions(stringArray, docErrorReporter);
    }

    public static void copyFile(File file, File file2) throws DocletAbortException, IOException {
        byte[] byArray = new byte[512];
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            try {
                while ((n = fileInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DocletAbortException();
            }
            catch (SecurityException securityException) {
                throw new DocletAbortException();
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            fileInputStream.close();
            fileOutputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    protected void performCopy(String string, String string2) throws DocletAbortException {
        try {
            String string3;
            String string4 = string3 = string.length() > 0 ? (string3 = string + File.separatorChar) : "";
            if (string2.length() > 0) {
                File file = new File(string2);
                String string5 = file.getParent();
                String string6 = string5 == null ? string2 : string2.substring(string5.length() + 1);
                File file2 = new File(string3 + string6);
                if (!file2.getCanonicalPath().equals(file.getCanonicalPath())) {
                    UMLDoclet.configuration();
                    ConfigurationStandard.standardmessage.notice("doclet.Copying_File_0_To_File_1", file.toString(), file2.toString());
                    UMLDoclet.copyFile(file2, file);
                }
            }
        }
        catch (IOException iOException) {
            UMLDoclet.configuration();
            ConfigurationStandard.standardmessage.error("doclet.perform_copy_exception_encountered", iOException.toString());
            throw new DocletAbortException();
        }
    }

    public static boolean isGeneratedDoc(Doc doc) {
        if (!UMLDoclet.configuration().nodeprecated) {
            return true;
        }
        return doc.tags("deprecated").length == 0;
    }
}

