/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.umldoclet;

import com.sun.javadoc.PackageDoc;
import com.togethersoft.umldoclet.AbstractTreeWriter;
import com.togethersoft.umldoclet.ClassTree;
import com.togethersoft.umldoclet.ConfigurationStandard;
import com.togethersoft.umldoclet.DocletAbortException;
import com.togethersoft.umldoclet.UMLDoclet;
import java.io.IOException;

public class TreeWriter
extends AbstractTreeWriter {
    private PackageDoc[] packages;
    private boolean classesonly;

    public TreeWriter(String string, ClassTree classTree) throws IOException, DocletAbortException {
        super(string, classTree);
        this.packages = UMLDoclet.configuration().packages;
        this.classesonly = this.packages.length == 0;
    }

    public static void generate(ClassTree classTree) throws DocletAbortException {
        String string = "overview-tree.html";
        try {
            TreeWriter treeWriter = new TreeWriter(string, classTree);
            treeWriter.generateTreeFile();
            treeWriter.close();
        }
        catch (IOException iOException) {
            UMLDoclet.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    public void generateTreeFile() throws IOException {
        this.printHeader(this.getText("doclet.Window_Class_Hierarchy", UMLDoclet.configuration().windowtitle));
        this.printTreeHeader();
        this.printPageHeading();
        this.printPackageTreeLinks();
        this.generateTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy");
        this.generateTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy");
        this.printTreeFooter();
    }

    protected void printPackageTreeLinks() {
        if (!this.classesonly) {
            this.dl();
            this.dt();
            this.boldText("doclet.Package_Hierarchies");
            this.dd();
            int n = 0;
            while (n < this.packages.length) {
                String string = this.pathString(this.packages[n], "package-tree.html");
                this.printHyperLink(string, "", this.packages[n].name());
                if (n < this.packages.length - 1) {
                    this.print(", ");
                }
                ++n;
            }
            this.dlEnd();
            this.hr();
        }
    }

    protected void printTreeHeader() {
        this.navLinks(true);
        this.hr();
    }

    protected void printTreeFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPageHeading() {
        this.center();
        this.h2();
        this.printText("doclet.Hierarchy_For_All_Packages");
        this.h2End();
        this.centerEnd();
    }
}

