/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.umldoclet;

import com.sun.javadoc.PackageDoc;
import com.togethersoft.umldoclet.AbstractTreeWriter;
import com.togethersoft.umldoclet.ClassTree;
import com.togethersoft.umldoclet.ConfigurationStandard;
import com.togethersoft.umldoclet.DirectoryManager;
import com.togethersoft.umldoclet.DocletAbortException;
import com.togethersoft.umldoclet.UMLDoclet;
import java.io.IOException;

public class PackageTreeWriter
extends AbstractTreeWriter {
    protected PackageDoc packagedoc;
    protected PackageDoc prev;
    protected PackageDoc next;

    public PackageTreeWriter(String string, String string2, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3, boolean bl) throws IOException, DocletAbortException {
        super(string, string2, new ClassTree(packageDoc.allClasses(), bl), packageDoc);
        this.packagedoc = packageDoc;
        this.prev = packageDoc2;
        this.next = packageDoc3;
    }

    public static void generate(PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3, boolean bl) throws DocletAbortException {
        String string = DirectoryManager.getDirectoryPath(packageDoc);
        String string2 = "package-tree.html";
        try {
            PackageTreeWriter packageTreeWriter = new PackageTreeWriter(string, string2, packageDoc, packageDoc2, packageDoc3, bl);
            packageTreeWriter.generatePackageTreeFile();
            packageTreeWriter.close();
        }
        catch (IOException iOException) {
            UMLDoclet.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageTreeFile() throws IOException {
        this.printHeader(this.getText("doclet.Window_Package_Class_Hierarchy", UMLDoclet.configuration().windowtitle, this.packagedoc.name()));
        this.printPackageTreeHeader();
        if (UMLDoclet.configuration().packages.length > 1) {
            this.printLinkToMainTree();
        }
        this.generateTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy");
        this.generateTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy");
        this.printPackageTreeFooter();
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPackageTreeHeader() {
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2(this.getText("doclet.Hierarchy_For_Package", this.packagedoc.name()));
        this.centerEnd();
    }

    protected void printLinkToMainTree() {
        this.dl();
        this.dt();
        this.boldText("doclet.Package_Hierarchies");
        this.dd();
        this.navLinkMainTree(this.getText("doclet.All_Packages"));
        this.dlEnd();
        this.hr();
    }

    protected void printPackageTreeFooter() {
        this.hr();
        this.navLinks(false);
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.navLinkPrevious(null);
        } else {
            String string = DirectoryManager.getRelativePath(this.packagedoc.name(), this.prev.name());
            this.navLinkPrevious(string + "package-tree.html");
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.navLinkNext(null);
        } else {
            String string = DirectoryManager.getRelativePath(this.packagedoc.name(), this.next.name());
            this.navLinkNext(string + "package-tree.html");
        }
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

