/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.umldoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.togethersoft.umldoclet.ConfigurationStandard;
import com.togethersoft.umldoclet.SubWriterHolderWriter;
import com.togethersoft.umldoclet.UMLDoclet;
import com.togethersoft.umldoclet.UMLWriterUtil;
import com.togethersoft.umldoclet.uml.UMLClass;
import com.togethersoft.umldoclet.uml.UMLElement;
import com.togethersoft.umldoclet.uml.UMLModel;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSubWriter {
    protected final SubWriterHolderWriter writer;
    public List inhmembers;
    public List supclasses;

    protected AbstractSubWriter(SubWriterHolderWriter subWriterHolderWriter) {
        this.writer = subWriterHolderWriter;
    }

    public abstract ProgramElementDoc[] members(ClassDoc var1);

    public abstract void printSummaryLabel(ClassDoc var1);

    public abstract void printInheritedSummaryLabel(ClassDoc var1);

    public abstract void printSummaryAnchor(ClassDoc var1);

    public abstract void printInheritedSummaryAnchor(ClassDoc var1);

    protected abstract void printSummaryType(ProgramElementDoc var1);

    protected abstract void printSummaryLink(ClassDoc var1, ProgramElementDoc var2);

    protected abstract void printInheritedSummaryLink(ClassDoc var1, ProgramElementDoc var2);

    protected abstract void printHeader(ClassDoc var1);

    protected abstract void printBodyHtmlEnd(ClassDoc var1);

    protected abstract void printMember(ProgramElementDoc var1);

    protected abstract void printDeprecatedLink(ProgramElementDoc var1);

    protected abstract void printNavSummaryLink(ClassDoc var1, boolean var2);

    protected abstract void printNavDetailLink(boolean var1);

    protected void print(String string) {
        this.writer.print(string);
        this.writer.displayLength += string.length();
    }

    protected void print(char c) {
        this.writer.print(c);
        ++this.writer.displayLength;
    }

    protected void bold(String string) {
        this.writer.bold(string);
        this.writer.displayLength += string.length();
    }

    protected void printTypeLinkNoDimension(Type type) {
        ClassDoc classDoc = type.asClassDoc();
        if (classDoc == null) {
            this.print(type.typeName());
        } else {
            this.writer.printClassLink(classDoc);
        }
    }

    protected void printTypeLink(Type type) {
        this.printTypeLinkNoDimension(type);
        this.print(type.dimension());
    }

    protected String modifierString(MemberDoc memberDoc) {
        int n = memberDoc.modifierSpecifier();
        int n2 = 288;
        return Modifier.toString(n & ~n2);
    }

    protected String typeString(MemberDoc memberDoc) {
        String string = "";
        if (memberDoc instanceof MethodDoc) {
            string = ((MethodDoc)memberDoc).returnType().toString();
        } else if (memberDoc instanceof FieldDoc) {
            string = ((FieldDoc)memberDoc).type().toString();
        }
        return string;
    }

    protected void printModifiers(MemberDoc memberDoc) {
        String string = this.modifierString(memberDoc);
        if (string.length() > 0) {
            this.print(string);
            this.print(' ');
        }
    }

    protected void printTypedName(Type type, String string) {
        if (type != null) {
            this.printTypeLink(type);
        }
        if (string.length() > 0) {
            this.writer.space();
            this.writer.print(string);
        }
    }

    protected String makeSpace(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void printStaticAndType(boolean bl, Type type) {
        this.writer.printTypeSummaryHeader();
        if (bl) {
            this.print("static");
        }
        this.writer.space();
        if (type != null) {
            this.printTypeLink(type);
        }
        this.writer.printTypeSummaryFooter();
    }

    protected void printModifierAndType(ProgramElementDoc programElementDoc, Type type) {
        this.writer.printTypeSummaryHeader();
        this.printModifier(programElementDoc);
        if (type == null) {
            if (programElementDoc.isClass()) {
                this.print("class");
            } else {
                this.print("interface");
            }
        } else {
            this.printTypeLink(type);
        }
        this.writer.printTypeSummaryFooter();
    }

    protected void printModifier(ProgramElementDoc programElementDoc) {
        if (programElementDoc.isProtected()) {
            this.print("protected ");
        } else if (programElementDoc.isPrivate()) {
            this.print("private ");
        } else if (!programElementDoc.isPublic()) {
            this.writer.printText("doclet.Package_private");
            this.print(" ");
        }
        if (programElementDoc.isMethod() && ((MethodDoc)programElementDoc).isAbstract()) {
            this.print("abstract ");
        }
        if (programElementDoc.isStatic()) {
            this.print("static");
        }
        this.writer.space();
    }

    protected void printComment(ProgramElementDoc programElementDoc) {
        if (programElementDoc.inlineTags().length > 0) {
            this.writer.dd();
            this.writer.printInlineComment((Doc)programElementDoc);
        }
    }

    protected void printTags(ProgramElementDoc programElementDoc) {
        Tag[] tagArray = programElementDoc.tags("since");
        if (programElementDoc.seeTags().length + tagArray.length > 0) {
            this.writer.dd();
            this.writer.dl();
            this.writer.printSeeTags((Doc)programElementDoc);
            this.writer.printSinceTag((Doc)programElementDoc);
            this.writer.dlEnd();
            this.writer.ddEnd();
        }
    }

    protected String name(ProgramElementDoc programElementDoc) {
        return programElementDoc.name();
    }

    protected void printDeprecated(ProgramElementDoc programElementDoc) {
        Tag[] tagArray = programElementDoc.tags("deprecated");
        if (tagArray.length > 0) {
            this.writer.dd();
            this.writer.boldText("doclet.Deprecated");
            this.writer.space();
            this.writer.printInlineDeprecatedComment(tagArray[0]);
            this.writer.p();
        } else {
            this.printDeprecatedClassComment(programElementDoc);
        }
    }

    protected void printDeprecatedClassComment(ProgramElementDoc programElementDoc) {
        Tag[] tagArray = programElementDoc.containingClass().tags("deprecated");
        if (tagArray.length > 0) {
            this.writer.dd();
            this.writer.boldText("doclet.Deprecated");
            this.writer.space();
        }
    }

    protected void printHead(MemberDoc memberDoc) {
        this.writer.h3();
        this.writer.print(memberDoc.name());
        this.writer.h3End();
    }

    protected void printFullComment(ProgramElementDoc programElementDoc) {
        this.writer.dl();
        this.printDeprecated(programElementDoc);
        this.printCommentAndTags(programElementDoc);
        this.writer.dlEnd();
    }

    protected void printCommentAndTags(ProgramElementDoc programElementDoc) {
        this.printComment(programElementDoc);
        this.printTags(programElementDoc);
    }

    public void printSummaryHeader(ClassDoc classDoc) {
        this.writer.printSummaryHeader(this, classDoc);
    }

    public void printInheritedSummaryHeader(ClassDoc classDoc) {
        this.writer.printInheritedSummaryHeader(this, classDoc);
    }

    public void printInheritedSummaryFooter(ClassDoc classDoc) {
        this.writer.printInheritedSummaryFooter(this, classDoc);
    }

    public void printSummaryFooter(ClassDoc classDoc) {
        this.writer.printSummaryFooter(this, classDoc);
    }

    public void printSummaryMember(ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.writer.printSummaryMember(this, classDoc, programElementDoc);
    }

    public void printInheritedSummaryMember(ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.writer.printInheritedSummaryMember(this, classDoc, programElementDoc);
    }

    public void printMembersSummary(ClassDoc classDoc) {
        Object[] objectArray = this.members(classDoc);
        if (objectArray.length > 0) {
            Arrays.sort(objectArray);
            this.printSummaryHeader(classDoc);
            int n = 0;
            while (n < objectArray.length) {
                this.printSummaryMember(classDoc, (ProgramElementDoc)objectArray[n]);
                ++n;
            }
            this.printSummaryFooter(classDoc);
        }
    }

    public void printInheritedMembersSummary(ClassDoc classDoc) {
        this.inhmembers = new ArrayList();
        this.supclasses = new ArrayList();
        this.printRecursivelyInheritedMembersSummary(classDoc);
    }

    public void printRecursivelyInheritedMembersSummary(ClassDoc classDoc) {
        if (classDoc.isClass()) {
            ClassDoc classDoc2 = classDoc.superclass();
            while (classDoc2 != null) {
                this.printInheritedMembersInfo(classDoc2);
                classDoc2 = classDoc2.superclass();
            }
            this.printInheritedMembersSummaryForImplInterfaces(classDoc);
        } else {
            this.printInheritedMembersSummaryForImplInterfaces(classDoc);
        }
    }

    public void printInheritedMembersSummaryForImplInterfaces(ClassDoc classDoc) {
        ClassDoc[] classDocArray = classDoc.interfaces();
        int n = 0;
        while (n < classDocArray.length) {
            this.printInheritedMembersInfo(classDocArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < classDocArray.length) {
            this.printRecursivelyInheritedMembersSummary(classDocArray[n2]);
            ++n2;
        }
    }

    protected void printInheritedMembersInfo(ClassDoc classDoc) {
        if (this.supclasses.contains(classDoc)) {
            return;
        }
        this.supclasses.add(classDoc);
        Object[] objectArray = this.members(classDoc);
        objectArray = this.checkForDuplicateMembers((ProgramElementDoc[])objectArray);
        if (objectArray.length > 0) {
            Arrays.sort(objectArray);
            this.printInheritedSummaryHeader(classDoc);
            this.printInheritedSummaryMember(classDoc, (ProgramElementDoc)objectArray[0]);
            int n = 1;
            while (n < objectArray.length) {
                this.print(", ");
                this.writer.println(' ');
                this.printInheritedSummaryMember(classDoc, (ProgramElementDoc)objectArray[n]);
                ++n;
            }
            this.printInheritedSummaryFooter(classDoc);
        }
    }

    protected ProgramElementDoc[] checkForDuplicateMembers(ProgramElementDoc[] programElementDocArray) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        int n = 0;
        while (n < programElementDocArray.length) {
            ProgramElementDoc programElementDoc = programElementDocArray[n];
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.inhmembers.size()) {
                ProgramElementDoc programElementDoc2 = (ProgramElementDoc)this.inhmembers.get(n2);
                if (AbstractSubWriter.isEqual(programElementDoc, programElementDoc2)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                arrayList.add(programElementDoc);
                this.inhmembers.add(programElementDoc);
            }
            ++n;
        }
        return arrayList.toArray(new ProgramElementDoc[arrayList.size()]);
    }

    public static boolean isEqual(ProgramElementDoc programElementDoc, ProgramElementDoc programElementDoc2) {
        if (programElementDoc instanceof ExecutableMemberDoc && programElementDoc2 instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)programElementDoc;
            ExecutableMemberDoc executableMemberDoc2 = (ExecutableMemberDoc)programElementDoc2;
            return executableMemberDoc.name().equals(executableMemberDoc2.name()) && executableMemberDoc.signature().equals(executableMemberDoc2.signature());
        }
        return programElementDoc.name().equals(programElementDoc2.name());
    }

    public void printMembers(ClassDoc classDoc) {
        ProgramElementDoc[] programElementDocArray = this.members(classDoc);
        if (programElementDocArray.length > 0) {
            UMLClass uMLClass = null;
            UMLModel uMLModel = UMLDoclet.configuration().getUMLModel();
            if (uMLModel != null) {
                uMLClass = uMLModel.getClass(classDoc.qualifiedName());
            }
            this.printHeader(classDoc);
            int n = 0;
            while (n < programElementDocArray.length) {
                if (n > 0) {
                    this.writer.printMemberHeader();
                }
                this.writer.println("");
                this.printMember(programElementDocArray[n]);
                this.writer.printMemberFooter();
                if (uMLClass != null) {
                    Object object;
                    String string = programElementDocArray[n].name();
                    Parameter[] parameterArray = null;
                    if (programElementDocArray[n] instanceof ExecutableMemberDoc) {
                        object = (ExecutableMemberDoc)programElementDocArray[n];
                        parameterArray = object.parameters();
                    }
                    if ((object = uMLClass.findMember(string, parameterArray)) != null) {
                        UMLWriterUtil.printUMLProperties(this.writer, (UMLElement)object, true);
                    }
                }
                ++n;
            }
            this.printBodyHtmlEnd(classDoc);
        }
    }

    protected void printDeprecatedAPI(List list, String string) {
        if (list.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableHeaderStart("#CCCCFF");
            this.writer.boldText(string);
            this.writer.tableHeaderEnd();
            int n = 0;
            while (n < list.size()) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)list.get(n);
                ClassDoc classDoc = programElementDoc.containingClass();
                this.writer.trBgcolorStyle("white", "TableRowColor");
                this.writer.summaryRow(0);
                this.printDeprecatedLink(programElementDoc);
                this.writer.br();
                this.writer.printNbsps();
                this.writer.printInlineDeprecatedComment(programElementDoc.tags("deprecated")[0]);
                this.writer.space();
                this.writer.summaryRowEnd();
                this.writer.trEnd();
                ++n;
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void printUseInfo(Object object, String string) {
        if (object == null) {
            return;
        }
        List list = (List)object;
        if (list.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableUseInfoHeaderStart("#CCCCFF");
            this.writer.print(string);
            this.writer.tableHeaderEnd();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.printSummaryMember(null, (ProgramElementDoc)iterator.next());
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void navSummaryLink(ClassDoc classDoc) {
        ProgramElementDoc[] programElementDocArray = this.members(classDoc);
        if (programElementDocArray.length > 0) {
            this.printNavSummaryLink(null, true);
            return;
        }
        ClassDoc classDoc2 = classDoc.superclass();
        while (classDoc2 != null) {
            ProgramElementDoc[] programElementDocArray2 = this.members(classDoc2);
            if (programElementDocArray2.length > 0) {
                this.printNavSummaryLink(classDoc2, true);
                return;
            }
            classDoc2 = classDoc2.superclass();
        }
        this.printNavSummaryLink(null, false);
    }

    protected void navDetailLink(ClassDoc classDoc) {
        ProgramElementDoc[] programElementDocArray = this.members(classDoc);
        this.printNavDetailLink(programElementDocArray.length > 0);
    }

    protected ProgramElementDoc[] eligibleMembers(ProgramElementDoc[] programElementDocArray) {
        if (!UMLDoclet.configuration().nodeprecated) {
            return programElementDocArray;
        }
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        int n = 0;
        while (n < programElementDocArray.length) {
            if (programElementDocArray[n].tags("deprecated").length == 0) {
                arrayList.add(programElementDocArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new ProgramElementDoc[arrayList.size()]);
    }

    protected void serialWarning(String string, String string2, String string3) {
        if (UMLDoclet.configuration().serialwarn) {
            UMLDoclet.configuration();
            ConfigurationStandard.standardmessage.warning(string, string2, string3);
        }
    }
}

