/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.umldoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.togethersoft.umldoclet.HtmlStandardWriter;
import com.togethersoft.umldoclet.IndexBuilder;
import java.io.IOException;
import java.util.List;

public class AbstractIndexWriter
extends HtmlStandardWriter {
    protected IndexBuilder indexbuilder;

    protected AbstractIndexWriter(String string, String string2, String string3, IndexBuilder indexBuilder) throws IOException {
        super(string, string2, string3);
        this.indexbuilder = indexBuilder;
    }

    protected AbstractIndexWriter(String string, IndexBuilder indexBuilder) throws IOException {
        super(string);
        this.indexbuilder = indexBuilder;
    }

    protected void navLinkIndex() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Index");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void generateContents(Character c, List list) {
        this.anchor("_" + c + "_");
        this.h2();
        this.bold(c.toString());
        this.h2End();
        this.dl();
        int n = 0;
        while (n < list.size()) {
            Doc doc = (Doc)list.get(n);
            if (doc instanceof MemberDoc) {
                this.printDescription((MemberDoc)doc);
            } else if (doc instanceof ClassDoc) {
                this.printDescription((ClassDoc)doc);
            } else if (doc instanceof PackageDoc) {
                this.printDescription((PackageDoc)doc);
            }
            ++n;
        }
        this.dlEnd();
        this.hr();
    }

    protected void printDescription(PackageDoc packageDoc) {
        this.dt();
        this.printPackageLink(packageDoc, true);
        this.print(" - ");
        this.print("package " + packageDoc.name());
        this.dd();
        this.printSummaryComment((Doc)packageDoc);
    }

    protected void printDescription(ClassDoc classDoc) {
        this.dt();
        this.printClassLink(classDoc, true);
        this.print(" - ");
        this.printClassInfo(classDoc);
        this.dd();
        this.printComment((ProgramElementDoc)classDoc);
    }

    protected void printClassInfo(ClassDoc classDoc) {
        if (classDoc.isOrdinaryClass()) {
            this.print("class ");
        } else if (classDoc.isInterface()) {
            this.print("interface ");
        } else if (classDoc.isException()) {
            this.print("exception ");
        } else {
            this.print("error ");
        }
        this.printPreQualifiedClassLink(classDoc);
        this.print('.');
    }

    protected void printDescription(MemberDoc memberDoc) {
        String string = memberDoc instanceof ExecutableMemberDoc ? memberDoc.name() + ((ExecutableMemberDoc)memberDoc).flatSignature() : memberDoc.name();
        ClassDoc classDoc = memberDoc.containingClass();
        String string2 = classDoc.qualifiedName();
        String string3 = classDoc.name();
        this.dt();
        this.printDocLink((Doc)memberDoc, string, true);
        this.println(" - ");
        this.printMemberDesc(memberDoc);
        this.println();
        this.dd();
        this.printComment((ProgramElementDoc)memberDoc);
        this.println();
    }

    protected void printComment(ProgramElementDoc programElementDoc) {
        Tag[] tagArray = programElementDoc.tags("deprecated");
        if (tagArray.length > 0) {
            this.boldText("doclet.Deprecated");
            this.space();
            this.printInlineDeprecatedComment(tagArray[0]);
        } else {
            ClassDoc classDoc = programElementDoc.containingClass();
            while (classDoc != null) {
                if (classDoc.tags("deprecated").length > 0) {
                    this.boldText("doclet.Deprecated");
                    this.space();
                    break;
                }
                classDoc = classDoc.containingClass();
            }
            this.printSummaryComment((Doc)programElementDoc);
        }
    }

    protected void printMemberDesc(MemberDoc memberDoc) {
        ClassDoc classDoc = memberDoc.containingClass();
        String string = (classDoc.isInterface() ? "interface " : "class ") + this.getPreQualifiedClassLink(classDoc);
        if (memberDoc.isField()) {
            if (memberDoc.isStatic()) {
                this.printText("doclet.Static_variable_in", string);
            } else {
                this.printText("doclet.Variable_in", string);
            }
        } else if (memberDoc.isConstructor()) {
            this.printText("doclet.Constructor_for", string);
        } else if (memberDoc.isMethod()) {
            if (memberDoc.isStatic()) {
                this.printText("doclet.Static_method_in", string);
            } else {
                this.printText("doclet.Method_in", string);
            }
        }
    }
}

