/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.xml.context;

import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.caf.ui.utils.xml.context.ContextIOException;
import com.sap.caf.ui.utils.xml.context.TypeUtils;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;

public class ContextWriter {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$xml$context$ContextWriter == null ? (class$com$sap$caf$ui$utils$xml$context$ContextWriter = ContextWriter.class$("com.sap.caf.ui.utils.xml.context.ContextWriter")) : class$com$sap$caf$ui$utils$xml$context$ContextWriter));
    private IWDNode m_root;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$xml$context$ContextWriter;

    public ContextWriter(IWDNode context) {
        this.m_root = context;
    }

    public void save(String fileName) throws ContextIOException {
        String method = "save(String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "save(String)", logger);
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            this.save(os);
        }
        catch (IOException e) {
            String errorMess = MessageFormat.format("Error saving context to xml(file name: {0})", fileName);
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "save(String)", errorMess, (Throwable)e);
            ContextIOException cxtIOException = new ContextIOException(errorMess, e);
            logger.throwing("save(String)", (Throwable)cxtIOException);
            throw cxtIOException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "save(String)", logger);
        }
    }

    public void save(OutputStream os) throws ContextIOException {
        String method = "save(OutputStream)";
        CAFUIPublicLogger.entering(null, jARMRequest, "save(OutputStream)", logger);
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<context>\n");
            this.saveNode(this.m_root, writer);
            writer.write("</context>\n");
            writer.flush();
        }
        catch (IOException e) {
            String errorMess = "Error saving context to xml";
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "save(OutputStream)", errorMess, (Throwable)e);
            ContextIOException cxtIOException = new ContextIOException(errorMess, e);
            logger.throwing("save(OutputStream)", (Throwable)cxtIOException);
            throw cxtIOException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "save(OutputStream)", logger);
        }
    }

    private void saveNode(IWDNode node, PrintWriter writer) {
        this.saveElements(node, writer);
        this.saveChildren(node, writer);
    }

    private void saveChildren(IWDNode node, PrintWriter writer) {
        IWDNodeInfo nodeInfo = node.getNodeInfo();
        writer.write("<children>\n");
        Iterator childrenItr = nodeInfo.iterateChildren();
        while (childrenItr.hasNext()) {
            IWDNodeInfo childInfo = (IWDNodeInfo)childrenItr.next();
            if (!childInfo.isSingleton()) continue;
            IWDNode childNode = node.getChildNode(childInfo.getName(), -1);
            writer.write("<node name=\"");
            writer.write(childInfo.getName());
            writer.write("\">\n");
            this.saveNode(childNode, writer);
            writer.write("</node>\n");
        }
        writer.write("</children>\n");
    }

    private void saveElements(IWDNode node, PrintWriter writer) {
        writer.write("<elements ");
        writer.write("select=\"");
        writer.write(String.valueOf(node.getLeadSelection()));
        writer.write("\">\n");
        for (int i = 0; i < node.size(); ++i) {
            IWDNodeElement el = node.getElementAt(i);
            this.saveElementAttributes(node, el, writer);
        }
        writer.write("</elements>\n");
    }

    private void saveElementAttributes(IWDNode node, IWDNodeElement el, PrintWriter writer) {
        IWDNodeInfo nodeInfo = node.getNodeInfo();
        writer.write("<element>\n");
        Iterator childrenItr = nodeInfo.iterateChildren();
        while (childrenItr.hasNext()) {
            IWDNodeInfo childInfo = (IWDNodeInfo)childrenItr.next();
            if (childInfo.isSingleton()) continue;
            IWDNode childNode = node.getChildNode(childInfo.getName(), el.index());
            writer.write("<node name=\"");
            writer.write(childInfo.getName());
            writer.write("\">\n");
            this.saveNode(childNode, writer);
            writer.write("</node>\n");
        }
        Iterator attrItr = nodeInfo.iterateAttributes();
        while (attrItr.hasNext()) {
            IWDAttributeInfo attr = (IWDAttributeInfo)attrItr.next();
            writer.write("<attr ");
            writer.write("name=\"");
            writer.write(attr.getName());
            writer.write("\" ");
            Object value = el.getAttributeValue(attr.getName());
            writer.write("type=\"");
            writer.write(TypeUtils.getTypeOf(value));
            writer.write("\">");
            writer.write("<![CDATA[");
            writer.write(value != null ? value.toString() : "");
            writer.write("]]>");
            writer.write("</attr>\n");
        }
        writer.write("</element>\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

