/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.xml.context;

import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.caf.ui.utils.xml.context.ContextIOException;
import com.sap.caf.ui.utils.xml.context.TypeUtils;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ContextReader {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$xml$context$ContextReader == null ? (class$com$sap$caf$ui$utils$xml$context$ContextReader = ContextReader.class$("com.sap.caf.ui.utils.xml.context.ContextReader")) : class$com$sap$caf$ui$utils$xml$context$ContextReader));
    public static final int STN_SINK_EXCEPTION_RUNTIME = 1;
    public static final int SETTINGS_STANDARD = 0;
    public static final int SETTINGS_SINK_EXCEPTION_RUNTIME = 1;
    private IWDNode m_context;
    private int m_settings = 0;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$xml$context$ContextReader;

    public ContextReader(IWDNode context) {
        this.m_context = context;
        this.m_settings = 0;
    }

    public ContextReader(IWDNode context, int settings) {
        this.m_context = context;
        this.m_settings = settings;
    }

    public void setSettings(int settings) {
        this.m_settings = settings;
    }

    public int getSettings() {
        return this.m_settings;
    }

    public void read(String fileName) throws ContextIOException {
        String method = "read(String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "read(String)", logger);
        try {
            FileInputStream is = new FileInputStream(fileName);
            this.read(is);
        }
        catch (IOException e) {
            String errorMess = MessageFormat.format("Error reading context from xml(file name: {0})", fileName);
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "read(String)", errorMess, (Throwable)e);
            ContextIOException cxtIOException = new ContextIOException(errorMess, e);
            logger.throwing("read(String)", (Throwable)cxtIOException);
            throw cxtIOException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "read(String)", logger);
        }
    }

    public void read(InputStream is) throws ContextIOException {
        String method = "read(InputStream)";
        CAFUIPublicLogger.entering(null, jARMRequest, "read(InputStream)", logger);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(is);
            this.readNode(this.m_context, document.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            String errorMess = "Error reading context from xml";
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "read(InputStream)", errorMess, (Throwable)e);
            ContextIOException cxtIOException = new ContextIOException(errorMess, e);
            logger.throwing("read(InputStream)", (Throwable)cxtIOException);
            throw cxtIOException;
        }
        catch (SAXException e) {
            String errorMess = "Error reading context from xml";
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "read(InputStream)", errorMess, (Throwable)e);
            ContextIOException cxtIOException = new ContextIOException(errorMess, e);
            logger.throwing("read(InputStream)", (Throwable)cxtIOException);
            throw cxtIOException;
        }
        catch (IOException e) {
            String errorMess = "Error reading context from xml";
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "read(InputStream)", errorMess, (Throwable)e);
            ContextIOException cxtIOException = new ContextIOException(errorMess, e);
            logger.throwing("read(InputStream)", (Throwable)cxtIOException);
            throw cxtIOException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "read(InputStream)", logger);
        }
    }

    private void readNode(IWDNode node, Element domElement) {
        this.readElements(node, domElement);
        this.readChildren(node, domElement);
    }

    private void readElements(IWDNode node, Element domElement) {
        String method = "readElements(IWDNode, Element)";
        CAFUIPublicLogger.entering(null, jARMRequest, "readElements(IWDNode, Element)", logger);
        node.invalidate();
        if ((this.m_settings & 1) != 0) {
            try {
                Element elementsList = (Element)domElement.getElementsByTagName("elements").item(0);
                NodeList elements = elementsList.getElementsByTagName("element");
                for (int i = 0; i < elements.getLength(); ++i) {
                    Element el = (Element)elements.item(i);
                    IWDNodeElement nodeEl = node.createElement();
                    this.readSingleElement(node, nodeEl, el);
                    node.addElement(nodeEl);
                }
            }
            catch (Throwable e) {
                CAFUIPublicLogger.traceThrowableT(100, logger, "readElements(IWDNode, Element)", e.getMessage(), e);
            }
        } else {
            Element elementsList = (Element)domElement.getElementsByTagName("elements").item(0);
            NodeList elements = elementsList.getElementsByTagName("element");
            for (int i = 0; i < elements.getLength(); ++i) {
                Element el = (Element)elements.item(i);
                IWDNodeElement nodeEl = node.createElement();
                this.readSingleElement(node, nodeEl, el);
                node.addElement(nodeEl);
            }
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "readElements(IWDNode, Element)", logger);
    }

    private void readSingleElement(IWDNode node, IWDNodeElement el, Element domElement) {
        String type;
        Element attrEl;
        IWDNodeInfo nodeInfo = node.getNodeInfo();
        Iterator attrItr = nodeInfo.iterateAttributes();
        HashMap<String, Element> attrMap = new HashMap<String, Element>();
        NodeList attrs = domElement.getElementsByTagName("attr");
        for (int i = 0; i < attrs.getLength(); ++i) {
            attrEl = (Element)attrs.item(i);
            String name = attrEl.getAttribute("name");
            type = attrEl.getAttribute("type");
            attrMap.put(name, attrEl);
            type = "ddic:com.sap.dictionary." + type.toLowerCase();
            if (nodeInfo.getAttribute(name) != null) continue;
            nodeInfo.addAttribute(name, type);
        }
        while (attrItr.hasNext()) {
            String value;
            IWDAttributeInfo attr = (IWDAttributeInfo)attrItr.next();
            attrEl = (Element)attrMap.get(attr.getName());
            if ((this.m_settings & 1) != 0) {
                if (attrEl == null || !attr.hasSimpleType()) continue;
                value = attrEl.getFirstChild().getNodeValue();
                type = attrEl.getAttribute("type");
                if (value == null) continue;
                el.setAttributeValue(attr.getName(), TypeUtils.getTypedValue(value, type));
                continue;
            }
            value = attrEl.getFirstChild().getNodeValue();
            type = attrEl.getAttribute("type");
            if (value == null) continue;
            el.setAttributeValue(attr.getName(), TypeUtils.getTypedValue(value, type));
        }
    }

    private void readChildren(IWDNode node, Element domElement) {
        IWDNodeInfo nodeInfo = node.getNodeInfo();
        Element nodesList = (Element)domElement.getElementsByTagName("children").item(0);
        NodeList nodes = nodesList.getElementsByTagName("node");
        HashMap<String, Element> nodeMap = new HashMap<String, Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeEl = (Element)nodes.item(i);
            String name = nodeEl.getAttribute("name");
            nodeMap.put(name, nodeEl);
            IWDNode child = node.getChildNode(name, -1);
            if (child != null) continue;
            nodeInfo.addChild(name, null, true, false, true, false, false, true, null, null, null);
        }
        Iterator nodesItr = nodeInfo.iterateChildren();
        while (nodesItr.hasNext()) {
            IWDNodeInfo childNodeInfo = (IWDNodeInfo)nodesItr.next();
            Element nodeEl = (Element)nodeMap.get(childNodeInfo.getName());
            if (nodeEl == null) continue;
            this.readNode(node.getChildNode(childNodeInfo.getName(), -1), nodeEl);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

