/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.wd;

import com.sap.caf.rt.util.PrincipalUtils;
import com.sap.caf.ui.ptn.userassignment.def.IAssignmentItem;
import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.caf.ui.utils.wd.WDUtilsException;
import com.sap.dictionary.runtime.ISimpleTypeModifiable;
import com.sap.exception.BaseException;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDComponent;
import com.sap.tc.webdynpro.progmodel.api.IWDComponentUsage;
import com.sap.tc.webdynpro.progmodel.api.IWDMessage;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPartType;
import com.sap.tc.webdynpro.services.sal.url.api.WDURLException;
import com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator;
import com.sap.tc.webdynpro.services.task.TaskBinder;
import com.sap.typeservices.IModifiableSimpleValueSet;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class WDUtils {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$wd$WDUtils == null ? (class$com$sap$caf$ui$utils$wd$WDUtils = WDUtils.class$("com.sap.caf.ui.utils.wd.WDUtils")) : class$com$sap$caf$ui$utils$wd$WDUtils));
    private static final char START_TEMPLATE_CHAR = '<';
    private static final char END_TEMPLATE_CHAR = '>';
    private static final String ALL_TEMPLATE_DELIMETERS = "<>";
    private static final String URL_TAG = "url";
    public static final String EMPTY_STRING = "";
    static /* synthetic */ Class class$com$sap$caf$ui$utils$wd$WDUtils;

    public static String getCurrentApplicationURL(String configName, String parameter1) throws WDURLException {
        WDDeployableObjectPart part = TaskBinder.getCurrentTask().getApplicationDeployableObjecPart();
        return WDURLGenerator.getApplicationURL((WDDeployableObjectPart)part) + "?app.configName=" + configName + "&app.parameter1=" + parameter1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getApplicationURL(String appName, String devCompName, boolean asURL) throws WDUtilsException {
        String sURL;
        block9: {
            String method = "String getApplicationURL(String, String, boolean)";
            CAFUIPublicLogger.entering(null, jARMRequest, "String getApplicationURL(String, String, boolean)", logger);
            sURL = null;
            try {
                if (devCompName == null || devCompName.length() <= 0) {
                    devCompName = TaskBinder.getCurrentTask().getDeployableObject().getName();
                }
                WDDeployableObjectPart part = WDDeployableObject.getDeployableObjectPart((String)devCompName, (String)appName, (WDDeployableObjectPartType)WDDeployableObjectPartType.APPLICATION);
                sURL = WDURLGenerator.getApplicationURL((WDDeployableObjectPart)part);
            }
            catch (Throwable e) {
                CAFUIPublicLogger.traceThrowableT(100, logger, "String getApplicationURL(String, String, boolean)", e.getMessage(), e);
                if (asURL) {
                    try {
                        URL url = new URL(appName);
                        sURL = appName;
                        break block9;
                    }
                    catch (Throwable e2) {
                        String errorMess = "The '" + appName + "' name is neither WebDynpro application name nor valid URL.";
                        CAFUIPublicLogger.traceThrowableT(100, logger, "String getApplicationURL(String, String, boolean)", errorMess, e);
                        WDUtilsException wdUtilException = new WDUtilsException(errorMess, e2);
                        CAFUIPublicLogger.exiting(null, jARMRequest, "String getApplicationURL(String, String, boolean)", logger);
                        logger.throwing("String getApplicationURL(String, String, boolean)", (Throwable)wdUtilException);
                        throw wdUtilException;
                    }
                }
                String errorMess = "Could not get URL for application with name '" + appName + "' in development component '" + devCompName + "'.";
                CAFUIPublicLogger.traceThrowableT(100, logger, "String getApplicationURL(String, String, boolean)", errorMess, e);
                WDUtilsException wdUtilException = new WDUtilsException(errorMess, e);
                logger.throwing("String getApplicationURL(String, String, boolean)", (Throwable)wdUtilException);
                throw wdUtilException;
            }
            finally {
                CAFUIPublicLogger.exiting(null, jARMRequest, "String getApplicationURL(String, String, boolean)", logger);
            }
        }
        return sURL;
    }

    public static void createComponent(IWDComponentUsage compUsage, String compName, String devCompName, boolean delExisting) throws WDUtilsException {
        String method = "createComponent(IWDComponentUsage, String, String, boolean)";
        CAFUIPublicLogger.entering(null, jARMRequest, "createComponent(IWDComponentUsage, String, String, boolean)", logger);
        try {
            if (compUsage.hasActiveComponent()) {
                if (!delExisting) {
                    return;
                }
                compUsage.deleteComponent();
            }
            if (devCompName != null && devCompName.length() > 0) {
                compUsage.createComponent(compName, devCompName);
            } else {
                compUsage.createComponent(compName);
            }
        }
        catch (Exception e) {
            String errorMess = "Could not create WD component with name '" + compName + "' in development component '" + devCompName + "'.";
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "createComponent(IWDComponentUsage, String, String, boolean)", errorMess, (Throwable)e);
            if (devCompName == null || devCompName.length() <= 0) {
                devCompName = TaskBinder.getCurrentTask().getDeployableObject().getName();
            }
            WDUtilsException wdUtilException = new WDUtilsException(errorMess, e);
            logger.throwing("createComponent(IWDComponentUsage, String, String, boolean)", (Throwable)wdUtilException);
            throw wdUtilException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "createComponent(IWDComponentUsage, String, String, boolean)", logger);
        }
    }

    public static String getEMailURL(String usersString, String subject, String body, String url, IWDNodeElement element) {
        String method = "String getEMailURL(String, String, String, String, IWDNodeElement)";
        CAFUIPublicLogger.entering(null, jARMRequest, "String getEMailURL(String, String, String, String, IWDNodeElement)", logger);
        StringBuffer result = new StringBuffer(256);
        result.append("mailto: ");
        if (usersString != null && usersString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(usersString, ";", false);
            while (tokenizer.hasMoreTokens()) {
                String eMail;
                IUser sapUser = null;
                try {
                    sapUser = UMFactory.getUserFactory().getUser(tokenizer.nextToken());
                }
                catch (UMException e) {
                    CAFUIPublicLogger.traceThrowableT(100, logger, "String getEMailURL(String, String, String, String, IWDNodeElement)", "Failed to get SAP user", e);
                }
                if (sapUser == null || (eMail = sapUser.getEmail()) == null) continue;
                result.append(sapUser.getDisplayName());
                result.append('<').append(eMail).append(">;");
            }
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "String getEMailURL(String, String, String, String, IWDNodeElement)", logger);
        return WDUtils.getEmailURL(subject, body, url, element, result);
    }

    public static String getEmailURL(String subject, String body, String url, IWDNodeElement element, StringBuffer result) {
        String method = "String getEMailURL(String, String, String, String, IWDNodeElement, StringBuffer)";
        boolean isInitialized = WDUtils.parseEMailTemplate(subject, result, url, "?subject=", element);
        String bodyParameter = isInitialized ? "&body=" : "?body";
        WDUtils.parseEMailTemplate(body, result, url, bodyParameter, element);
        int idx = result.indexOf("+");
        while (idx >= 0) {
            result.replace(idx, idx + 1, "%20");
            idx = result.indexOf("+");
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "String getEMailURL(String, String, String, String, IWDNodeElement, StringBuffer)", logger);
        return result.toString();
    }

    private static boolean parseEMailTemplate(String template, StringBuffer result, String url, String parameterName, IWDNodeElement element) {
        String method = "boolean parseEMailTemplate(String, StringBuffer, String, String, IWDNodeElement)";
        CAFUIPublicLogger.entering(null, jARMRequest, "boolean parseEMailTemplate(String, StringBuffer, String, String, IWDNodeElement)", logger);
        if (template == null || template.length() < 1) {
            return false;
        }
        result.append(parameterName);
        StringTokenizer templateTokenizer = new StringTokenizer(template, ALL_TEMPLATE_DELIMETERS, true);
        boolean tagFound = false;
        block8: while (templateTokenizer.hasMoreTokens()) {
            String token = templateTokenizer.nextToken();
            switch (token.charAt(0)) {
                case '<': {
                    tagFound = true;
                    continue block8;
                }
                case '>': {
                    tagFound = false;
                    continue block8;
                }
            }
            if (tagFound) {
                if (URL_TAG.equalsIgnoreCase(token)) {
                    token = url;
                } else {
                    String value = null;
                    try {
                        value = element.getAttributeAsText(token);
                    }
                    catch (Exception e) {
                        CAFUIPublicLogger.traceThrowableT(100, logger, "boolean parseEMailTemplate(String, StringBuffer, String, String, IWDNodeElement)", e.getMessage(), e);
                    }
                    token = value == null ? token : value;
                }
            }
            try {
                result.append(URLEncoder.encode(token, "UTF-8"));
            }
            catch (Exception e) {
                CAFUIPublicLogger.traceThrowableT(100, logger, "boolean parseEMailTemplate(String, StringBuffer, String, String, IWDNodeElement)", e.getMessage(), e);
            }
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "boolean parseEMailTemplate(String, StringBuffer, String, String, IWDNodeElement)", logger);
        return true;
    }

    public static String joinPrincipals(IAssignmentItem[] principalIDs) {
        int len = principalIDs.length;
        if (len == 0) {
            return EMPTY_STRING;
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (principalIDs[i].getState() != 2) continue;
            if (str.length() > 0) {
                str.append(';');
            }
            str.append(principalIDs[i].getUniqueID());
        }
        return str.toString();
    }

    public static List parsePrincipalIDs(String principalIDs) {
        return PrincipalUtils.parsePrincipalIDs((String)principalIDs);
    }

    public static void fillModifiableContextType(IWDAttributeInfo attrInfo, Collection keys, boolean sort) throws WDUtilsException {
        if (keys == null) {
            throw new WDUtilsException("One or more passed parameters are null", new IllegalArgumentException());
        }
        if (keys instanceof List) {
            WDUtils.fillModifiableContextType(attrInfo, (List)keys, (List)keys, sort);
        } else {
            ArrayList keyList = new ArrayList(keys);
            WDUtils.fillModifiableContextType(attrInfo, keyList, keyList, sort);
        }
    }

    public static void fillModifiableContextType(IWDAttributeInfo attrInfo, List keys, boolean sort) throws WDUtilsException {
        WDUtils.fillModifiableContextType(attrInfo, keys, keys, sort);
    }

    public static void fillModifiableContextType(IWDAttributeInfo attrInfo, List keys, List values, boolean sort) throws WDUtilsException {
        block8: {
            if (attrInfo == null || values == null || keys == null || values == null) {
                throw new WDUtilsException("One or more passed parameters are null", new IllegalArgumentException());
            }
            try {
                IModifiableSimpleValueSet valueSet;
                ISimpleTypeModifiable attrType = attrInfo.getModifiableSimpleType();
                if (attrType == null || !attrType.hasSVService() || (valueSet = attrType.getSVServices().getModifiableSimpleValueSet()) == null) break block8;
                valueSet.clear();
                if (keys != values) {
                    Iterator iK = keys.iterator();
                    Iterator iV = values.iterator();
                    while (iK.hasNext() && iV.hasNext()) {
                        valueSet.put((Object)((String)iK.next()), (String)iV.next());
                    }
                } else {
                    Iterator iK = keys.iterator();
                    while (iK.hasNext()) {
                        String key = (String)iK.next();
                        valueSet.put((Object)key, key);
                    }
                }
                if (sort) {
                    valueSet.sort(new Comparator(){

                        public int compare(Object o1, Object o2) {
                            String value1 = (String)((Map.Entry)o1).getValue();
                            String value2 = (String)((Map.Entry)o2).getValue();
                            if (value1 != null) {
                                return value1.compareTo(value2);
                            }
                            return value1 != value2 ? 1 : 0;
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new WDUtilsException(EMPTY_STRING, e);
            }
        }
    }

    public static void reportException(Exception e, IWDMessage wdMessage, IWDComponent comp) {
        Location logger = Location.getLocation(comp.getClass());
        WDUtils.reportException(e, wdMessage, comp, logger);
    }

    public static void reportException(Exception e, IWDMessage wdMessage, IWDComponent comp, Location logger) {
        try {
            IWDMessageManager messageMgr = comp.getMessageManager();
            if (e instanceof BaseException) {
                BaseException baseE = (BaseException)e;
                String text = baseE.getLocalizedMessage();
                if (text == null || text.length() <= 0) {
                    text = baseE.getMessage();
                }
                if (text != null && text.length() > 0) {
                    messageMgr.reportException(text, false);
                }
            }
            if (wdMessage != null) {
                messageMgr.reportMessage(wdMessage, null, false);
            }
            logger.catching((Throwable)e);
        }
        catch (Exception e2) {
            logger.catching((Throwable)e2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

