/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.wd;

import com.sap.tc.webdynpro.progmodel.api.IWDComponentUsage;
import com.sap.tc.webdynpro.progmodel.api.IWDController;
import com.sap.tc.webdynpro.progmodel.api.IWDExternalControllerInterface;
import com.sap.tc.webdynpro.progmodel.controller.Controller;
import com.sap.tc.webdynpro.progmodel.generation.DelegatingCustomController;
import com.sap.tc.webdynpro.progmodel.generation.DelegatingView;
import com.sap.tc.webdynpro.progmodel.repository.IWDAbstractViewInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDComponentInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDInterfaceViewInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDOutboundPlugInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDViewContainerAssignmentInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDViewContainerInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDViewInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDViewUsageInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDWindowInfo;
import java.util.HashMap;
import java.util.Iterator;

public class UsageHelper {
    private IWDComponentUsage m_mainUsage;
    private String m_componentName;
    private String m_devComponentName;
    private String m_embeddedInterfaceViewName;
    private String m_embeddedInterfaceName;
    private HashMap m_usages;
    private HashMap m_containerNames;

    public UsageHelper(IWDComponentUsage mainUsage, String compName, String devCompName, String embeddedInterfaceViewName, String embeddedInterfaceName) {
        this.m_mainUsage = mainUsage;
        this.m_componentName = compName;
        this.m_devComponentName = devCompName;
        this.m_embeddedInterfaceViewName = embeddedInterfaceViewName;
        this.m_embeddedInterfaceName = embeddedInterfaceName;
        this.m_usages = new HashMap();
        this.m_containerNames = new HashMap();
    }

    public String createEmbeddedComponent(String id, IWDController controller, String windowName, String viewName) {
        return this.createEmbeddedComponent(id, controller, windowName, viewName, null);
    }

    public String createEmbeddedComponent(String id, IWDController controller, String windowName, String viewName, String usageName) {
        return this.createEmbeddedComponent(id, controller, windowName, viewName, usageName, this.m_devComponentName, this.m_componentName);
    }

    public String createEmbeddedComponent(String id, IWDController controller, String windowName, String viewName, String usageName, String devComponentName, String componentName) {
        IWDComponentUsage currentUsage = this.m_mainUsage.createComponentUsageOfSameType(id);
        IWDComponentInfo componentInfo = controller.getComponent().getComponentInfo();
        IWDViewInfo viewInfo = componentInfo.findInViews(viewName);
        IWDWindowInfo windowInfo = componentInfo.findInWindows(windowName);
        if (windowInfo == null) {
            throw new IllegalArgumentException(windowName);
        }
        IWDViewUsageInfo usageInfo = null;
        usageInfo = usageName != null ? windowInfo.findInRootViewUsages(usageName) : windowInfo.getDefaultRootViewUsage();
        IWDInterfaceViewInfo embeddedViewInfo = currentUsage.getComponentUsageInfo().getUsedComponent().findInInterfaceViews(this.m_embeddedInterfaceViewName);
        if (embeddedViewInfo == null) {
            throw new IllegalArgumentException(this.m_embeddedInterfaceViewName);
        }
        IWDViewContainerAssignmentInfo containerAssignment = usageInfo.createViewContainerAssignment();
        IWDViewContainerInfo viewContainerInfo = viewInfo.createViewContainer();
        containerAssignment.setViewContainer(viewContainerInfo);
        IWDViewUsageInfo embeddedViewUsage = containerAssignment.createEmbeddedViewUsage();
        embeddedViewUsage.setComponentUsage(currentUsage.getComponentUsageInfo());
        embeddedViewUsage.setView((IWDAbstractViewInfo)embeddedViewInfo);
        IWDOutboundPlugInfo outPlug = viewInfo.createOutboundPlug();
        usageInfo.createNavigationTarget(outPlug.getName(), embeddedViewUsage, "Default");
        containerAssignment.setDefaultViewUsage(embeddedViewUsage);
        currentUsage.createComponent(componentName, devComponentName);
        String containerName = viewContainerInfo.getName();
        this.m_usages.put(id, currentUsage);
        this.m_containerNames.put(id, containerName);
        return containerName;
    }

    public void subscribeUsagesToEvent(IWDController controller, String handlerName, String eventName) {
        Iterator iter = this.m_usages.keySet().iterator();
        while (iter.hasNext()) {
            String usageID = (String)iter.next();
            this.subscribeUsageToEvent(usageID, controller, handlerName, eventName);
        }
    }

    public void subscribeUsageToEvent(String usageID, IWDController controller, String handlerName, String eventName) {
        if (controller instanceof DelegatingCustomController) {
            DelegatingCustomController wdAlterEgo = (DelegatingCustomController)controller;
            wdAlterEgo.getComponentInternal().subscribeToEvent((Controller)wdAlterEgo, handlerName, usageID, this.m_embeddedInterfaceName, eventName);
        } else if (controller instanceof DelegatingView) {
            DelegatingView wdAlterEgo = (DelegatingView)controller;
            wdAlterEgo.getComponentInternal().subscribeToEvent((Controller)wdAlterEgo, handlerName, usageID, this.m_embeddedInterfaceName, eventName);
        }
    }

    public Iterator getUsagesIterator() {
        return this.m_usages.values().iterator();
    }

    public IWDComponentUsage getUsageByID(String id) {
        if (id == null) {
            throw new IllegalArgumentException(id);
        }
        IWDComponentUsage currentUsage = (IWDComponentUsage)this.m_usages.get(id);
        if (currentUsage == null) {
            throw new IllegalArgumentException(id);
        }
        return currentUsage;
    }

    public IWDExternalControllerInterface getInterfaceControlerByUsageID(String id) {
        return this.getUsageByID(id).getInterfaceController();
    }

    public String getContainerNameByUsageID(String id) {
        if (id == null) {
            throw new IllegalArgumentException(id);
        }
        String currentContainerName = (String)this.m_containerNames.get(id);
        if (currentContainerName == null) {
            throw new IllegalArgumentException(id);
        }
        return currentContainerName;
    }
}

