/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.wd;

import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.caf.ui.utils.wd.ResourceUtilsException;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.services.sal.config.api.IWDConfiguration;
import com.sap.tc.webdynpro.services.sal.config.api.WDConfiguration;
import com.sap.tc.webdynpro.services.sal.config.api.WDConfigurationNotFoundException;
import com.sap.tc.webdynpro.services.sal.config.api.WDInvalidConfigParameterException;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;

public class ResourceUtils {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$wd$ResourceUtils == null ? (class$com$sap$caf$ui$utils$wd$ResourceUtils = ResourceUtils.class$("com.sap.caf.ui.utils.wd.ResourceUtils")) : class$com$sap$caf$ui$utils$wd$ResourceUtils));
    static /* synthetic */ Class class$com$sap$caf$ui$utils$wd$ResourceUtils;

    public static String getProperty(String propertyName, String deployableObjectName) throws ResourceUtilsException {
        String method = "String getProperty(String, String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "String getProperty(String, String)", logger);
        String result = null;
        try {
            IWDConfiguration config = WDConfiguration.getConfiguration((String)deployableObjectName);
            result = config.getStringEntry(propertyName);
        }
        catch (WDInvalidConfigParameterException e) {
            String errorMess = "Invalid property name specified: \"" + propertyName + "\"";
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "String getProperty(String, String)", errorMess, (Throwable)e);
            ResourceUtilsException resUtilException = new ResourceUtilsException(errorMess);
            logger.throwing("String getProperty(String, String)", (Throwable)resUtilException);
            throw resUtilException;
        }
        catch (WDConfigurationNotFoundException e) {
            String errorMess = "Configuration not found for specified deployable object name: \"" + deployableObjectName + "\"";
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "String getProperty(String, String)", errorMess, (Throwable)e);
            ResourceUtilsException resUtilException = new ResourceUtilsException(errorMess);
            logger.throwing("String getProperty(String, String)", (Throwable)resUtilException);
            throw resUtilException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "String getProperty(String, String)", logger);
        }
        return result;
    }

    public static String getProperty(String propertyName, IWDDeployableObject deployableObject) throws ResourceUtilsException {
        String method = "String getProperty(String, IWDDeployableObject)";
        CAFUIPublicLogger.entering(null, jARMRequest, "String getProperty(String, IWDDeployableObject)", logger);
        String result = null;
        try {
            IWDConfiguration config = WDConfiguration.getConfiguration((IWDDeployableObject)deployableObject);
            result = config.getStringEntry(propertyName);
        }
        catch (WDInvalidConfigParameterException e) {
            String errorMess = "Invalid property name specified: \"" + propertyName + "\"";
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "String getProperty(String, IWDDeployableObject)", errorMess, (Throwable)e);
            ResourceUtilsException resUtilException = new ResourceUtilsException(errorMess);
            logger.throwing("String getProperty(String, IWDDeployableObject)", (Throwable)resUtilException);
            throw resUtilException;
        }
        catch (WDConfigurationNotFoundException e) {
            String errorMess = "Configuration not found for specified deployable object named: \"" + deployableObject.getName() + "\"";
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "String getProperty(String, IWDDeployableObject)", errorMess, (Throwable)e);
            ResourceUtilsException resUtilException = new ResourceUtilsException(errorMess);
            logger.throwing("String getProperty(String, IWDDeployableObject)", (Throwable)resUtilException);
            throw resUtilException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "String getProperty(String, IWDDeployableObject)", logger);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

