/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.wd;

import com.sap.engine.interfaces.ejb.monitor.EJBManager;
import com.sap.engine.services.classload.RemoteLoadContext;
import com.sap.engine.services.deploy.ApplicationInformation;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.ejb.deploy.EJBLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class DeployUtils {
    private static final String EJB_CONTAINER = "EJBContainer";

    public static String getUsableDeployableObjectName(String originalDeployableObjectName) {
        return "local/" + originalDeployableObjectName;
    }

    public static Map getDependentDcFiles(String parentDc) throws Exception {
        parentDc = DeployUtils.normalizeDcName(parentDc);
        InitialContext ctx = new InitialContext();
        RemoteLoadContext rlc = DeployUtils.getRemoteLoad(ctx);
        DeployService depl = DeployUtils.getDeployService(ctx);
        String[] apps = depl.listApplications(EJB_CONTAINER, null);
        HashMap<String, String[]> result = new HashMap<String, String[]>(apps.length);
        for (int i = 0; i < apps.length; ++i) {
            ApplicationInformation appInfo = depl.getApplicationInformation(apps[i]);
            if (appInfo.getLoaderName().indexOf(parentDc) != -1) {
                result.put(appInfo.getLoaderName(), DeployUtils.getDeployedFiles(appInfo));
                continue;
            }
            String[] refs = rlc.getReferences(appInfo.getLoaderName());
            for (int j = 0; j < refs.length; ++j) {
                if (refs[j].indexOf(parentDc) == -1) continue;
                String[] ejbList = depl.listElements(EJB_CONTAINER, appInfo.getLoaderName(), null);
                result.put(appInfo.getLoaderName(), DeployUtils.getDeployedFiles(appInfo));
            }
        }
        return result;
    }

    public static String[] getEjbJarsUnderDc(String[] jars, String parentDc) throws Exception {
        InitialContext ctx = new InitialContext();
        String[] ejbList = DeployUtils.getDeployService(ctx).listElements(EJB_CONTAINER, parentDc, null);
        EJBManager em = DeployUtils.getEJBManager(ctx);
        ArrayList<String> result = new ArrayList<String>(jars.length);
        for (int i = 0; i < jars.length; ++i) {
            String jndiName = null;
            for (int j = 0; j < ejbList.length && (jndiName = em.getJNDINameLocal(parentDc, jars[i], ejbList[j].substring(0, ejbList[j].length() - 6))) == null; ++j) {
            }
            if (jndiName == null) continue;
            Object obj = ctx.lookup(jndiName);
            ClassLoader classLoader = obj.getClass().getClassLoader();
            String[] resNames = ((EJBLoader)classLoader).getResourceNames();
            String path = resNames[0].substring(0, resNames[0].indexOf(EJB_CONTAINER)) + EJB_CONTAINER + "\\applicationjars\\";
            result.add(path + jars[i]);
        }
        String[] resultArray = new String[result.size()];
        return result.toArray(resultArray);
    }

    private static String normalizeDcName(String dcName) {
        if (dcName == null || dcName.length() == 0) {
            throw new IllegalArgumentException("Invalid value for parentDc argument");
        }
        int index = dcName.indexOf(47);
        return index >= 0 ? dcName.substring(index + 1) : dcName;
    }

    private static String[] getDeployedFiles(ApplicationInformation appInfo) {
        Hashtable files = appInfo.getDeployedFileNames();
        String[] fs = (String[])files.get(EJB_CONTAINER);
        return fs != null ? fs : new String[]{};
    }

    private static RemoteLoadContext getRemoteLoad(Context ctx) throws NamingException {
        return (RemoteLoadContext)ctx.lookup("classload");
    }

    private static DeployService getDeployService(Context ctx) throws NamingException {
        return (DeployService)ctx.lookup("deploy");
    }

    private static EJBManager getEJBManager(Context ctx) throws NamingException {
        return (EJBManager)ctx.lookup("interfaces/ejbmonitor");
    }
}

