/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.validation;

import com.sap.caf.ui.utils.validation.IValidationItem;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDMessage;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
import java.util.HashSet;

public class ValidationEngine {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$validation$ValidationEngine == null ? (class$com$sap$caf$ui$utils$validation$ValidationEngine = ValidationEngine.class$("com.sap.caf.ui.utils.validation.ValidationEngine")) : class$com$sap$caf$ui$utils$validation$ValidationEngine));
    private IWDMessageManager messageManager;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$validation$ValidationEngine;

    ValidationEngine(IWDMessageManager msgMngr) {
        this.messageManager = msgMngr;
    }

    public static ValidationEngine getEngine(IWDMessageManager msgMngr) {
        if (msgMngr == null) {
            throw new IllegalArgumentException("message maganer is null");
        }
        return new ValidationEngine(msgMngr);
    }

    public boolean succeed(IWDNode node, IValidationItem[] items) {
        int result = this.validate(node, items);
        return result == 0 || result == 2;
    }

    public int validate(IWDNode node, IValidationItem[] items) {
        String method = "validate()";
        logger.entering(method);
        IWDNodeInfo nodeInfo = node.getNodeInfo();
        IWDNodeElement element = node.getCurrentElement();
        int result = 0;
        Object value = null;
        IWDMessage message = null;
        HashSet<String> attributesWarned = new HashSet<String>(items.length);
        for (int i = 0; i < items.length; ++i) {
            int error;
            String attributeName = items[i].getAttributeName();
            value = element.getAttributeValue(attributeName);
            logger.infoT("check attribute {0} with value {1}", new Object[]{attributeName, value});
            if (value == null || value.toString().length() == 0) {
                if (!attributeName.equals("freetext")) {
                    message = items[i].getMessage(true);
                    logger.pathT("empty");
                    if (message != null && !attributesWarned.contains(attributeName)) {
                        attributesWarned.add(attributeName);
                        this.messageManager.reportContextAttributeMessage(element, nodeInfo.getAttribute(attributeName), message, items[i].getMessageObjects(true), true);
                    }
                    error = 3;
                } else {
                    error = 0;
                }
            } else if (result < 5) {
                error = items[i].validate(element, value);
                if (error != 0 && error != 1 && (message = items[i].getMessage(false)) != null) {
                    this.messageManager.reportContextAttributeMessage(element, nodeInfo.getAttribute(attributeName), message, items[i].getMessageObjects(false), false);
                }
            } else {
                error = 1;
            }
            logger.infoT("result:{0}", new Object[]{new Integer(error)});
            items[i].setResult(error);
            if (error == 3 && !items[i].isRequired()) {
                error = 0;
            }
            if (result >= error) continue;
            result = error;
        }
        logger.exiting((Object)new Integer(result));
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

