/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.repository.model;

import com.sap.caf.ui.utils.repository.ReposUtils;
import com.sap.caf.ui.utils.repository.model.ModelIOException;
import com.sap.caf.ui.utils.repository.model.TypeUtils;
import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelClassPropertyInfo;
import com.sap.tc.cmi.metadata.ICMIRelationRoleInfo;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.repository.api.IWDRepository;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModel;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClass;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClassInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class ModelWriter {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$repository$model$ModelWriter == null ? (class$com$sap$caf$ui$utils$repository$model$ModelWriter = ModelWriter.class$("com.sap.caf.ui.utils.repository.model.ModelWriter")) : class$com$sap$caf$ui$utils$repository$model$ModelWriter));
    private IWDRepositoryModel m_model;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$repository$model$ModelWriter;

    public void save(String symbolicName, String fullFileName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject) throws ModelIOException {
        String method = "save(String, String, String, Class, IWDDeployableObject)";
        CAFUIPublicLogger.entering(null, jARMRequest, "save(String, String, String, Class, IWDDeployableObject)", logger);
        try {
            FileOutputStream os = new FileOutputStream(fullFileName);
            this.save(symbolicName, fullModelClassName, modelClass, depObject, os);
        }
        catch (IOException e) {
            String errorMess = "Error saving model to xml";
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "save(String, String, String, Class, IWDDeployableObject)", errorMess, (Throwable)e);
            ModelIOException modelExcep = new ModelIOException(errorMess, e);
            logger.throwing("save(String, String, String, Class, IWDDeployableObject)", (Throwable)modelExcep);
            throw modelExcep;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "save(String, String, String, Class, IWDDeployableObject)", logger);
        }
    }

    public void save(String symbolicName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject, OutputStream os) throws ModelIOException {
        String method = "save(String, String, Class, IWDDeployableObject, OutputStream)";
        CAFUIPublicLogger.entering(null, jARMRequest, "save(String, String, Class, IWDDeployableObject, OutputStream)", logger);
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<context>\n");
            this.saveModel(symbolicName, fullModelClassName, modelClass, depObject, writer);
            writer.write("</context>\n");
            writer.flush();
        }
        catch (IOException e) {
            String errorMess = "Error saving model to xml";
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "save(String, String, Class, IWDDeployableObject, OutputStream)", errorMess, (Throwable)e);
            ModelIOException modelExcep = new ModelIOException(errorMess, e);
            logger.throwing("save(String, String, Class, IWDDeployableObject, OutputStream)", (Throwable)modelExcep);
            throw modelExcep;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "save(String, String, Class, IWDDeployableObject, OutputStream)", logger);
        }
    }

    public void saveModel(String symbolicName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject, PrintWriter writer) throws ModelIOException {
        IWDRepositoryModelClassInfo floorplanClassInfo;
        IWDRepositoryModelClass floorplan = null;
        IWDRepository repository = ReposUtils.getRepository(depObject);
        IWDRepositoryModel model = repository.getRepositoryModel(modelClass);
        floorplan = model.getModelObject(symbolicName, floorplanClassInfo = (IWDRepositoryModelClassInfo)model.associatedModelInfo().getModelClassInfo(fullModelClassName));
        if (floorplan == null) {
            throw new ModelIOException("Responding root model class object not found");
        }
        this.saveNode(floorplan, null, writer, true);
    }

    private void saveNode(IWDRepositoryModelClass parentModelClassObj, ICMIRelationRoleInfo roleInfo, PrintWriter writer, boolean isRootNode) {
        Vector<IWDRepositoryModelClass> modelClassObjects = null;
        if (isRootNode) {
            Vector<IWDRepositoryModelClass> v = new Vector<IWDRepositoryModelClass>();
            v.addElement(parentModelClassObj);
            modelClassObjects = v;
        } else {
            String name = roleInfo.getOtherRoleInfo().getName();
            modelClassObjects = parentModelClassObj.getRelatedModelObjects(name);
        }
        this.saveElements(modelClassObjects, writer);
        this.saveChildren(modelClassObjects, writer);
    }

    private void saveChildren(Collection modelClassObjects, PrintWriter writer) {
        writer.write("<children>\n");
        Iterator itModelClassObjects = modelClassObjects.iterator();
        IWDRepositoryModelClass modelClassObj = null;
        while (itModelClassObjects.hasNext()) {
            modelClassObj = (IWDRepositoryModelClass)itModelClassObjects.next();
        }
        if (modelClassObj != null) {
            Iterator itRoleInfos = modelClassObj.associatedModelClassInfo().iterateSourceRoleInfos();
            while (itRoleInfos.hasNext()) {
                ICMIRelationRoleInfo roleInfo = (ICMIRelationRoleInfo)itRoleInfos.next();
                String name = roleInfo.getOtherRoleInfo().getName();
                writer.write("<node name=\"");
                writer.write(name);
                writer.write("\">\n");
                this.saveNode(modelClassObj, roleInfo, writer, false);
                writer.write("</node>\n");
            }
        }
        writer.write("</children>\n");
    }

    private void saveElements(Collection modelClassObjects, PrintWriter writer) {
        writer.write("<elements ");
        writer.write("select=\"");
        writer.write("\">\n");
        Iterator itModelClassObjects = modelClassObjects.iterator();
        while (itModelClassObjects.hasNext()) {
            IWDRepositoryModelClass modelClassObj = (IWDRepositoryModelClass)itModelClassObjects.next();
            this.saveElementAttributes(modelClassObj, writer);
        }
        writer.write("</elements>\n");
    }

    private void saveElementAttributes(IWDRepositoryModelClass modelClassObj, PrintWriter writer) {
        writer.write("<element>\n");
        Iterator itPropInfos = modelClassObj.associatedModelClassInfo().getPropertyInfos().iterator();
        while (itPropInfos.hasNext()) {
            ICMIModelClassPropertyInfo propInfo = (ICMIModelClassPropertyInfo)itPropInfos.next();
            String name = propInfo.getName();
            writer.write("<attr ");
            writer.write("name=\"");
            writer.write(name);
            writer.write("\" ");
            Object value = modelClassObj.getAttributeValue(name);
            if (value != null && value instanceof String) {
                value = URLDecoder.decode((String)value);
            }
            writer.write("type=\"");
            writer.write(TypeUtils.getTypeOf(value));
            writer.write("\">");
            writer.write("<![CDATA[");
            writer.write(value != null ? value.toString() : "");
            writer.write("]]>");
            writer.write("</attr>\n");
        }
        writer.write("</element>\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

