/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.repository.model;

import com.sap.caf.ui.utils.repository.ReposUtils;
import com.sap.caf.ui.utils.repository.context.ContextReader;
import com.sap.caf.ui.utils.repository.model.ModelIOException;
import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelClassPropertyInfo;
import com.sap.tc.cmi.metadata.ICMIRelationRoleInfo;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.repository.api.IWDRepository;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModel;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClass;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClassInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModelReader {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$repository$model$ModelReader == null ? (class$com$sap$caf$ui$utils$repository$model$ModelReader = ModelReader.class$("com.sap.caf.ui.utils.repository.model.ModelReader")) : class$com$sap$caf$ui$utils$repository$model$ModelReader));
    public static final int STN_SINK_EXCEPTION_RUNTIME = 1;
    public static final int SETTINGS_STANDARD = 0;
    public static final int SETTINGS_SINK_EXCEPTION_RUNTIME = 1;
    private IWDRepositoryModel m_model;
    private int m_settings = 0;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$repository$model$ModelReader;

    public ModelReader() {
        this.m_settings = 0;
    }

    public ModelReader(int settings) {
        this.m_settings = settings;
    }

    public void setSettings(int settings) {
        this.m_settings = settings;
    }

    public int getSettings() {
        return this.m_settings;
    }

    public void read(String symbolicName, String fullFileName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject) throws ModelIOException {
        String method = "read(String, String, String, Class, IWDDeployableObject)";
        CAFUIPublicLogger.entering(null, jARMRequest, "read(String, String, String, Class, IWDDeployableObject)", logger);
        try {
            FileInputStream is = new FileInputStream(fullFileName);
            this.read(symbolicName, fullModelClassName, modelClass, depObject, is);
        }
        catch (IOException e) {
            String errorMess = MessageFormat.format("Error reading model from xml: {0}", e.getMessage());
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "read(String, String, String, Class, IWDDeployableObject)", errorMess, (Throwable)e);
            ModelIOException modelExcep = new ModelIOException(errorMess, e);
            logger.throwing("read(String, String, String, Class, IWDDeployableObject)", (Throwable)modelExcep);
            throw modelExcep;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "read(String, String, String, Class, IWDDeployableObject)", logger);
        }
    }

    public void read(String symbolicName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject, InputStream is) throws ModelIOException {
        String method = "read(String, String, Class, IWDDeployableObject, InputStream)";
        CAFUIPublicLogger.entering(null, jARMRequest, "read(String, String, Class, IWDDeployableObject, InputStream)", logger);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(is);
            this.readModel(symbolicName, fullModelClassName, modelClass, depObject, document.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            String errorMess = MessageFormat.format("Error reading model from xml: {0}", e.getMessage());
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "read(String, String, Class, IWDDeployableObject, InputStream)", errorMess, (Throwable)e);
            ModelIOException modelExcep = new ModelIOException(errorMess, e);
            logger.throwing("read(String, String, Class, IWDDeployableObject, InputStream)", (Throwable)modelExcep);
            throw modelExcep;
        }
        catch (SAXException e) {
            String errorMess = MessageFormat.format("Error reading model from xml: {0}", e.getMessage());
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "read(String, String, Class, IWDDeployableObject, InputStream)", errorMess, (Throwable)e);
            ModelIOException modelExcep = new ModelIOException(errorMess, e);
            logger.throwing("read(String, String, Class, IWDDeployableObject, InputStream)", (Throwable)modelExcep);
            throw modelExcep;
        }
        catch (IOException e) {
            String errorMess = MessageFormat.format("Error reading model from xml: {0}", e.getMessage());
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "read(String, String, Class, IWDDeployableObject, InputStream)", errorMess, (Throwable)e);
            ModelIOException modelExcep = new ModelIOException(errorMess, e);
            logger.throwing("read(String, String, Class, IWDDeployableObject, InputStream)", (Throwable)modelExcep);
            throw modelExcep;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "read(String, String, Class, IWDDeployableObject, InputStream)", logger);
        }
    }

    public void readModel(String symbolicName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject, Element domElement) throws ModelIOException {
        String method = "readModel(String, String, Class , IWDDeployableObject, Element)";
        CAFUIPublicLogger.entering(null, jARMRequest, "readModel(String, String, Class , IWDDeployableObject, Element)", logger);
        IWDRepository repository = ReposUtils.getRepository(depObject);
        this.m_model = repository.getRepositoryModel(modelClass);
        IWDRepositoryModelClassInfo floorplanClassInfo = (IWDRepositoryModelClassInfo)this.m_model.associatedModelInfo().getModelClassInfo(fullModelClassName);
        String sKey = fullModelClassName + symbolicName;
        ContextReader.removeModelFromCache(sKey);
        IWDRepositoryModelClass floorplan = this.m_model.getModelObject(symbolicName, floorplanClassInfo);
        if (floorplan != null) {
            this.m_model.deleteModelObject(floorplan);
            repository.commitChanges();
        }
        if ((floorplan = this.m_model.createModelObject(symbolicName, floorplanClassInfo)) == null) {
            ModelIOException modelExcep = new ModelIOException("New root model class object is not created (null is returned)");
            CAFUIPublicLogger.exiting(null, jARMRequest, "readModel(String, String, Class , IWDDeployableObject, Element)", logger);
            logger.throwing("readModel(String, String, Class , IWDDeployableObject, Element)", (Throwable)modelExcep);
            throw modelExcep;
        }
        repository.commitChanges();
        this.readNode(floorplan, null, domElement, true);
        repository.commitChanges();
        CAFUIPublicLogger.exiting(null, jARMRequest, "readModel(String, String, Class , IWDDeployableObject, Element)", logger);
    }

    private void readNode(IWDRepositoryModelClass modelClassObj, ICMIRelationRoleInfo roleInfo, Element domElement, boolean isRootNode) {
        if (isRootNode) {
            Element elementsList = (Element)domElement.getElementsByTagName("elements").item(0);
            NodeList elements = elementsList.getElementsByTagName("element");
            Element el = (Element)elements.item(0);
            this.readSingleElement(modelClassObj, el);
            this.readChildren(modelClassObj, domElement);
        } else {
            this.readElements(modelClassObj, roleInfo, domElement);
        }
    }

    private void readElements(IWDRepositoryModelClass modelClassObj, ICMIRelationRoleInfo roleInfo, Element domElement) {
        String method = "readElements(IWDRepositoryModelClass, ICMIRelationRoleInfo, Element)";
        CAFUIPublicLogger.entering(null, jARMRequest, "readElements(IWDRepositoryModelClass, ICMIRelationRoleInfo, Element)", logger);
        if ((this.m_settings & 1) != 0) {
            try {
                this.readElementsSub(modelClassObj, roleInfo, domElement);
            }
            catch (Throwable e) {
                CAFUIPublicLogger.traceThrowableT(100, logger, "readElements(IWDRepositoryModelClass, ICMIRelationRoleInfo, Element)", "Failed read elements from xml", e);
            }
        } else {
            this.readElementsSub(modelClassObj, roleInfo, domElement);
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "readElements(IWDRepositoryModelClass, ICMIRelationRoleInfo, Element)", logger);
    }

    private void readElementsSub(IWDRepositoryModelClass modelClassObj, ICMIRelationRoleInfo roleInfo, Element domElement) {
        IWDRepositoryModelClassInfo floorplanClassInfo = (IWDRepositoryModelClassInfo)this.m_model.associatedModelInfo().getModelClassInfo(roleInfo.getModelClassInfo().getName());
        Vector<IWDRepositoryModelClass> v = new Vector<IWDRepositoryModelClass>();
        IWDRepositoryModelClass floorplan = null;
        Element elementsList = (Element)domElement.getElementsByTagName("elements").item(0);
        NodeList elements = elementsList.getElementsByTagName("element");
        String prefNameElementModelClass = modelClassObj.getName() + "." + Math.abs(roleInfo.getName().hashCode());
        for (int i = 0; i < elements.getLength(); ++i) {
            Element el = (Element)elements.item(i);
            String name = prefNameElementModelClass + "_" + i;
            floorplan = this.m_model.getModelObject(name, floorplanClassInfo);
            if (floorplan != null) {
                this.m_model.deleteModelObject(floorplan);
                this.m_model.getRepository().commitChanges();
            }
            floorplan = this.m_model.createModelObject(name, floorplanClassInfo);
            this.readSingleElement(floorplan, el);
            if (floorplan == null) continue;
            v.addElement(floorplan);
        }
        if (floorplan != null) {
            this.readChildren(floorplan, domElement);
        }
        modelClassObj.setRelatedModelObjects(roleInfo.getName(), v);
    }

    private void readSingleElement(IWDRepositoryModelClass modelClassObj, Element domElement) {
        NodeList attrs = domElement.getElementsByTagName("attr");
        for (int i = 0; i < attrs.getLength(); ++i) {
            Element attrEl = (Element)attrs.item(i);
            String name = attrEl.getAttribute("name");
            String type = attrEl.getAttribute("type");
            String value = attrEl.getFirstChild().getNodeValue();
            ICMIModelClassPropertyInfo propInfo = modelClassObj.associatedModelClassInfo().getPropertyInfo(name);
            if (propInfo == null) {
                propInfo = modelClassObj.associatedModelClassInfo().getPropertyInfo("PROP" + name);
            }
            if (propInfo == null) continue;
            if (value != null && value instanceof String) {
                value = URLEncoder.encode(value);
            }
            modelClassObj.setAttributeValue(propInfo.getName(), (Object)value);
        }
    }

    private void readChildren(IWDRepositoryModelClass modelClassObj, Element domElement) {
        Element nodesList = (Element)domElement.getElementsByTagName("children").item(0);
        NodeList nodes = nodesList.getElementsByTagName("node");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeEl = (Element)nodes.item(i);
            if (nodeEl.getParentNode() != nodesList || nodeEl == null) continue;
            String name = nodeEl.getAttribute("name");
            ICMIRelationRoleInfo roleInfo = modelClassObj.associatedModelClassInfo().getTargetRoleInfo(name);
            this.readNode(modelClassObj, roleInfo, nodeEl, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

