/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.repository.context;

import com.sap.caf.ui.utils.repository.ReposUtils;
import com.sap.caf.ui.utils.repository.context.ContextIOException;
import com.sap.caf.ui.utils.repository.context.ContextReader;
import com.sap.security.api.IUser;
import com.sap.tc.cmi.metadata.ICMIModelClassPropertyInfo;
import com.sap.tc.cmi.metadata.ICMIRelationRoleInfo;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
import com.sap.tc.webdynpro.repository.api.IWDRepository;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModel;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClass;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClassInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;
import java.net.URLEncoder;
import java.util.Iterator;

public class ContextWriter {
    private IWDNode m_root;
    private IWDRepositoryModel m_model;

    public ContextWriter(IWDNode context) {
        this.m_root = context;
    }

    public void saveToRepository(String symbolicName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject) throws ContextIOException {
        String sKey = fullModelClassName + symbolicName;
        IWDRepository repository = ReposUtils.getRepository(depObject);
        this.m_model = repository.getRepositoryModel(modelClass);
        IWDRepositoryModelClassInfo floorplanClassInfo = (IWDRepositoryModelClassInfo)this.m_model.associatedModelInfo().getModelClassInfo(fullModelClassName);
        IWDRepositoryModelClass floorplan = this.m_model.getModelObject(symbolicName, floorplanClassInfo);
        if (floorplan != null) {
            this.m_model.deleteModelObject(floorplan);
            repository.commitChanges();
        }
        floorplan = this.m_model.createModelObject(symbolicName, floorplanClassInfo);
        repository.commitChanges();
        this.saveRootNode(this.m_root, floorplan);
        repository.commitChanges();
        ContextReader.removeModelFromCache(sKey);
    }

    public void saveToPersonalizedRepository(IUser user, String symbolicName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject) throws ContextIOException {
        String sKey = fullModelClassName + symbolicName;
        IWDRepository repository = ReposUtils.getPersonalizedRepository(user, depObject);
        this.m_model = repository.getRepositoryModel(modelClass);
        IWDRepositoryModelClassInfo floorplanClassInfo = (IWDRepositoryModelClassInfo)this.m_model.associatedModelInfo().getModelClassInfo(fullModelClassName);
        IWDRepositoryModelClass floorplan = this.m_model.getModelObject(symbolicName, floorplanClassInfo);
        if (floorplan != null) {
            this.m_model.deleteModelObject(floorplan);
            repository.commitChanges();
        }
        floorplan = this.m_model.createModelObject(symbolicName, floorplanClassInfo);
        repository.commitChanges();
        this.saveRootNode(this.m_root, floorplan);
        repository.commitChanges();
    }

    private void saveRootNode(IWDNode node, IWDRepositoryModelClass modelClassObj) {
        if (modelClassObj != null) {
            IWDNodeElement element = node.getCurrentElement();
            this.saveElementAttributes(node, element, modelClassObj);
            this.saveChildren(element, modelClassObj);
        }
    }

    private void saveNode(IWDNode node, IWDNodeElement parent, IWDRepositoryModelClass modelClassObj) {
        ICMIRelationRoleInfo roleInfo = modelClassObj.associatedModelClassInfo().getTargetRoleInfo(node.getNodeInfo().getName());
        if (roleInfo != null) {
            this.saveElements(node, parent, modelClassObj, roleInfo);
        }
    }

    private void saveChildren(IWDNodeElement element, IWDRepositoryModelClass modelClassObj) {
        IWDNode node = element.node();
        IWDNodeInfo nodeInfo = node.getNodeInfo();
        int number = element.index();
        Iterator children = nodeInfo.iterateChildren();
        while (children.hasNext()) {
            IWDNode childNode;
            IWDNodeInfo childInfo = (IWDNodeInfo)children.next();
            try {
                childNode = node.getChildNode(childInfo.getName(), number);
            }
            catch (Exception e) {
                continue;
            }
            this.saveNode(childNode, element, modelClassObj);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void saveElements(IWDNode node, IWDNodeElement parent, IWDRepositoryModelClass modelClassObj, ICMIRelationRoleInfo roleInfo) {
        StringBuffer name = new StringBuffer(modelClassObj.getName());
        name.append(".");
        name.append(roleInfo.getName());
        name.append("_");
        int nameSavepoint = name.length();
        IWDRepositoryModel model = modelClassObj.getRepositoryRoot();
        IWDRepositoryModelClassInfo floorplanClassInfo = (IWDRepositoryModelClassInfo)model.associatedModelInfo().getModelClassInfo(roleInfo.getModelClassInfo().getName());
        boolean ASSOCIATION = false;
        boolean AGGREGATION = true;
        int relationType = roleInfo.getOtherRoleInfo().isAggregation() ? 1 : 0;
        for (int i = 0; i < node.size(); ++i) {
            void var15_15;
            IWDNodeElement el = node.getElementAt(i);
            name.setLength(nameSavepoint);
            name.append(i);
            String newName = name.toString();
            switch (relationType) {
                case 1: {
                    IWDRepositoryModelClass floorplan = modelClassObj.createRelatedModelObject(roleInfo.getName(), newName);
                    break;
                }
                case 0: {
                    IWDRepositoryModelClass floorplanPrev = model.getModelObject(newName, floorplanClassInfo);
                    if (floorplanPrev != null) {
                        model.deleteModelObject(floorplanPrev);
                        model.getRepository().commitChanges();
                    }
                    IWDRepositoryModelClass floorplan = model.createModelObject(newName, floorplanClassInfo);
                    modelClassObj.addRelatedModelObject(roleInfo.getName(), (ICMIModelClass)floorplan);
                    break;
                }
                default: {
                    throw new RuntimeException("SHOUD NEVER OCCUR");
                }
            }
            if (var15_15 == null) continue;
            this.saveElementAttributes(node, el, (IWDRepositoryModelClass)var15_15);
            this.saveChildren(el, (IWDRepositoryModelClass)var15_15);
        }
    }

    private void saveElementAttributes(IWDNode node, IWDNodeElement el, IWDRepositoryModelClass modelClassObj) {
        IWDNodeInfo nodeInfo = node.getNodeInfo();
        Iterator attrItr = nodeInfo.iterateAttributes();
        while (attrItr.hasNext()) {
            IWDAttributeInfo attr = (IWDAttributeInfo)attrItr.next();
            String attrName = attr.getName();
            Object value = el.getAttributeValue(attrName);
            ICMIModelClassPropertyInfo propInfo = modelClassObj.associatedModelClassInfo().getPropertyInfo(attrName);
            if (propInfo == null) {
                propInfo = modelClassObj.associatedModelClassInfo().getPropertyInfo("PROP" + attrName);
            }
            if (propInfo == null) continue;
            if (value != null && value instanceof String) {
                value = URLEncoder.encode((String)value);
            }
            modelClassObj.setAttributeValue(propInfo.getName(), value);
        }
    }
}

