/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.repository.context;

import com.sap.caf.ui.utils.repository.ReposUtils;
import com.sap.caf.ui.utils.repository.context.ContextIOException;
import com.sap.caf.ui.utils.repository.context.TypeUtils;
import com.sap.security.api.IUser;
import com.sap.tc.cmi.metadata.ICMIModelClassPropertyInfo;
import com.sap.tc.cmi.metadata.ICMIRelationRoleInfo;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
import com.sap.tc.webdynpro.repository.api.IWDRepository;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModel;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClass;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClassInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class ContextReader {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$repository$context$ContextReader == null ? (class$com$sap$caf$ui$utils$repository$context$ContextReader = ContextReader.class$("com.sap.caf.ui.utils.repository.context.ContextReader")) : class$com$sap$caf$ui$utils$repository$context$ContextReader));
    public static final int STN_SINK_EXCEPTION_RUNTIME = 1;
    public static final int SETTINGS_STANDARD = 0;
    public static final int SETTINGS_SINK_EXCEPTION_RUNTIME = 1;
    private static HashMap models = new HashMap(103);
    private IWDNode m_context;
    private int m_settings = 0;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$repository$context$ContextReader;

    public ContextReader(IWDNode context) {
        this.m_context = context;
        this.m_settings = 0;
    }

    public ContextReader(IWDNode context, int settings) {
        this.m_context = context;
        this.m_settings = settings;
    }

    public void setSettings(int settings) {
        this.m_settings = settings;
    }

    public int getSettings() {
        return this.m_settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromRepository(String symbolicName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject) throws ContextIOException {
        IWDRepositoryModelClass floorplan = null;
        String sKey = fullModelClassName + symbolicName;
        HashMap hashMap = models;
        synchronized (hashMap) {
            floorplan = ContextReader.getModelFromCache(sKey);
            if (floorplan == null) {
                IWDRepositoryModelClassInfo floorplanClassInfo;
                IWDRepository repository = ReposUtils.getRepository(depObject);
                IWDRepositoryModel model = repository.getRepositoryModel(modelClass);
                floorplan = model.getModelObject(symbolicName, floorplanClassInfo = (IWDRepositoryModelClassInfo)model.associatedModelInfo().getModelClassInfo(fullModelClassName));
                if (floorplan == null) {
                    throw new ContextIOException("Responding root model class object not found");
                }
                ContextReader.addModelToCache(sKey, floorplan);
            }
            this.readRootNode(this.m_context, floorplan);
        }
    }

    public void readFromPersonalizedRepository(IUser user, String symbolicName, String fullModelClassName, Class modelClass, IWDDeployableObject depObject) throws ContextIOException {
        IWDRepositoryModelClassInfo floorplanClassInfo;
        IWDRepository repository;
        IWDRepositoryModel model;
        IWDRepositoryModelClass floorplan = null;
        String sKey = fullModelClassName + symbolicName;
        if (floorplan == null && (floorplan = (model = (repository = ReposUtils.getPersonalizedRepository(user, depObject)).getRepositoryModel(modelClass)).getModelObject(symbolicName, floorplanClassInfo = (IWDRepositoryModelClassInfo)model.associatedModelInfo().getModelClassInfo(fullModelClassName))) == null) {
            throw new ContextIOException("Responding root model class object not found");
        }
        this.readRootNode(this.m_context, floorplan);
    }

    private void readRootNode(IWDNode node, IWDRepositoryModelClass modelClassObj) {
        node.invalidate();
        if (modelClassObj != null) {
            IWDNodeElement el = this.readElement(node, modelClassObj);
            this.readChildren(el, modelClassObj);
        }
    }

    private void readNode(IWDNode node, Collection modelClassObjects) {
        Iterator itModelClassObjects = modelClassObjects.iterator();
        IWDRepositoryModelClass modelClassObj = null;
        node.invalidate();
        while (itModelClassObjects.hasNext()) {
            modelClassObj = (IWDRepositoryModelClass)itModelClassObjects.next();
            IWDNodeElement el = this.readElement(node, modelClassObj);
            this.readChildren(el, modelClassObj);
        }
    }

    private IWDNodeElement readElement(IWDNode node, IWDRepositoryModelClass modelClassObj) {
        if ((this.m_settings & 1) != 0) {
            try {
                IWDNodeElement nodeEl = node.createElement();
                this.readSingleElement(node, nodeEl, modelClassObj);
                node.addElement(nodeEl);
                return nodeEl;
            }
            catch (Throwable e) {
                e.printStackTrace(System.out);
            }
        } else {
            IWDNodeElement nodeEl = node.createElement();
            this.readSingleElement(node, nodeEl, modelClassObj);
            node.addElement(nodeEl);
            return nodeEl;
        }
        return null;
    }

    private void readSingleElement(IWDNode node, IWDNodeElement el, IWDRepositoryModelClass modelClassObj) {
        IWDNodeInfo nodeInfo = node.getNodeInfo();
        Iterator attrItr = nodeInfo.iterateAttributes();
        HashMap<String, ICMIModelClassPropertyInfo> attrMap = new HashMap<String, ICMIModelClassPropertyInfo>();
        Iterator itPropInfos = modelClassObj.associatedModelClassInfo().getPropertyInfos().iterator();
        while (itPropInfos.hasNext()) {
            ICMIModelClassPropertyInfo propInfo = (ICMIModelClassPropertyInfo)itPropInfos.next();
            String name = propInfo.getName();
            String type = propInfo.getDataType().getLocalName();
            attrMap.put(name, propInfo);
            type = "ddic:com.sap.dictionary." + type.toLowerCase();
            if (name.startsWith("PROP")) {
                if (nodeInfo.getAttribute(name.substring("PROP".length())) != null) continue;
                nodeInfo.addAttribute(name, type);
                continue;
            }
            if (nodeInfo.getAttribute(name) != null) continue;
            nodeInfo.addAttribute(name, type);
        }
        Locale currentLocale = ReposUtils.getCurrentLocale();
        while (attrItr.hasNext()) {
            String type;
            Object value;
            IWDAttributeInfo attr = (IWDAttributeInfo)attrItr.next();
            ICMIModelClassPropertyInfo propInfo = (ICMIModelClassPropertyInfo)attrMap.get(attr.getName());
            if (propInfo == null) {
                propInfo = (ICMIModelClassPropertyInfo)attrMap.get("PROP" + attr.getName());
            }
            if (propInfo == null) {
                logger.warningT("No such element: " + attr.getName());
                continue;
            }
            if ((this.m_settings & 1) != 0) {
                if (attr.hasSimpleType()) {
                    value = modelClassObj.getAttributeValue(propInfo.getName(), currentLocale);
                    type = propInfo.getDataType().getLocalName();
                    if (value == null) continue;
                    if (value instanceof String) {
                        value = URLDecoder.decode((String)value);
                    }
                    el.setAttributeValue(attr.getName(), TypeUtils.getModelTypedValue(value, type));
                    continue;
                }
                logger.warningT("Element " + attr.getName() + " doesn't have simple type. Data type: " + attr.getDataType().getName());
                continue;
            }
            value = modelClassObj.getAttributeValue(propInfo.getName());
            if (value == null) continue;
            if (value instanceof String) {
                value = URLDecoder.decode((String)value);
            }
            type = propInfo.getDataType().getLocalName();
            el.setAttributeValue(attr.getName(), value);
        }
    }

    private void readChildren(IWDNodeElement element, IWDRepositoryModelClass modelClassObj) {
        IWDNode node = element.node();
        IWDNodeInfo nodeInfo = node.getNodeInfo();
        HashMap<String, ICMIRelationRoleInfo> nodeMap = new HashMap<String, ICMIRelationRoleInfo>();
        Iterator itRoleInfos = modelClassObj.associatedModelClassInfo().iterateSourceRoleInfos();
        while (itRoleInfos.hasNext()) {
            ICMIRelationRoleInfo roleInfo = (ICMIRelationRoleInfo)itRoleInfos.next();
            String name = roleInfo.getOtherRoleInfo().getName();
            nodeMap.put(name, roleInfo);
            IWDNode child = node.getChildNode(name, -1);
            if (child != null) continue;
            nodeInfo.addChild(name, null, true, false, true, false, false, true, null, null, null);
        }
        Iterator nodesItr = nodeInfo.iterateChildren();
        while (nodesItr.hasNext()) {
            String name;
            Collection childModelClassObjects;
            IWDNodeInfo childNodeInfo = (IWDNodeInfo)nodesItr.next();
            ICMIRelationRoleInfo roleInfo = (ICMIRelationRoleInfo)nodeMap.get(childNodeInfo.getName());
            if (roleInfo == null || (childModelClassObjects = modelClassObj.getRelatedModelObjects(name = roleInfo.getOtherRoleInfo().getName())).isEmpty()) continue;
            this.readNode(node.getChildNode(childNodeInfo.getName(), element.index()), childModelClassObjects);
        }
    }

    private static void addModelToCache(String sKey, IWDRepositoryModelClass floorplan) {
        models.put(sKey, floorplan);
    }

    private static IWDRepositoryModelClass getModelFromCache(String sKey) {
        return (IWDRepositoryModelClass)models.get(sKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeModelFromCache(String sKey) {
        HashMap hashMap = models;
        synchronized (hashMap) {
            models.remove(sKey);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

