/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.repository.callback;

import com.sap.caf.ui.ptn.common.components.componentbrowser.api.ICBConfigurationSearcher;
import com.sap.caf.ui.utils.repository.IConfigurationManager;
import com.sap.caf.ui.utils.repository.ReposUtils;
import com.sap.caf.ui.utils.repository.RepositoryToolkit;
import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.repository.api.IWDRepository;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModel;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClass;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClassInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import com.sap.tc.webdynpro.services.sal.localization.api.WDResourceHandler;
import com.sap.tc.webdynpro.services.sal.repository.api.IWDRepositoryFactory;
import com.sap.tc.webdynpro.services.sal.repository.api.WDRepository;
import java.util.Set;

public final class CallbackConfigurationManager
implements IConfigurationManager {
    private final WDDeployableObjectPart _objectPart;
    private final IWDDeployableObject _deplObject;
    private final String _configPrefix;
    private final String _modelClassName;
    private final Class _model;
    private final IAction _saveAction;
    private final IAction _loadAction;
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$repository$callback$CallbackConfigurationManager == null ? (class$com$sap$caf$ui$utils$repository$callback$CallbackConfigurationManager = CallbackConfigurationManager.class$("com.sap.caf.ui.utils.repository.callback.CallbackConfigurationManager")) : class$com$sap$caf$ui$utils$repository$callback$CallbackConfigurationManager));
    private static final String objectName = "sap.com/caf/ui/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/common";
    static /* synthetic */ Class class$com$sap$caf$ui$utils$repository$callback$CallbackConfigurationManager;

    public CallbackConfigurationManager(IWDDeployableObject deplObject, WDDeployableObjectPart objectPart, String fullModelClassName, Class model, IAction saveAction, IAction loadAction) {
        this._deplObject = ReposUtils.getDefaultStoreDO() != null ? ReposUtils.getDefaultStoreDO() : deplObject;
        this._objectPart = objectPart;
        this._configPrefix = CallbackConfigurationManager.composePrefix(this._objectPart);
        this._model = model;
        this._modelClassName = fullModelClassName;
        this._saveAction = saveAction;
        this._loadAction = loadAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String name, IAction action) {
        IWDRepository repository = CallbackConfigurationManager.getRWRepository(this._objectPart);
        try {
            IWDRepositoryModel model = repository.getRepositoryModel(this._model);
            IWDRepositoryModelClassInfo classInfo = (IWDRepositoryModelClassInfo)model.associatedModelInfo().getModelClassInfo(this._modelClassName);
            String configName = ReposUtils.getLongConfigurationName(name, this._objectPart);
            IWDRepositoryModelClass instance = model.getModelObject(configName, classInfo);
            if (null != instance) {
                model.deleteModelObject(instance);
                repository.commitChanges();
            }
            instance = model.createModelObject(configName, classInfo);
            action.execute(name, instance);
            repository.commitChanges();
        }
        finally {
            repository.close();
        }
    }

    public void save(String name) {
        this.save(name, this._saveAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String name, IAction action) {
        String method = "CAF:UI:sap.com/caf/ui/common:load()";
        IWDRepository repository = CallbackConfigurationManager.getRORepository(this._objectPart);
        try {
            IWDRepositoryModel model = repository.getRepositoryModel(this._model);
            IWDRepositoryModelClassInfo classInfo = (IWDRepositoryModelClassInfo)model.associatedModelInfo().getModelClassInfo(this._modelClassName);
            String configName = ReposUtils.getLongConfigurationName(name, this._objectPart);
            IWDRepositoryModelClass instance = model.getModelObject(configName, classInfo);
            if (null == instance && null == (instance = model.getModelObject(this.composeName(name), classInfo))) {
                boolean bl = false;
                return bl;
            }
            action.execute(name, instance);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            CAFUIPublicLogger.categoryCAF.logThrowable(500, logger, (Object)"CAF:UI:sap.com/caf/ui/common:load()", "", (Throwable)e);
        }
        finally {
            repository.close();
        }
        return false;
    }

    public boolean load(String name) {
        return this.load(name, this._loadAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String name) {
        IWDRepository repository = CallbackConfigurationManager.getRWRepository(this._objectPart);
        try {
            IWDRepositoryModel model = repository.getRepositoryModel(this._model);
            IWDRepositoryModelClassInfo classInfo = (IWDRepositoryModelClassInfo)model.associatedModelInfo().getModelClassInfo(this._modelClassName);
            String configName = ReposUtils.getLongConfigurationName(name, this._objectPart);
            IWDRepositoryModelClass instance = model.getModelObject(configName, classInfo);
            if (null == instance) {
                boolean bl = false;
                return bl;
            }
            model.deleteModelObject(instance);
            repository.commitChanges();
            boolean bl = true;
            return bl;
        }
        finally {
            repository.close();
        }
    }

    public Set list() {
        return ICBConfigurationSearcher.ADVANCED_MODEL_CONFIGURATION_SEARCHER.listConfigurationNames(this._objectPart);
    }

    private static IWDRepository getRORepository(WDDeployableObjectPart objectPart) {
        IWDRepositoryFactory factory = CallbackConfigurationManager.factoryByComponent(objectPart);
        IWDRepository repository = factory.getEditableRepository(WDResourceHandler.getCurrentSessionLocale(), factory.getVariant("base"), factory.getCustomizingLayer("base"));
        return repository;
    }

    private static IWDRepository getRWRepository(WDDeployableObjectPart objectPart) {
        IWDRepositoryFactory factory = CallbackConfigurationManager.factoryByComponent(objectPart);
        IWDRepository repository = factory.getEditableRepository(WDResourceHandler.getCurrentSessionLocale(), factory.getVariant("base"), factory.getCustomizingLayer("base"));
        return repository;
    }

    private static IWDRepositoryFactory factoryByComponent(WDDeployableObjectPart objectPart) {
        return WDRepository.getRepositoryFactory((String)RepositoryToolkit.configStoreFor(objectPart).getName());
    }

    private static String composePrefix(WDDeployableObjectPart objectPart) {
        StringBuffer prefix = new StringBuffer(128);
        prefix.append(objectPart.getName());
        prefix.append('.');
        return prefix.toString();
    }

    private final String composeName(String configName) {
        return this._configPrefix + configName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface IAction {
        public void execute(String var1, IWDRepositoryModelClass var2);
    }
}

