/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.repository;

import com.sap.caf.ui.utils.auth.XPDUserManager;
import com.sap.caf.ui.utils.files.FileUtils;
import com.sap.caf.ui.utils.repository.ReposException;
import com.sap.caf.ui.utils.repository.context.Constants;
import com.sap.caf.ui.utils.repository.context.ContextIOException;
import com.sap.caf.ui.utils.repository.context.ContextReader;
import com.sap.caf.ui.utils.repository.context.ContextWriter;
import com.sap.caf.ui.utils.repository.model.ModelIOException;
import com.sap.caf.ui.utils.repository.model.ModelReader;
import com.sap.caf.ui.utils.repository.model.ModelWriter;
import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.repository.api.IWDRepository;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModel;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClass;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClassInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import com.sap.tc.webdynpro.services.sal.localization.api.WDResourceHandler;
import com.sap.tc.webdynpro.services.sal.repository.api.IWDRepositoryFactory;
import com.sap.tc.webdynpro.services.sal.repository.api.WDRepository;
import com.sap.tc.webdynpro.services.sal.um.api.IWDClientUser;
import com.sap.tc.webdynpro.services.sal.um.api.WDClientUser;
import com.sap.tc.webdynpro.services.sal.um.api.WDUMException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Locale;

public class ReposUtils {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$repository$ReposUtils == null ? (class$com$sap$caf$ui$utils$repository$ReposUtils = ReposUtils.class$("com.sap.caf.ui.utils.repository.ReposUtils")) : class$com$sap$caf$ui$utils$repository$ReposUtils));
    public static final String CAF_DEFAULT_CONFIG_NAME = "1694056100.CAFConfig";
    private static final String COMMON_DC_NAME = "sap.com/caf~UI~ptn~common";
    private static boolean initialized = false;
    private static IWDDeployableObject defaultStorageDO;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$repository$ReposUtils;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$model$ModelConfiguration;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$model$CAFConfig;

    public static void saveContextNodeBranch(IWDNode node, String configMnemonicName, String fullModelClassName, Class modelClass, WDDeployableObjectPart deployableObjectPart) throws ReposException {
        String method = "saveContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)";
        CAFUIPublicLogger.entering(null, jARMRequest, "saveContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
        if (!ReposUtils.isCreateAllowed()) {
            ReposException reposException = new ReposException("The currenly logged user has no permissions to create/edit configurations");
            logger.throwing("saveContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            CAFUIPublicLogger.exiting(null, jARMRequest, "saveContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
            throw reposException;
        }
        if (!configMnemonicName.matches("[a-zA-Z0-9_.]+")) {
            String errorMess = "Name " + configMnemonicName + " is incorrect. It must only contain a..zA..Z0..9._- symbols.";
            ReposException reposException = new ReposException(errorMess);
            logger.throwing("saveContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            throw reposException;
        }
        ContextWriter cw = new ContextWriter(node);
        try {
            String longMnemonicName = ReposUtils.getLongConfigurationName(configMnemonicName, deployableObjectPart);
            cw.saveToRepository(longMnemonicName, fullModelClassName, modelClass, ReposUtils.getStoreDO(deployableObjectPart));
        }
        catch (ContextIOException e) {
            String errorMess = "Error on storing Context into Runtime Repository: Originated by ContextIOException: \n" + e.getMessage();
            CAFUIPublicLogger.traceThrowableT(100, logger, "saveContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", errorMess, e);
            ReposException reposException = new ReposException(errorMess);
            logger.throwing("saveContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            throw reposException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "saveContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
        }
        cw = null;
    }

    public static void savePersonalizedContextNodeBranch(IWDClientUser user, IWDNode node, String configMnemonicName, String fullModelClassName, Class modelClass, WDDeployableObjectPart deployableObjectPart) throws ReposException {
        String method = "savePersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)";
        CAFUIPublicLogger.entering(null, jARMRequest, "savePersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
        if (user == null) {
            ReposException reposException = new ReposException("Error on storing Context into Runtime Repository. User is undefined");
            logger.throwing("savePersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            CAFUIPublicLogger.exiting(null, jARMRequest, "savePersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
            throw reposException;
        }
        try {
            if (user != WDClientUser.getCurrentUser() && !ReposUtils.isCreateAllowed()) {
                ReposException reposException = new ReposException("The currenly logged user has no permissions to create/edit configurations");
                logger.throwing("savePersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
                CAFUIPublicLogger.exiting(null, jARMRequest, "savePersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
                throw reposException;
            }
        }
        catch (WDUMException e) {
            throw new ReposException("Can not get current user", e);
        }
        ContextWriter cw = new ContextWriter(node);
        try {
            String longMnemonicName = ReposUtils.getLongConfigurationName(configMnemonicName, deployableObjectPart);
            cw.saveToPersonalizedRepository(user.getSAPUser(), longMnemonicName, fullModelClassName, modelClass, ReposUtils.getStoreDO(deployableObjectPart));
        }
        catch (ContextIOException e) {
            String errorMess = "Error on storing Context into Runtime Repository: Originated by ContextIOException: \n" + e.getMessage();
            CAFUIPublicLogger.traceThrowableT(100, logger, "savePersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", errorMess, e);
            ReposException reposException = new ReposException(errorMess);
            logger.throwing("savePersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            throw reposException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "savePersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
        }
        cw = null;
    }

    public static void saveModel(String configMnemonicName, String fullModelClassName, Class modelClass, WDDeployableObjectPart deployableObjectPart) throws ReposException {
        String method = "saveModel(String, String, Class, WDDeployableObjectPart)";
        CAFUIPublicLogger.entering(null, jARMRequest, "saveModel(String, String, Class, WDDeployableObjectPart)", logger);
        if (!ReposUtils.isCreateAllowed()) {
            ReposException reposException = new ReposException("The currenly logged user has no permissions to create/edit configurations");
            logger.throwing("saveModel(String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            CAFUIPublicLogger.exiting(null, jARMRequest, "saveModel(String, String, Class, WDDeployableObjectPart)", logger);
            throw reposException;
        }
        ModelWriter mw = new ModelWriter();
        try {
            String longMnemonicName = ReposUtils.getLongConfigurationName(configMnemonicName, deployableObjectPart);
            String fullFileName = FileUtils.getFullFilePath(longMnemonicName, deployableObjectPart, 1);
            mw.save(longMnemonicName, fullFileName, fullModelClassName, modelClass, ReposUtils.getStoreDO(deployableObjectPart));
        }
        catch (ModelIOException e) {
            String errorMess = "Error on storing Model into XML: Originated by ModelIOException: \n" + e.getMessage();
            CAFUIPublicLogger.traceThrowableT(100, logger, "saveModel(String, String, Class, WDDeployableObjectPart)", errorMess, e);
            ReposException reposException = new ReposException(errorMess);
            logger.throwing("saveModel(String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            throw reposException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "saveModel(String, String, Class, WDDeployableObjectPart)", logger);
        }
        mw = null;
    }

    public static void loadContextNodeBranch(IWDNode node, String configMnemonicName, String fullModelClassName, Class modelClass, WDDeployableObjectPart deployableObjectPart) throws ReposException {
        String method = "loadContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)";
        CAFUIPublicLogger.entering(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
        ContextReader cr = new ContextReader(node);
        try {
            String longMnemonicName = ReposUtils.getLongConfigurationName(configMnemonicName, deployableObjectPart);
            cr.readFromRepository(longMnemonicName, fullModelClassName, modelClass, deployableObjectPart.getDeployableObject());
        }
        catch (ContextIOException e) {
            String errorMess = "Error on reading Context from Runtime Repository: Originated by ContextIOException: \n" + e.getMessage();
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", errorMess, e);
            ReposException reposException = new ReposException(errorMess, e);
            logger.throwing("loadContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            throw reposException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
        }
        cr = null;
    }

    public static void loadPersonalizedContextNodeBranch(IWDClientUser user, IWDNode node, String configMnemonicName, String fullModelClassName, Class modelClass, WDDeployableObjectPart deployableObjectPart) throws ReposException {
        String method = "loadPersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)";
        CAFUIPublicLogger.entering(null, jARMRequest, "loadPersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
        ContextReader cr = new ContextReader(node);
        if (user == null) {
            ReposException reposException = new ReposException("Error on storing Context into Runtime Repository. User is undefined");
            logger.throwing("loadPersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            CAFUIPublicLogger.exiting(null, jARMRequest, "loadPersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
            throw reposException;
        }
        try {
            String longMnemonicName = ReposUtils.getLongConfigurationName(configMnemonicName, deployableObjectPart);
            cr.readFromPersonalizedRepository(user.getSAPUser(), longMnemonicName, fullModelClassName, modelClass, deployableObjectPart.getDeployableObject());
        }
        catch (Exception e) {
            String errorMess = "Error on reading Context from Runtime Repository: " + e.getMessage();
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadPersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", errorMess, e);
            ReposException reposException = new ReposException(errorMess);
            logger.throwing("loadPersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            throw reposException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "loadPersonalizedContextNodeBranch(IWDClientUser, IWDNode, String, String, Class, WDDeployableObjectPart)", logger);
        }
        cr = null;
    }

    public static void readModel(String configMnemonicName, String fullModelClassName, Class modelClass, WDDeployableObjectPart deployableObjectPart) throws ReposException {
        String method = "readModel(String, String, Class, WDDeployableObjectPart)";
        CAFUIPublicLogger.entering(null, jARMRequest, "readModel(String, String, Class, WDDeployableObjectPart)", logger);
        ModelReader mr = new ModelReader();
        try {
            String longMnemonicName = ReposUtils.getLongConfigurationName(configMnemonicName, deployableObjectPart);
            String fullFileName = FileUtils.getFullFilePath(longMnemonicName, deployableObjectPart, 1);
            mr.read(longMnemonicName, fullFileName, fullModelClassName, modelClass, deployableObjectPart.getDeployableObject());
        }
        catch (ModelIOException e) {
            String errorMess = "Error on reading Model from XML: Originated by ModelIOException: \n" + e.getMessage();
            CAFUIPublicLogger.traceThrowableT(100, logger, "readModel(String, String, Class, WDDeployableObjectPart)", errorMess, e);
            ReposException reposException = new ReposException(errorMess);
            logger.throwing("readModel(String, String, Class, WDDeployableObjectPart)", (Throwable)reposException);
            throw reposException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "readModel(String, String, Class, WDDeployableObjectPart)", logger);
        }
        mr = null;
    }

    public static IWDRepository getRepository(IWDDeployableObject deployableObject) {
        IWDRepositoryFactory factory = WDRepository.getRepositoryFactory((String)deployableObject.getName());
        IWDRepository repository = factory.getEditableRepository(ReposUtils.getCurrentLocale(), factory.getVariant("base"), factory.getCustomizingLayer("base"));
        return repository;
    }

    public static IWDRepository getPersonalizedRepository(IUser user, IWDDeployableObject deployableObject) {
        IWDRepositoryFactory factory = WDRepository.getRepositoryFactory((String)deployableObject.getName());
        IWDRepository repository = factory.getPersonalizedRepository(ReposUtils.getCurrentLocale(), user, factory.getVariant("base"));
        return repository == null ? null : repository.getPersonalizationRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfiguration(String configMnemonicName, String fullModelClassName, Class modelClass, WDDeployableObjectPart deployableObjectPart) {
        IWDRepository repository = ReposUtils.getRepository(deployableObjectPart.getDeployableObject());
        try {
            IWDRepositoryModel model = repository.getRepositoryModel(modelClass);
            IWDRepositoryModelClassInfo classInfo = (IWDRepositoryModelClassInfo)model.associatedModelInfo().getModelClassInfo(fullModelClassName);
            String configName = ReposUtils.getLongConfigurationName(configMnemonicName, deployableObjectPart);
            IWDRepositoryModelClass instance = model.getModelObject(configName, classInfo);
            if (null != instance) {
                model.deleteModelObject(instance);
                ContextReader.removeModelFromCache(fullModelClassName + configName);
                repository.commitChanges();
            }
        }
        finally {
            repository.close();
        }
    }

    public static String getLongConfigurationName(String configMnemonicName, WDDeployableObjectPart deployableObjectPart) {
        return String.valueOf(Math.abs(deployableObjectPart.getName().hashCode())) + "." + configMnemonicName;
    }

    static String getConfigurationName(String longName, WDDeployableObjectPart deployableObjectPart) {
        String code = String.valueOf(Math.abs(deployableObjectPart.getName().hashCode()));
        int dot = longName.indexOf(46);
        if (dot >= 0) {
            String prefix = longName.substring(0, dot);
            if (code.equals(prefix)) {
                int idx = longName.lastIndexOf(".xml");
                idx = idx >= 0 && dot < idx ? idx : longName.length();
                return longName.substring(dot + 1, idx);
            }
            return longName.substring(deployableObjectPart.getName().length() + 1);
        }
        return longName;
    }

    static boolean isDeployableObjectPartConfig(String longName, WDDeployableObjectPart deployableObjectPart) {
        String objectPartName = deployableObjectPart.getName();
        String code = String.valueOf(Math.abs(objectPartName.hashCode()));
        int dot = longName.indexOf(46);
        if (dot >= 0) {
            String prefix = longName.substring(0, dot);
            if (code.equals(prefix)) {
                return true;
            }
            if (longName.startsWith(objectPartName) && longName.lastIndexOf(".") == objectPartName.length()) {
                return true;
            }
        }
        return false;
    }

    static IWDDeployableObject getStoreDO(WDDeployableObjectPart objectPart) {
        if (defaultStorageDO != null) {
            return defaultStorageDO;
        }
        return objectPart.getDeployableObject();
    }

    public static IWDDeployableObject getDefaultStoreDO() {
        return defaultStorageDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void loadDefaultStorageObject() {
        block7: {
            block8: {
                String method = "loadDefaultStorageObject()";
                CAFUIPublicLogger.entering(null, jARMRequest, "loadDefaultStorageObject()", logger);
                IWDRepository repository = null;
                try {
                    block6: {
                        try {
                            Object attrValue;
                            String configObjectName;
                            IWDRepositoryModelClass configObject;
                            IWDDeployableObject depObject = WDDeployableObject.getDeployableObject((String)COMMON_DC_NAME);
                            repository = ReposUtils.getRepository(depObject);
                            IWDRepositoryModel model = repository.getRepositoryModel(class$com$sap$caf$ui$utils$model$ModelConfiguration == null ? (class$com$sap$caf$ui$utils$model$ModelConfiguration = ReposUtils.class$("com.sap.caf.ui.utils.model.ModelConfiguration")) : class$com$sap$caf$ui$utils$model$ModelConfiguration);
                            IWDRepositoryModelClassInfo modelClassInfo = (IWDRepositoryModelClassInfo)model.associatedModelInfo().getModelClassInfo((class$com$sap$caf$ui$utils$model$CAFConfig == null ? (class$com$sap$caf$ui$utils$model$CAFConfig = ReposUtils.class$("com.sap.caf.ui.utils.model.CAFConfig")) : class$com$sap$caf$ui$utils$model$CAFConfig).getName());
                            Iterator i = model.iterateAllVersionableModelObjects(modelClassInfo);
                            if (!i.hasNext() || (configObject = model.getModelObject(configObjectName = (String)i.next(), modelClassInfo)) == null || (attrValue = configObject.getAttributeValue("configurationStorageDC")) == null) break block6;
                            defaultStorageDO = WDDeployableObject.getDeployableObject((String)URLDecoder.decode(attrValue.toString()));
                        }
                        catch (Exception e) {
                            CAFUIPublicLogger.traceThrowableT(100, logger, "loadDefaultStorageObject()", e.getMessage(), e);
                            defaultStorageDO = null;
                            Object var10_11 = null;
                            if (repository != null) {
                                repository.close();
                            }
                            CAFUIPublicLogger.exiting(null, jARMRequest, "loadDefaultStorageObject()", logger);
                            break block7;
                        }
                    }
                    Object var10_10 = null;
                    if (repository == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (repository != null) {
                        repository.close();
                    }
                    CAFUIPublicLogger.exiting(null, jARMRequest, "loadDefaultStorageObject()", logger);
                    throw throwable;
                }
                repository.close();
            }
            CAFUIPublicLogger.exiting(null, jARMRequest, "loadDefaultStorageObject()", logger);
        }
        initialized = true;
    }

    public static boolean isCreateAllowed() throws ReposException {
        String method = "boolean isCreateAllowed()";
        CAFUIPublicLogger.entering(null, jARMRequest, "boolean isCreateAllowed()", logger);
        boolean result = false;
        try {
            IUser currentUser = XPDUserManager.getCurrentUser();
            if (currentUser != null) {
                String adminRole = Constants.getProperty("RoleCreateEditConfigs");
                String adminRoleID = UMFactory.getRoleFactory().getRoleByUniqueName(adminRole).getUniqueID();
                result = currentUser.isMemberOfRole(adminRoleID, true);
            }
        }
        catch (UMException e) {
            String errorMess = "The permissions of currenly logged user could not be checked: " + e.getMessage();
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "boolean isCreateAllowed()", errorMess, (Throwable)e);
            ReposException reposException = new ReposException(errorMess, e);
            logger.throwing("boolean isCreateAllowed()", (Throwable)reposException);
            throw reposException;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "boolean isCreateAllowed()", logger);
        }
        return result;
    }

    public static String getCurrentLocaleString() {
        Locale currentLocale = ReposUtils.getCurrentLocale();
        return currentLocale != null ? "_" + currentLocale.toString() : "_";
    }

    public static Locale getCurrentLocale() {
        return WDResourceHandler.getCurrentSessionLocale();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (!initialized) {
            ReposUtils.loadDefaultStorageObject();
        }
    }
}

