/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.repository;

import com.sap.caf.ui.utils.repository.IConfigBrowser;
import com.sap.caf.ui.utils.repository.ReposUtils;
import com.sap.tc.webdynpro.progmodel.api.IWDComponent;
import com.sap.tc.webdynpro.repository.api.IWDRepository;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModel;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClassInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPartType;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

class ConfigBrowser
implements IConfigBrowser {
    private IWDRepository _repository;
    private WDDeployableObjectPart _objectPart;

    public ConfigBrowser(WDDeployableObjectPart objectPart, IWDDeployableObject configDC) {
        this._objectPart = objectPart;
        this._repository = ReposUtils.getRepository(configDC);
    }

    public ConfigBrowser(IWDComponent pattern, IWDDeployableObject configDC) {
        this(pattern.getDeployableObjectPart(), configDC);
    }

    public ConfigBrowser(String deploymentName, String componentName) {
        IWDDeployableObject deployment = WDDeployableObject.getDeployableObject((String)deploymentName);
        WDDeployableObjectPart[] parts = deployment.getParts(WDDeployableObjectPartType.COMPONENT);
        WDDeployableObjectPart component = null;
        for (int i = 0; i < parts.length; ++i) {
            WDDeployableObjectPart data = parts[i];
            if (!componentName.equals(data.getName())) continue;
            component = data;
            break;
        }
        if (null == component) {
            throw new IllegalArgumentException("Cannot find component " + componentName + " within deployable object " + deploymentName);
        }
        this._objectPart = component;
        this._repository = ReposUtils.getRepository(deployment);
    }

    public Set listAvailableConfigs(Class modelClass, String configClassName) {
        if (null == this._repository) {
            throw new IllegalStateException("Underlying pattern repository already closed");
        }
        IWDRepositoryModel configModel = this._repository.getRepositoryModel(modelClass);
        IWDRepositoryModelClassInfo configClassInfo = (IWDRepositoryModelClassInfo)configModel.associatedModelInfo().getModelClassInfo(configClassName);
        TreeSet<String> configs = new TreeSet<String>();
        Iterator i = configModel.iterateVersionableModelObjects(configClassInfo);
        while (i.hasNext()) {
            String config = (String)i.next();
            if (!ReposUtils.isDeployableObjectPartConfig(config, this._objectPart)) continue;
            configs.add(ReposUtils.getConfigurationName(config, this._objectPart));
        }
        return configs;
    }

    public void close() {
        this._repository.close();
        this._repository = null;
    }
}

