/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.report;

import com.sap.caf.ui.utils.files.FileUtils;
import com.sap.caf.ui.utils.report.MessageItem;
import com.sap.caf.ui.utils.report.SMessageManager;
import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDMessage;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;

public class ContextLoadingMI
extends MessageItem {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$report$ContextLoadingMI == null ? (class$com$sap$caf$ui$utils$report$ContextLoadingMI = ContextLoadingMI.class$("com.sap.caf.ui.utils.report.ContextLoadingMI")) : class$com$sap$caf$ui$utils$report$ContextLoadingMI));
    static /* synthetic */ Class class$com$sap$caf$ui$utils$report$ContextLoadingMI;

    public ContextLoadingMI(IWDMessage wdMessage, String strMessage, SMessageManager mm) {
        super(wdMessage, strMessage, mm);
    }

    public void loadContext(IWDNode node, String compFullPath, String configName, String projectName) {
        String method = "loadContext(IWDNode, String, String, String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "loadContext(IWDNode, String, String, String)", logger);
        try {
            FileUtils.loadContextNodeBranch(node, ContextLoadingMI.getConfigName(compFullPath, configName), projectName, 1);
        }
        catch (Exception e) {
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadContext(IWDNode, String, String, String)", "Failed to load context node", e);
            this.reportMessage(new Object[]{configName, projectName});
            this.mm.getLogger().catching((Throwable)e);
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "loadContext(IWDNode, String, String, String)", logger);
    }

    public void saveContext(IWDNode node, String compFullPath, String configName, String projectName) {
        String method = "saveContext(IWDNode node, String compFullPath, String configName, String projectName)";
        CAFUIPublicLogger.entering(null, jARMRequest, "saveContext(IWDNode node, String compFullPath, String configName, String projectName)", logger);
        try {
            FileUtils.saveContextNodeBranch(node, ContextLoadingMI.getConfigName(compFullPath, configName), projectName);
        }
        catch (Exception e) {
            CAFUIPublicLogger.traceThrowableT(100, logger, "saveContext(IWDNode node, String compFullPath, String configName, String projectName)", "Failed to save context node", e);
            this.reportMessage(new Object[]{configName, projectName});
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "saveContext(IWDNode node, String compFullPath, String configName, String projectName)", logger);
    }

    public boolean saveContext(IWDNode node, String configName, WDDeployableObjectPart deplObjectPart) {
        String method = "saveContext(IWDNode, String, WDDeployableObjectPart)";
        CAFUIPublicLogger.entering(null, jARMRequest, "saveContext(IWDNode, String, WDDeployableObjectPart)", logger);
        try {
            FileUtils.saveContextNodeBranch(node, ContextLoadingMI.getConfigFileName(configName), deplObjectPart, 1);
            return true;
        }
        catch (Exception e) {
            CAFUIPublicLogger.traceThrowableT(100, logger, "saveContext(IWDNode, String, WDDeployableObjectPart)", "Failed to save context", e);
            this.reportMessage(new Object[]{configName, deplObjectPart.getDeployableObjectName()});
            CAFUIPublicLogger.exiting(null, jARMRequest, "saveContext(IWDNode, String, WDDeployableObjectPart)", logger);
            return false;
        }
    }

    public boolean loadContext(IWDNode node, String configName, WDDeployableObjectPart deplObjectPart) {
        String method = "boolean loadContext(IWDNode, String, WDDeployableObjectPart)";
        CAFUIPublicLogger.entering(null, jARMRequest, "boolean loadContext(IWDNode, String, WDDeployableObjectPart)", logger);
        if (configName != null) {
            try {
                FileUtils.loadContextNodeBranch(node, ContextLoadingMI.getConfigFileName(configName), deplObjectPart, 1);
                return true;
            }
            catch (Exception e) {
                CAFUIPublicLogger.traceThrowableT(100, logger, "boolean loadContext(IWDNode, String, WDDeployableObjectPart)", "Failed to load context", e);
            }
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "boolean loadContext(IWDNode, String, WDDeployableObjectPart)", logger);
        return false;
    }

    public static String getConfigName(String compFullPath, String configName) {
        return "Components/" + compFullPath + "/" + configName + ".xml";
    }

    public static String getConfigFileName(String configName) {
        return configName + ".xml";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

