/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.parser.functions;

import com.sap.caf.ui.utils.parser.ExecutionException;
import com.sap.caf.ui.utils.parser.ICalculationContext;
import com.sap.caf.ui.utils.parser.IFunction;
import com.sap.caf.ui.utils.parser.IFunctionConstructor;
import com.sap.caf.ui.utils.parser.Node;
import com.sap.caf.ui.utils.parser.ParseException;

public class SwitchFunction
implements IFunction {
    private static final IFunction INSTANCE = new SwitchFunction();
    public static IFunctionConstructor Constructor = new IFunctionConstructor(){

        public IFunction create() {
            return INSTANCE;
        }
    };

    private SwitchFunction() {
    }

    public Object execute(ICalculationContext ctx, Node[] arguments) throws ExecutionException {
        if (arguments == null || arguments.length < 3) {
            throw new ExecutionException("@switch function must have at least three arguments.");
        }
        Object exprValue = arguments[0].execute(ctx);
        int size = arguments.length;
        for (int i = 0; i < (size - 1) / 2; ++i) {
            Node caseExpr = arguments[i * 2 + 1];
            Node valueExpr = arguments[i * 2 + 2];
            Object caseObj = caseExpr.execute(ctx);
            if (exprValue != caseObj && (exprValue == null || !exprValue.equals(caseObj))) continue;
            return valueExpr.execute(ctx);
        }
        if (arguments.length % 2 == 0) {
            return arguments[arguments.length - 1].execute(ctx);
        }
        return null;
    }

    public void checkParams(Node[] arguments) throws ParseException {
        if (arguments == null || arguments.length < 3) {
            throw new ParseException("Function must have at least three parameters.");
        }
    }
}

