/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.parser.functions;

import com.sap.caf.ui.utils.parser.ExecutionException;
import com.sap.caf.ui.utils.parser.ICalculationContext;
import com.sap.caf.ui.utils.parser.IFunction;
import com.sap.caf.ui.utils.parser.IFunctionConstructor;
import com.sap.caf.ui.utils.parser.Node;
import com.sap.caf.ui.utils.parser.ParseException;
import com.sap.caf.ui.utils.parser.ast.ASTIntConstNode;

public class SubstringFunction
implements IFunction {
    private static final IFunction INSTANCE = new SubstringFunction();
    public static IFunctionConstructor Constructor = new IFunctionConstructor(){

        public IFunction create() {
            return INSTANCE;
        }
    };

    private SubstringFunction() {
    }

    public Object execute(ICalculationContext ctx, Node[] arguments) throws ExecutionException {
        if (arguments == null || arguments.length < 2 || arguments.length > 3) {
            throw new ExecutionException("@substring function must have two or three arguments.");
        }
        String exprValue = (String)arguments[0].execute(ctx);
        int fromIdx = ((Number)arguments[1].execute(ctx)).intValue();
        if (fromIdx < 0 || exprValue == null || fromIdx > exprValue.length()) {
            return "";
        }
        if (arguments.length > 2) {
            int toIdx = ((Number)arguments[2].execute(ctx)).intValue();
            if (toIdx > exprValue.length()) {
                return exprValue.substring(fromIdx);
            }
            return exprValue.substring(fromIdx, toIdx);
        }
        return exprValue.substring(fromIdx);
    }

    public void checkParams(Node[] arguments) throws ParseException {
        if (arguments == null || arguments.length < 2 || arguments.length > 3) {
            throw new ParseException("Function must have two or three parameters.");
        }
        if (arguments[1] instanceof ASTIntConstNode) {
            int startIdx;
            try {
                startIdx = (Integer)arguments[1].execute(null);
            }
            catch (ExecutionException e) {
                throw new ParseException("Begin index parameter parsing error.");
            }
            if (arguments.length == 3 && arguments[2] instanceof ASTIntConstNode) {
                int endIdx;
                try {
                    endIdx = (Integer)arguments[2].execute(null);
                }
                catch (ExecutionException e) {
                    throw new ParseException("End index parameter parsing error.");
                }
                if (startIdx > endIdx) {
                    throw new ParseException("Start index parameter can't be greater than end index.");
                }
            }
        }
    }
}

