/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.parser.functions;

import com.sap.caf.ui.utils.parser.ExecutionException;
import com.sap.caf.ui.utils.parser.ICalculationContext;
import com.sap.caf.ui.utils.parser.IFunction;
import com.sap.caf.ui.utils.parser.IFunctionConstructor;
import com.sap.caf.ui.utils.parser.Node;
import com.sap.caf.ui.utils.parser.ParseException;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPartType;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeploymentException;
import com.sap.tc.webdynpro.services.sal.url.api.WDURLException;
import com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator;

public class MimeUrlFunction
implements IFunction {
    public static final int URL_BY_APPLICATION_TYPE = 1;
    public static final int URL_BY_COMPONENT_TYPE = 2;
    public static final int URL_BY_DC_TYPE = 4;
    public static final int URL_BY_SAP_MIME_TYPE = 8;
    private int _type;
    private WDDeployableObjectPartType _objPartType;
    private static final IFunction INSTANCE_BY_COMPONENT = new MimeUrlFunction(2, WDDeployableObjectPartType.COMPONENT);
    private static final IFunction INSTANCE_BY_APPLICATION = new MimeUrlFunction(1, WDDeployableObjectPartType.APPLICATION);
    private static final IFunction INSTANCE_BY_DC = new MimeUrlFunction(4, null);
    private static final IFunction INSTANCE_BY_SAP_PATH = new MimeUrlFunction(8, null);
    public static IFunctionConstructor ConstructorByComponent = new IFunctionConstructor(){

        public IFunction create() {
            return INSTANCE_BY_COMPONENT;
        }
    };
    public static IFunctionConstructor ConstructorByApplication = new IFunctionConstructor(){

        public IFunction create() {
            return INSTANCE_BY_APPLICATION;
        }
    };
    public static IFunctionConstructor ConstructorByDC = new IFunctionConstructor(){

        public IFunction create() {
            return INSTANCE_BY_DC;
        }
    };
    public static IFunctionConstructor ConstructorBySAPPath = new IFunctionConstructor(){

        public IFunction create() {
            return INSTANCE_BY_SAP_PATH;
        }
    };

    private MimeUrlFunction(int type, WDDeployableObjectPartType objPartType) {
        this._type = type;
        this._objPartType = objPartType;
    }

    public Object execute(ICalculationContext ctx, Node[] arguments) throws ExecutionException {
        if (this._type == 1 || this._type == 2) {
            if (arguments == null || arguments.length != 3) {
                throw new ExecutionException("@app_mime and @component_mime function must have three arguments.");
            }
            String dcName = (String)arguments[0].execute(ctx);
            String partName = (String)arguments[1].execute(ctx);
            String mimePath = (String)arguments[2].execute(ctx);
            try {
                WDDeployableObjectPart part = WDDeployableObject.getDeployableObjectPart((String)dcName, (String)partName, (WDDeployableObjectPartType)this._objPartType);
                return WDURLGenerator.getAbsoluteWebResourceURL((WDDeployableObjectPart)part, (String)mimePath);
            }
            catch (WDDeploymentException e) {
                throw new ExecutionException("Can not obtain absolute URL for DC '" + dcName + "', component '" + partName + "' and path '" + mimePath + "'");
            }
            catch (WDURLException e) {
                throw new ExecutionException("Can not obtain absolute URL for DC '" + dcName + "', component '" + partName + "' and path '" + mimePath + "'");
            }
        }
        if (this._type == 4) {
            if (arguments == null || arguments.length != 2) {
                throw new ExecutionException("@dc_mime function must have two arguments.");
            }
            String dcName = (String)arguments[0].execute(ctx);
            String mimePath = (String)arguments[1].execute(ctx);
            try {
                return WDURLGenerator.getAbsoluteWebResourceURL((String)dcName, (String)mimePath);
            }
            catch (WDURLException e) {
                throw new ExecutionException("Can not obtain absolute URL for DC '" + dcName + "' and path '" + mimePath + "'");
            }
        }
        if (this._type == 8) {
            if (arguments == null || arguments.length != 1) {
                throw new ExecutionException("@sap_mime function must have one argument.");
            }
            String mimePath = (String)arguments[0].execute(ctx);
            return WDURLGenerator.getSAPIconsWebResourcePath() + "/" + mimePath;
        }
        throw new IllegalStateException("Function type is not specified.");
    }

    public void checkParams(Node[] arguments) throws ParseException {
        if (this._type == 1 || this._type == 2) {
            if (arguments == null || arguments.length != 3) {
                throw new ParseException("Function must have three parameters.");
            }
        } else if (this._type == 4) {
            if (arguments == null || arguments.length != 2) {
                throw new ParseException("Function must have two parameters.");
            }
        } else if (this._type == 8 && (arguments == null || arguments.length != 1)) {
            throw new ParseException("Function must have one parameter.");
        }
    }
}

