/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.parser.functions;

import com.sap.caf.ui.utils.parser.ExecutionException;
import com.sap.caf.ui.utils.parser.ICalculationContext;
import com.sap.caf.ui.utils.parser.IFunction;
import com.sap.caf.ui.utils.parser.IFunctionConstructor;
import com.sap.caf.ui.utils.parser.Node;
import com.sap.caf.ui.utils.parser.ParseException;
import java.util.HashMap;

public class MapFunction
implements IFunction {
    private static final IFunction INSTANCE = new MapFunction();
    public static IFunctionConstructor Constructor = new IFunctionConstructor(){

        public IFunction create() {
            return INSTANCE;
        }
    };

    private MapFunction() {
    }

    public Object execute(ICalculationContext ctx, Node[] arguments) throws ExecutionException {
        if (null == arguments || arguments.length == 0) {
            return ctx.getAttributesMap();
        }
        if (0 == arguments.length % 2) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            int i = 0;
            while (i < arguments.length) {
                Object key = arguments[i++].execute(ctx);
                Object val = arguments[i++].execute(ctx);
                result.put(key, val);
            }
            return result;
        }
        throw new IllegalArgumentException("@map(...) function accepts either no arguments to autocreate map by current context or even number of arguments to form key->value pairs");
    }

    public void checkParams(Node[] arguments) throws ParseException {
        if (arguments != null && 0 != arguments.length % 2) {
            throw new ParseException("This function accepts either no parameters or even number of parameters");
        }
    }
}

