/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.parser.functions;

import com.sap.caf.ui.utils.parser.ExecutionException;
import com.sap.caf.ui.utils.parser.ICalculationContext;
import com.sap.caf.ui.utils.parser.IFunction;
import com.sap.caf.ui.utils.parser.IFunctionConstructor;
import com.sap.caf.ui.utils.parser.Node;
import com.sap.caf.ui.utils.parser.ParseException;
import com.sap.caf.ui.utils.parser.ast.ASTReference;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.tc.webdynpro.services.sal.localization.api.WDResourceHandler;
import java.text.FieldPosition;
import java.text.MessageFormat;

public class FormatFunction
implements IFunction {
    private static final IFunction INSTANCE = new FormatFunction();
    public static IFunctionConstructor Constructor = new IFunctionConstructor(){

        public IFunction create() {
            return INSTANCE;
        }
    };

    private FormatFunction() {
    }

    public Object execute(ICalculationContext ctx, Node[] arguments) throws ExecutionException {
        if (arguments == null || arguments.length < 1) {
            throw new ExecutionException("@format function must have at least one argument.");
        }
        String exprValue = (String)arguments[0].execute(ctx);
        Object[] paramValues = new Object[arguments.length - 1];
        for (int i = 1; i < arguments.length; ++i) {
            IDataType type;
            Object value = arguments[i].execute(ctx);
            if (value == null && arguments[i] instanceof ASTReference && (type = ((ASTReference)arguments[i]).getType(ctx)) != null && type.isSimpleType() && ((ISimpleType)type).getBuiltInType().equalsIgnoreCase("string")) {
                value = "";
            }
            paramValues[i - 1] = value;
        }
        MessageFormat formater = new MessageFormat(exprValue, WDResourceHandler.getCurrentSessionLocale());
        return formater.format(paramValues, new StringBuffer(exprValue.length()), (FieldPosition)null).toString();
    }

    public void checkParams(Node[] arguments) throws ParseException {
        if (arguments == null || arguments.length < 1) {
            throw new ParseException("Function must have at least one parameter.");
        }
    }
}

