/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.parser.ast;

import com.sap.caf.ui.utils.parser.CalcFieldParser;
import com.sap.caf.ui.utils.parser.ExecutionException;
import com.sap.caf.ui.utils.parser.ICalculationContext;
import com.sap.caf.ui.utils.parser.SimpleNode;

public class ASTPrimitiveType
extends SimpleNode {
    private String _name;
    private boolean _isNumber;

    public ASTPrimitiveType(int id) {
        super(id);
    }

    public ASTPrimitiveType(CalcFieldParser p, int id) {
        super(p, id);
    }

    public Object execute(ICalculationContext ctx) throws ExecutionException {
        return null;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public Object cast(Object obj) throws ExecutionException {
        if (obj instanceof Number) {
            Number num = (Number)obj;
            if ("byte".equals(this._name)) {
                return new Byte(num.byteValue());
            }
            if ("char".equals(this._name)) {
                return new Character((char)num.intValue());
            }
            if ("short".equals(this._name)) {
                return new Short(num.shortValue());
            }
            if ("integer".equals(this._name)) {
                return new Integer(num.intValue());
            }
            if ("long".equals(this._name)) {
                return new Long(num.longValue());
            }
            if ("float".equals(this._name)) {
                return new Float(num.floatValue());
            }
            if ("double".equals(this._name)) {
                return new Double(num.doubleValue());
            }
            throw new ExecutionException("Can not parse " + obj + " to '" + this._name + "'");
        }
        throw new ExecutionException("Can not parse " + obj + " to '" + this._name + "'");
    }
}

