/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.parser.ast;

import com.sap.caf.ui.utils.parser.CalcFieldParser;
import com.sap.caf.ui.utils.parser.ExecutionException;
import com.sap.caf.ui.utils.parser.ICalculationContext;
import com.sap.caf.ui.utils.parser.IFunction;
import com.sap.caf.ui.utils.parser.IFunctionConstructor;
import com.sap.caf.ui.utils.parser.IFunctionLibrary;
import com.sap.caf.ui.utils.parser.ParseException;
import com.sap.caf.ui.utils.parser.SimpleNode;

public class ASTFunction
extends SimpleNode {
    private String _name;
    private static final ThreadLocal LIBRARY = new ThreadLocal();

    public ASTFunction(int id) {
        super(id);
    }

    public ASTFunction(CalcFieldParser p, int id) {
        super(p, id);
    }

    public void setName(String name) throws ParseException {
        this._name = name;
    }

    public Object execute(ICalculationContext ctx) throws ExecutionException {
        IFunctionLibrary library = ASTFunction.getLibrary();
        IFunctionConstructor ctr = library.function(this._name);
        if (ctr == null) {
            throw new ExecutionException("Function '" + this._name + "' is not recognized.");
        }
        IFunction func = ctr.create();
        return func.execute(ctx, this.children);
    }

    public static IFunctionLibrary getLibrary() {
        return (IFunctionLibrary)LIBRARY.get();
    }

    public static IFunctionLibrary setLibrary(IFunctionLibrary library) {
        IFunctionLibrary ret = (IFunctionLibrary)LIBRARY.get();
        LIBRARY.set(library);
        return ret;
    }

    public void checkParams() throws ParseException {
        IFunctionLibrary library = ASTFunction.getLibrary();
        IFunctionConstructor ctr = library.function(this._name);
        if (ctr == null) {
            throw new ParseException("Function '" + this._name + "' is not recognized.");
        }
        try {
            IFunction func = ctr.create();
            func.checkParams(this.children);
        }
        catch (ParseException e) {
            throw new ParseException("Function '" + this._name + "' parsing failed: " + e.getLocalizedMessage());
        }
        super.checkParams();
    }
}

