/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.parser;

import com.sap.caf.ui.utils.parser.IFunctionConstructor;
import com.sap.caf.ui.utils.parser.IFunctionLibrary;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class Libraries {
    private static final IFunctionLibrary EMPTY_LIBRARY = new IFunctionLibrary(){

        public IFunctionConstructor function(String name) {
            return null;
        }
    };

    private Libraries() {
    }

    public static LibraryBuilder create() {
        return new LibraryBuilder(EMPTY_LIBRARY);
    }

    public static LibraryBuilder create(IFunctionLibrary superFL) {
        return new LibraryBuilder(superFL);
    }

    private static class FunctionLibrary
    implements IFunctionLibrary {
        private final Map _functions;
        private final IFunctionLibrary _super;

        private FunctionLibrary(Map functions, IFunctionLibrary superFL) {
            this._functions = Collections.unmodifiableMap(functions);
            this._super = superFL;
        }

        public IFunctionConstructor function(String name) {
            IFunctionConstructor funCtr = (IFunctionConstructor)this._functions.get(name);
            if (funCtr == null) {
                return this._super.function(name);
            }
            return funCtr;
        }
    }

    public static class LibraryBuilder {
        private final Map _functions = new TreeMap();
        private final IFunctionLibrary _super;

        public LibraryBuilder(IFunctionLibrary superFL) {
            this._super = superFL;
        }

        public LibraryBuilder register(String name, IFunctionConstructor constructor) {
            if (this._functions.containsKey(name)) {
                throw new IllegalArgumentException("Function with the name " + name + " is registered already!");
            }
            this._functions.put(name, constructor);
            return this;
        }

        public IFunctionLibrary commit() {
            return new FunctionLibrary(this._functions, this._super);
        }
    }
}

