/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.locale;

import com.sap.dictionary.runtime.ISimpleTypeModifiable;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDContext;
import com.sap.typeservices.IModifiableSimpleValueSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public abstract class LocaleUtils {
    public static final String DEFAULT_LOCALE_KEY = "<default>";
    public static final String DEFAULT_LOCALE_VALUE = "<default>";

    public static HashMap getLocaleNames() {
        Locale[] locales = Locale.getAvailableLocales();
        HashMap<String, String> name2DisplayName = new HashMap<String, String>(locales.length + 1);
        name2DisplayName.put("<default>", "<default>");
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            name2DisplayName.put(locale.toString(), locale.getDisplayName());
        }
        return name2DisplayName;
    }

    public static void fillInContextTypeWithLocaleNames(IWDContext ctx, String attrPath, Map name2DisplayName) {
        LocaleUtils.fillInContextTypeWithLocaleNames(ctx.getModifiableTypeOf(attrPath), name2DisplayName);
    }

    public static void fillInContextTypeWithLocaleNames(IWDAttributeInfo attrInfo, Map name2DisplayName) {
        LocaleUtils.fillInContextTypeWithLocaleNames(attrInfo.getModifiableSimpleType(), name2DisplayName);
    }

    private static void fillInContextTypeWithLocaleNames(ISimpleTypeModifiable modTypeLocale, Map name2DisplayName) {
        IModifiableSimpleValueSet modTypeValuesLocale = modTypeLocale.getSVServices().getModifiableSimpleValueSet();
        modTypeValuesLocale.clear();
        Iterator i = name2DisplayName.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            modTypeValuesLocale.put(entry.getKey(), (String)entry.getValue());
        }
        modTypeValuesLocale.sort(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)((Map.Entry)o1).getValue()).compareTo((String)((Map.Entry)o2).getValue());
            }
        });
    }
}

