/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.files;

import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.caf.ui.utils.xml.context.ContextIOException;
import com.sap.caf.ui.utils.xml.context.ContextReader;
import com.sap.caf.ui.utils.xml.context.ContextWriter;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPartType;
import com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;

public class FileUtils {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$files$FileUtils == null ? (class$com$sap$caf$ui$utils$files$FileUtils = FileUtils.class$("com.sap.caf.ui.utils.files.FileUtils")) : class$com$sap$caf$ui$utils$files$FileUtils));
    public static final int RESTYPE_CONFIGURATION = 1;
    public static final int RESTYPE_MIMES = 2;
    static /* synthetic */ Class class$com$sap$caf$ui$utils$files$FileUtils;

    public static String getRelativePathWithoutLeadingCurrDirSign(String path) {
        String p = path.trim();
        if (p.startsWith(".\\") || p.startsWith("./")) {
            return p.substring(2);
        }
        return path;
    }

    public static String getFullFilePath(String filename, String projectName) {
        String resourcePath = WDURLGenerator.getResourcePath();
        File file = new File(FileUtils.getRelativePathWithoutLeadingCurrDirSign(resourcePath), "../public/local/" + projectName + "/webdynpro/" + filename);
        return file.getAbsolutePath();
    }

    public static String getFullFilePath(String filename, WDDeployableObjectPart deployableObjectPart, int resourceType) {
        return FileUtils.getFullFilePath(filename, deployableObjectPart, resourceType, false);
    }

    public static String getFullFilePath(String fileName, WDDeployableObjectPart deployableObjectPart, int resourceType, boolean isRootFolderUsed) {
        String method = "String getFullFilePath(String, WDDeployableObjectPart, int, boolean)";
        CAFUIPublicLogger.entering(null, jARMRequest, "String getFullFilePath(String, WDDeployableObjectPart, int, boolean)", logger);
        String path = null;
        try {
            if (!isRootFolderUsed) {
                WDDeployableObjectPartType depObjPartType = deployableObjectPart.getType();
                fileName = depObjPartType == WDDeployableObjectPartType.APPLICATION ? "Applications/" + deployableObjectPart.getName() + "/" + fileName : (depObjPartType == WDDeployableObjectPartType.COMPONENT_INTERFACE ? "ComponentInterfaces/" + deployableObjectPart.getName() + "/" + fileName : "Components/" + deployableObjectPart.getName() + "/" + fileName);
            }
            String childPath = resourceType == 2 ? deployableObjectPart.getDeployableObjectName() + "/" + fileName : "../public/" + deployableObjectPart.getDeployableObjectName() + "/webdynpro/" + fileName;
            File file = new File(FileUtils.getRelativePathWithoutLeadingCurrDirSign(WDURLGenerator.getResourcePath()), childPath);
            path = file.getAbsolutePath();
        }
        catch (Exception e) {
            String errorMess = MessageFormat.format("Error on getting the full file name(file name:{0})", fileName);
            CAFUIPublicLogger.traceThrowableT(100, logger, "String getFullFilePath(String, WDDeployableObjectPart, int, boolean)", errorMess, e);
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "String getFullFilePath(String, WDDeployableObjectPart, int, boolean)", logger);
        return path;
    }

    public static FileOutputStream getFileOutputStream(String filename, WDDeployableObjectPart deployableObjectPart, int resourceType) throws IOException {
        String method = "FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int)";
        CAFUIPublicLogger.entering(null, jARMRequest, "FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int)", logger);
        FileOutputStream fos = null;
        try {
            fos = FileUtils.getFileOutputStream(filename, deployableObjectPart, resourceType, false);
            return fos;
        }
        catch (IOException e) {
            String errorMess = MessageFormat.format("Error on getting the file output stream(file name: {0},  deployableObjectPart: {1}, resourceType: {2}) ", filename, deployableObjectPart, Integer.toString(resourceType));
            CAFUIPublicLogger.traceThrowableT(100, logger, "FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int)", (Throwable)ioEx);
            throw ioEx;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int)", logger);
            return fos;
        }
    }

    public static FileOutputStream getFileOutputStream(String filename, WDDeployableObjectPart deployableObjectPart, int resourceType, boolean isRootFolderUsed) throws IOException {
        String method = "FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int, boolean)";
        CAFUIPublicLogger.entering(null, jARMRequest, "FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int, boolean)", logger);
        File dir = new File(FileUtils.getFullFilePath("", deployableObjectPart, resourceType, isRootFolderUsed));
        if (!dir.exists()) {
            dir.mkdir();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(FileUtils.getFullFilePath(filename, deployableObjectPart, resourceType, isRootFolderUsed));
            return fos;
        }
        catch (IOException e) {
            String errorMess = MessageFormat.format("Error on getting the file output stream(file name: {0},  deployableObjectPart: {1}, resourceType: {2}) ", filename, deployableObjectPart, Integer.toString(resourceType));
            CAFUIPublicLogger.traceThrowableT(100, logger, "FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int, boolean)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int, boolean)", (Throwable)ioEx);
            throw ioEx;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "FileOutputStream getFileOutputStream(String, WDDeployableObjectPart, int, boolean)", logger);
            return fos;
        }
    }

    public static FileInputStream getFileInputStream(String filename, WDDeployableObjectPart deployableObjectPart, int resourceType) throws IOException {
        String method = "FileInputStream getFileInputStream(String, WDDeployableObjectPart, int)";
        CAFUIPublicLogger.entering(null, jARMRequest, "FileInputStream getFileInputStream(String, WDDeployableObjectPart, int)", logger);
        FileInputStream fis = null;
        try {
            fis = FileUtils.getFileInputStream(filename, deployableObjectPart, resourceType, false);
            return fis;
        }
        catch (IOException e) {
            String errorMess = MessageFormat.format("Error on getting the file input stream(file name: {0},  deployableObjectPart: {1}, resourceType: {2}) ", filename, deployableObjectPart, Integer.toString(resourceType));
            CAFUIPublicLogger.traceThrowableT(100, logger, "FileInputStream getFileInputStream(String, WDDeployableObjectPart, int)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("FileInputStream getFileInputStream(String, WDDeployableObjectPart, int)", (Throwable)ioEx);
            throw ioEx;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "FileInputStream getFileInputStream(String, WDDeployableObjectPart, int)", logger);
            return fis;
        }
    }

    public static FileInputStream getFileInputStream(String filename, WDDeployableObjectPart deployableObjectPart, int resourceType, boolean isRootFolderUsed) throws IOException {
        String method = "FileInputStream getFileInputStream(String, WDDeployableObjectPart, int, boolean)";
        CAFUIPublicLogger.entering(null, jARMRequest, "FileInputStream getFileInputStream(String, WDDeployableObjectPart, int, boolean)", logger);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(FileUtils.getFullFilePath(filename, deployableObjectPart, resourceType, isRootFolderUsed));
            return fis;
        }
        catch (IOException e) {
            String errorMess = MessageFormat.format("Error on getting the file input stream(file name: {0},  deployableObjectPart: {1}, resourceType: {2}, isRootFolderUsed: {3}) ", filename, deployableObjectPart, Integer.toString(resourceType), Boolean.toString(isRootFolderUsed));
            CAFUIPublicLogger.traceThrowableT(100, logger, "FileInputStream getFileInputStream(String, WDDeployableObjectPart, int, boolean)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("FileInputStream getFileInputStream(String, WDDeployableObjectPart, int, boolean)", (Throwable)ioEx);
            throw ioEx;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "FileInputStream getFileInputStream(String, WDDeployableObjectPart, int, boolean)", logger);
            return fis;
        }
    }

    public static void saveContextNodeBranch(IWDNode node, String filename, String projectName) throws IOException {
        String method = "saveContextNodeBranch(IWDNode, String, String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "saveContextNodeBranch(IWDNode, String, String)", logger);
        ContextWriter cw = new ContextWriter(node);
        FileOutputStream fos = null;
        fos = new FileOutputStream(FileUtils.getFullFilePath(filename, projectName));
        try {
            cw.save(fos);
        }
        catch (ContextIOException e) {
            String errorMess = MessageFormat.format("Originated by ContextIOException: \n{0}", e.getMessage());
            CAFUIPublicLogger.traceThrowableT(100, logger, "saveContextNodeBranch(IWDNode, String, String)", errorMess, e);
            errorMess = MessageFormat.format("Error on saving context node (node: {0},  file name: {1}, project name: {2})", node.getNodeInfo().getName(), filename, projectName);
            CAFUIPublicLogger.traceThrowableT(100, logger, "saveContextNodeBranch(IWDNode, String, String)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("saveContextNodeBranch(IWDNode, String, String)", (Throwable)ioEx);
            CAFUIPublicLogger.exiting(null, jARMRequest, "saveContextNodeBranch(IWDNode, String, String)", logger);
            throw ioEx;
        }
        fos.close();
        fos = null;
        cw = null;
        CAFUIPublicLogger.exiting(null, jARMRequest, "saveContextNodeBranch(IWDNode, String, String)", logger);
    }

    public static void saveContextNodeBranch(IWDNode node, String filename, WDDeployableObjectPart deployableObjectPart, int resourceType) throws IOException {
        FileUtils.saveContextNodeBranch(node, filename, deployableObjectPart, resourceType, false);
    }

    public static void saveContextNodeBranch(IWDNode node, String filename, WDDeployableObjectPart deployableObjectPart, int resourceType, boolean isRootFolderUsed) throws IOException {
        String method = "saveContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)";
        CAFUIPublicLogger.entering(null, jARMRequest, "saveContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", logger);
        ContextWriter cw = new ContextWriter(node);
        FileOutputStream fos = FileUtils.getFileOutputStream(filename, deployableObjectPart, resourceType, isRootFolderUsed);
        try {
            cw.save(fos);
        }
        catch (ContextIOException e) {
            String errorMess = MessageFormat.format("Originated by ContextIOException: \n{0}", e.getMessage());
            CAFUIPublicLogger.traceThrowableT(100, logger, "saveContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", errorMess, e);
            errorMess = MessageFormat.format("Error on saving context node (node: {0},  file name: {1}, deployableObjectPart: {2}, resourceType: {3})", node.getNodeInfo().getName(), deployableObjectPart, filename, Integer.toString(resourceType));
            CAFUIPublicLogger.traceThrowableT(100, logger, "saveContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("saveContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", (Throwable)ioEx);
            CAFUIPublicLogger.exiting(null, jARMRequest, "saveContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", logger);
            throw ioEx;
        }
        fos.close();
        fos = null;
        cw = null;
        CAFUIPublicLogger.exiting(null, jARMRequest, "saveContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", logger);
    }

    public static void loadContextNodeBranch(IWDNode node, String filename, String projectName) throws IOException {
        String method = "loadContextNodeBranch(IWDNode, String, String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, String)", logger);
        ContextReader cr = new ContextReader(node);
        FileInputStream fis = null;
        fis = new FileInputStream(FileUtils.getFullFilePath(filename, projectName));
        try {
            cr.read(fis);
        }
        catch (ContextIOException e) {
            String errorMess = MessageFormat.format("Originated by ContextIOException: \n{0}", e.getMessage());
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadContextNodeBranch(IWDNode, String, String)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("loadContextNodeBranch(IWDNode, String, String)", (Throwable)ioEx);
            CAFUIPublicLogger.exiting(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, String)", logger);
            throw ioEx;
        }
        fis.close();
        fis = null;
        cr = null;
        CAFUIPublicLogger.exiting(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, String)", logger);
    }

    public static void loadContextNodeBranch(IWDNode node, String filename, String projectName, int contextReaderSettings) throws IOException {
        String method = "loadContextNodeBranch(IWDNode, String, String, int)";
        CAFUIPublicLogger.entering(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, String, int)", logger);
        ContextReader cr = new ContextReader(node, contextReaderSettings);
        FileInputStream fis = null;
        fis = new FileInputStream(FileUtils.getFullFilePath(filename, projectName));
        try {
            cr.read(fis);
        }
        catch (ContextIOException e) {
            String errorMess = MessageFormat.format("Originated by ContextIOException: \n{0}", e.getMessage());
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadContextNodeBranch(IWDNode, String, String, int)", errorMess, e);
            errorMess = MessageFormat.format("Error on loading context node (node: {0},  file name: {1}, project name: {2}, resourceType: {3})", node.getNodeInfo().getName(), filename, projectName, Integer.toString(contextReaderSettings));
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadContextNodeBranch(IWDNode, String, String, int)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("loadContextNodeBranch(IWDNode, String, String, int)", (Throwable)ioEx);
            CAFUIPublicLogger.exiting(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, String, int)", logger);
            throw ioEx;
        }
        fis.close();
        fis = null;
        cr = null;
        CAFUIPublicLogger.exiting(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, String, int)", logger);
    }

    public static void loadContextNodeBranch(IWDNode node, String filename, WDDeployableObjectPart deployableObjectPart, int resourceType) throws IOException {
        FileUtils.loadContextNodeBranch(node, filename, deployableObjectPart, resourceType, false);
    }

    public static void loadContextNodeBranch(IWDNode node, String filename, WDDeployableObjectPart deployableObjectPart, int resourceType, boolean isRootFolderUsed) throws IOException {
        String method = "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)";
        CAFUIPublicLogger.entering(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", logger);
        ContextReader cr = new ContextReader(node);
        FileInputStream fis = FileUtils.getFileInputStream(filename, deployableObjectPart, resourceType, isRootFolderUsed);
        try {
            cr.read(fis);
        }
        catch (ContextIOException e) {
            String errorMess = MessageFormat.format("Originated by ContextIOException: \n{0}", e.getMessage());
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", errorMess, e);
            errorMess = MessageFormat.format("Error on loading context node (node: {0},  file name: {1}, deployable object part: {2}, resource type: {3}, isRootFolderUsed: {4})", node.getNodeInfo().getName(), filename, deployableObjectPart.getName(), Integer.toString(resourceType), Boolean.toString(isRootFolderUsed));
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", (Throwable)ioEx);
            CAFUIPublicLogger.exiting(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", logger);
            throw ioEx;
        }
        fis.close();
        fis = null;
        cr = null;
        CAFUIPublicLogger.exiting(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean)", logger);
    }

    public static void loadContextNodeBranch(IWDNode node, String filename, WDDeployableObjectPart deployableObjectPart, int resourceType, int contextReaderSettings) throws IOException {
        FileUtils.loadContextNodeBranch(node, filename, deployableObjectPart, resourceType, false, contextReaderSettings);
    }

    public static void loadContextNodeBranch(IWDNode node, String filename, WDDeployableObjectPart deployableObjectPart, int resourceType, boolean isRootFolderUsed, int contextReaderSettings) throws IOException {
        String method = "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean, int)";
        CAFUIPublicLogger.entering(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean, int)", logger);
        ContextReader cr = new ContextReader(node, contextReaderSettings);
        FileInputStream fis = FileUtils.getFileInputStream(filename, deployableObjectPart, resourceType, isRootFolderUsed);
        try {
            cr.read(fis);
        }
        catch (ContextIOException e) {
            String errorMess = MessageFormat.format("Originated by ContextIOException: \n{0},  ", e.getMessage());
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean, int)", errorMess, e);
            errorMess = MessageFormat.format("Error on loading context node (node: {0},  file name: {1}, deployable object part: {2}, resource type: {3}, isRootFolderUsed: {4})", node.getNodeInfo().getName(), filename, deployableObjectPart.getName(), Integer.toString(resourceType), Boolean.toString(isRootFolderUsed));
            CAFUIPublicLogger.traceThrowableT(100, logger, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean, int)", errorMess, e);
            IOException ioEx = new IOException(errorMess);
            logger.throwing("loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean, int)", (Throwable)ioEx);
            CAFUIPublicLogger.exiting(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean, int)", logger);
            throw ioEx;
        }
        fis.close();
        fis = null;
        cr = null;
        CAFUIPublicLogger.exiting(null, jARMRequest, "loadContextNodeBranch(IWDNode, String, WDDeployableObjectPart, int, boolean, int)", logger);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

