/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.core;

import com.sap.caf.ui.utils.cool.typedmodel.api.ICAFModelDefinition;
import com.sap.caf.ui.utils.cool.typedmodel.core.DualValueKey;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class CoreCAFModelDefinition
implements ICAFModelDefinition {
    private static final String ASPECT_ROW_TYPE_NOT_FOUND = "Type of aspect row not found: aspect \"{1}\", module \"{0}\"";
    private static final String QUERY_TYPE_NOT_FOUND = "Type of query not found: query \"{1}\", module \"{0}\"";
    private static final String ACTION_TYPE_NOT_FOUND = "Type of action not found: query \"{1}\", module \"{0}\"";
    private static final String PARAMETERS_TYPE_NOT_FOUND = "Type of parameters not found: executable(query/action) \"{1}\", module \"{0}\"";
    private final Map _aspectTypeMapping = new HashMap(20);
    private final Map _queryTypeMapping = new HashMap(20);
    private final Map _actionTypeMapping = new HashMap(20);
    private final Map _parametersTypeMapping = new HashMap(20);

    public CoreCAFModelDefinition() {
        this.init();
    }

    public Class typeOfAspectRow(String moduleName, String aspectName) {
        Object key = this.keyOf(moduleName, aspectName);
        Class type = (Class)this._aspectTypeMapping.get(key);
        if (null == type) {
            MessageFormat format = new MessageFormat(ASPECT_ROW_TYPE_NOT_FOUND);
            String message = format.format(new Object[]{moduleName, aspectName});
        }
        return type;
    }

    public Class typeOfQuery(String moduleName, String queryName) {
        Object key = this.keyOf(moduleName, queryName);
        Class type = (Class)this._queryTypeMapping.get(key);
        if (null == type) {
            MessageFormat format = new MessageFormat(QUERY_TYPE_NOT_FOUND);
            String message = format.format(new Object[]{moduleName, queryName});
        }
        return type;
    }

    public Class typeOfAction(String moduleName, String aspect, String actionName) {
        Object key = this.keyOf(moduleName, actionName);
        Class type = (Class)this._actionTypeMapping.get(key);
        if (null == type) {
            MessageFormat format = new MessageFormat(ACTION_TYPE_NOT_FOUND);
            String message = format.format(new Object[]{moduleName, actionName});
        }
        return type;
    }

    public Class typeOfParameters(String moduleName, String executableName) {
        Object key = this.keyOf(moduleName, executableName);
        Class type = (Class)this._parametersTypeMapping.get(key);
        if (null == type) {
            MessageFormat format = new MessageFormat(PARAMETERS_TYPE_NOT_FOUND);
            String message = format.format(new Object[]{moduleName, executableName});
        }
        return type;
    }

    protected abstract void init();

    protected final void registerAspectRowImpl(String moduleName, String aspectName, Class aspectRowType) {
        Object key = this.keyOf(moduleName, aspectName);
        if (this._aspectTypeMapping.containsKey(key)) {
            throw new IllegalStateException("Defenition already exists");
        }
        this._aspectTypeMapping.put(key, aspectRowType);
    }

    protected final void registerQueryImpl(String moduleName, String queryName, Class queryType) {
        Object key = this.keyOf(moduleName, queryName);
        if (this._queryTypeMapping.containsKey(key)) {
            throw new IllegalStateException("Defenition already exists");
        }
        this._queryTypeMapping.put(key, queryType);
    }

    protected final void registerActionImpl(String moduleName, String aspect, String actionName, Class actionType) {
        Object key = this.keyOf(moduleName, actionName);
        if (this._queryTypeMapping.containsKey(key)) {
            throw new IllegalStateException("Defenition already exists");
        }
        this._actionTypeMapping.put(key, actionType);
    }

    protected final void registerParametersImpl(String moduleName, String executableName, Class parametersType) {
        Object key = this.keyOf(moduleName, executableName);
        if (this._parametersTypeMapping.containsKey(key)) {
            throw new IllegalStateException("Defenition already exists");
        }
        this._parametersTypeMapping.put(key, parametersType);
    }

    private final Object keyOf(String a, String b) {
        return new DualValueKey(a, b);
    }
}

