/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.core;

import com.sap.caf.ui.utils.cool.CoolConnectionProperties;
import com.sap.caf.ui.utils.cool.CoolUtils;
import com.sap.caf.ui.utils.cool.CoolUtilsException;
import com.sap.caf.ui.utils.cool.typedmodel.api.ICAFServiceFactory;
import com.sap.caf.ui.utils.cool.typedmodel.core.CAFModelServiceFactory;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.webdynpro.services.session.IScope;
import com.sap.tc.webdynpro.services.session.ScopeType;
import com.sap.tc.webdynpro.services.session.Utils;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.IdentityHashMap;

public class ApplicationCAFServiceFactory
implements ICAFServiceFactory {
    private static final Object MODEL_FACTORIES_CACHE_KEY = new Serializable(){

        private Object readResolve() throws ObjectStreamException {
            return MODEL_FACTORIES_CACHE_KEY;
        }
    };

    public IServiceFacade getService() {
        CoolConnectionProperties properties = new CoolConnectionProperties(){

            public String getCoolHost() {
                return "caf";
            }
        };
        try {
            return CoolUtils.getServiceFacade(properties);
        }
        catch (CoolUtilsException exOnGetFacade) {
            throw new RuntimeException(exOnGetFacade);
        }
    }

    public final IServiceFacade getService(Class modelDefinition) {
        return this.getModelFactory(modelDefinition).adviseService(this.getService());
    }

    protected CAFModelServiceFactory getModelFactory(Class modelDefinition) {
        CAFModelServiceFactory factory;
        IScope scope = Utils.getScope((ScopeType)IScope.APPLICATION_SCOPE);
        IdentityHashMap<Class, CAFModelServiceFactory> cache = (IdentityHashMap<Class, CAFModelServiceFactory>)scope.get(MODEL_FACTORIES_CACHE_KEY);
        if (null == cache) {
            cache = new IdentityHashMap<Class, CAFModelServiceFactory>(10);
            scope.put(MODEL_FACTORIES_CACHE_KEY, (Object)scope);
        }
        if (null == (factory = (CAFModelServiceFactory)cache.get(modelDefinition))) {
            factory = new CAFModelServiceFactory(modelDefinition);
            cache.put(modelDefinition, factory);
        }
        return factory;
    }
}

